/* 
 * Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

// included in wbpublic.wr because of dependency on TreeModel

#ifndef _WF_GRTTREEVIEW_H_
#define _WF_GRTTREEVIEW_H_

using namespace System;
using namespace Windows::Forms;
using namespace System::Collections::Generic;

using namespace Aga::Controls::Tree;
using namespace Aga::Controls::Tree::NodeControls;

namespace MySQL {
  namespace Forms {

    /**
     * The ColumnEntry struct is used as temporary cache for columns being added before a model
     * was set.
     */
    private ref struct ColumnEntry
    {
      NodeControl^ nodeControl;
      int column;
      bool editable;
      bool isIcon;

      ColumnEntry(NodeControl^ control, int column, bool editable, bool isIcon)
      {
        this->nodeControl= control;
        this->column= column;
        this->editable= editable;
        this->isIcon= isIcon;
      }
    };

    /**
     * Helper class to forward double clicks on the node icon.
     */
    private ref class SwitchNodeIcon : public NodeIcon
    {
    public:
      virtual void MouseDoubleClick(TreeNodeAdvMouseEventArgs^ args) override;
    };

    /**
     * Helper class to show our own expand icons.
     */
    private ref class TriangleNodeControl : public NodeControl
    {
    private:
      System::Drawing::Bitmap^ _expanded_icon;
      System::Drawing::Bitmap^ _collapsed_icon;
      System::Drawing::Size _size; 
    public:
      TriangleNodeControl();

      virtual System::Drawing::Size MeasureSize(TreeNodeAdv^ node, DrawContext context) override;
      virtual void Draw(TreeNodeAdv^ node, DrawContext context) override;
      virtual void MouseDown(TreeNodeAdvMouseEventArgs^ args) override;
      virtual void MouseDoubleClick(TreeNodeAdvMouseEventArgs^ args) override;
    };

    /**
     * Helper class to forward double clicks for non-editable node texts.
     */
    private ref class SwitchNodeText : public NodeTextBox
    {
    protected:
      virtual void OnDrawText(DrawEventArgs^ args) override;
    public:
      virtual void MouseDoubleClick(TreeNodeAdvMouseEventArgs^ args) override;
    };

    /**
     * Wrapper for a native .NET treeview control with GRT bec::TreeModel data.
     * We use the TreeViewAdv control as we need multicolumn support.
     */
    public ref class GRTTreeViewImpl : public ViewImpl
    {
    private:
      MySQL::Grt::TreeModel^ _tree_model;
      MySQL::Grt::SimpleGrtTreeModel^ _model;
      List<ColumnEntry^> _columns;

      void add_node_control(NodeControl^ control, int column, bool editable, bool isIcon);

      // Event handlers.
      static void SelectionChanged(System::Object^ sender, EventArgs^ e);
      static void OnMouseDown(System::Object^ sender, MouseEventArgs^ e);

    protected:
      static bool create(::mforms::GRTTreeView *self, mforms::TreeOptions options);

      static void set_model(::mforms::GRTTreeView* self, bec::TreeModel* model);

      static int add_column(::mforms::GRTTreeView *self, ::mforms::GRTTreeColumnType type, int model_column, const std::string &title);
      static int add_column_editable(::mforms::GRTTreeView *self, ::mforms::GRTTreeColumnType type, int model_column, const std::string &title);

      static void refresh(mforms::GRTTreeView* self, const bec::NodeId& node);
      static void set_column_width(mforms::GRTTreeView* self, int column, int width);
      static bool get_selected_node(mforms::GRTTreeView* self, bec::NodeId& node);
      static int get_selection(mforms::GRTTreeView* self, std::vector<bec::NodeId>& nodes);
      static void set_expanded(mforms::GRTTreeView* self, const bec::NodeId& node, bool expanded);
      static void enable_asynch_loading(mforms::GRTTreeView* self, bool enabled);

      static void set_allow_multi_selection(mforms::GRTTreeView *self, bool flag);
      static void row_count_changed(mforms::GRTTreeView *self, const bec::NodeId& node, int old_count);

      void set_model(bec::TreeModel*);
    public:
      GRTTreeViewImpl(::mforms::GRTTreeView *self);
      ~GRTTreeViewImpl();

      int add_column(::mforms::GRTTreeColumnType type, int model_column, String ^name, bool editable);

      static void init(Manager ^mgr)
      {
        ::mforms::ControlFactory *f= ::mforms::ControlFactory::get_instance();

        DEF_CALLBACK2(bool, ::mforms::GRTTreeView*, mforms::TreeOptions, mgr, f->_grttreeview_impl, GRTTreeViewImpl, create);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, bec::TreeModel*, mgr, f->_grttreeview_impl, GRTTreeViewImpl, set_model);
        DEF_CALLBACK4(int, ::mforms::GRTTreeView*, ::mforms::GRTTreeColumnType, int, const std::string&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, add_column);
        DEF_CALLBACK4(int, ::mforms::GRTTreeView*, ::mforms::GRTTreeColumnType, int, const std::string&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, add_column_editable);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, const bec::NodeId &, mgr, f->_grttreeview_impl, GRTTreeViewImpl, refresh);
        DEF_CALLBACK3(void, ::mforms::GRTTreeView*, int, int, mgr, f->_grttreeview_impl, GRTTreeViewImpl, set_column_width);
        DEF_CALLBACK2(bool, ::mforms::GRTTreeView*, bec::NodeId&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, get_selected_node);
        DEF_CALLBACK2(int, ::mforms::GRTTreeView*, std::vector<bec::NodeId>&, mgr, f->_grttreeview_impl, GRTTreeViewImpl, get_selection);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, bool, mgr, f->_grttreeview_impl, GRTTreeViewImpl, set_allow_multi_selection);
        DEF_CALLBACK3(void, ::mforms::GRTTreeView*, const bec::NodeId&, int, mgr, f->_grttreeview_impl, GRTTreeViewImpl, row_count_changed);
        DEF_CALLBACK3(void, ::mforms::GRTTreeView*, const bec::NodeId&, bool, mgr, f->_grttreeview_impl, GRTTreeViewImpl, set_expanded);
        DEF_CALLBACK2(void, ::mforms::GRTTreeView*, bool, mgr, f->_grttreeview_impl, GRTTreeViewImpl, enable_asynch_loading);
      }
    };
  }
}

#endif // _WF_GRTTREEVIEW_H_