/* 
 * Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef __RECORDSET_TEXT_STORAGE_WR_H__
#define __RECORDSET_TEXT_STORAGE_WR_H__


#include "sqlide/recordset_text_storage.h"


namespace MySQL {
namespace Grt {
namespace Db {


public ref class Recordset_text_storage : public Recordset_data_storage
{
public:
  Recordset_text_storage(Recordset_data_storage ^ds)
    : Recordset_data_storage(ds->ref()),
    _inner(dynamic_cast<::Recordset_text_storage::Ref::pointer>((&ds->ref()).get()))
  {}
private:
  ::Recordset_text_storage::Ref::pointer _inner;

public:
  void parameter_value(String ^name, String ^value) { _inner->parameter_value(NativeToCppString(name), NativeToCppString(value)); }

public:
  void data_format(String ^format) { _inner->data_format(NativeToCppString(format)); }
  void file_path(String ^file_path) { _inner->file_path(NativeToCppString(file_path)); }
};


};  // namespace Db
};  // namespace Grt
};  // namespace MySQL


#endif // __RECORDSET_TEXT_STORAGE_WR_H__
