/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.IndexImpl;
import com.mysql.clusterj.tie.TableImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbDictionary;

class DictionaryImpl
implements Dictionary {
    static final I18NHelper local = I18NHelper.getInstance(DictionaryImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(DictionaryImpl.class);
    private NdbDictionary.Dictionary ndbDictionary;
    private ClusterConnectionImpl clusterConnection;

    public DictionaryImpl(NdbDictionary.Dictionary dictionary, ClusterConnectionImpl clusterConnectionImpl) {
        this.ndbDictionary = dictionary;
        this.clusterConnection = clusterConnectionImpl;
    }

    @Override
    public Table getTable(String string) {
        NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(string);
        if (tableConst == null) {
            tableConst = this.ndbDictionary.getTable(string.toLowerCase());
        }
        if (tableConst == null) {
            return null;
        }
        return new TableImpl(tableConst, this.getIndexNames(tableConst.getName()));
    }

    @Override
    public Index getIndex(String string, String string2, String string3) {
        if ("PRIMARY$KEY".equals(string)) {
            NdbDictionary.TableConst tableConst = this.ndbDictionary.getTable(string2);
            if (tableConst == null) {
                tableConst = this.ndbDictionary.getTable(string2.toLowerCase());
            }
            DictionaryImpl.handleError(tableConst, (NdbDictionary.DictionaryConst)this.ndbDictionary, "");
            return new IndexImpl(tableConst);
        }
        NdbDictionary.IndexConst indexConst = this.ndbDictionary.getIndex(string, string2);
        if (indexConst == null) {
            indexConst = this.ndbDictionary.getIndex(string, string2.toLowerCase());
        }
        DictionaryImpl.handleError(indexConst, (NdbDictionary.DictionaryConst)this.ndbDictionary, string3);
        return new IndexImpl(indexConst, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getIndexNames(String string) {
        String[] stringArray;
        NdbDictionary.DictionaryConst.List list = NdbDictionary.DictionaryConst.List.create();
        try {
            int n = this.ndbDictionary.listIndexes(list, string);
            DictionaryImpl.handleError(n, (NdbDictionary.DictionaryConst)this.ndbDictionary, string);
            int n2 = list.count();
            stringArray = new String[n2];
            if (logger.isDetailEnabled()) {
                logger.detail("Found " + n2 + " indexes for " + string);
            }
            NdbDictionary.DictionaryConst.ListConst.ElementArray elementArray = list.elements();
            for (int i = 0; i < n2; ++i) {
                String string2;
                NdbDictionary.DictionaryConst.ListConst.Element element = elementArray.at(i);
                DictionaryImpl.handleError(element, (NdbDictionary.DictionaryConst)this.ndbDictionary, String.valueOf(i));
                stringArray[i] = string2 = element.name();
            }
        }
        finally {
            NdbDictionary.DictionaryConst.List.delete(list);
        }
        return stringArray;
    }

    protected static void handleError(int n, NdbDictionary.DictionaryConst dictionaryConst, String string) {
        if (n == 0) {
            return;
        }
        Utility.throwError(n, dictionaryConst.getNdbError(), string);
    }

    protected static void handleError(Object object, NdbDictionary.DictionaryConst dictionaryConst, String string) {
        if (object != null) {
            return;
        }
        Utility.throwError(null, dictionaryConst.getNdbError(), string);
    }

    @Override
    public void removeCachedTable(String string) {
        this.ndbDictionary.removeCachedTable(string);
        this.clusterConnection.unloadSchema(string);
    }

    public NdbDictionary.Dictionary getNdbDictionary() {
        return this.ndbDictionary;
    }
}

