/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJDatastoreException;
import com.mysql.clusterj.ClusterJException;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class TransactionErrorSetPartitionKeyTest
extends AbstractClusterJModelTest {
    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(4);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
    }

    public void testCommit() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(0)));
        this.tx.commit();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(0)));
        try {
            this.tx.commit();
            this.error("flush with error did not throw an exception.");
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            this.errorIfNotEqual("Transaction.isActive()", false, this.tx.isActive());
        }
        try {
            this.session.setPartitionKey(Employee.class, (Object)0);
            this.tx.begin();
            this.session.find(Employee.class, (Object)0);
            this.tx.commit();
        }
        catch (ClusterJException clusterJException) {
            this.error("setPartitionKey; begin; find; commit caught: " + clusterJException.getMessage());
        }
        this.failOnError();
    }

    public void testFlushCommit() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(1)));
        this.tx.commit();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(1)));
        try {
            this.session.flush();
            this.error("flush with error did not throw an exception.");
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            this.errorIfNotEqual("Transaction.isActive()", true, this.tx.isActive());
            this.tx.commit();
        }
        try {
            this.session.setPartitionKey(Employee.class, (Object)1);
            this.tx.begin();
            this.session.find(Employee.class, (Object)1);
            this.tx.commit();
        }
        catch (ClusterJException clusterJException) {
            this.error("setPartitionKey; begin; find; commit caught throwable: " + clusterJException.getMessage());
        }
        this.failOnError();
    }

    public void testFlushRollback() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(2)));
        this.tx.commit();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(2)));
        try {
            this.session.flush();
            this.error("flush with error did not throw an exception.");
        }
        catch (ClusterJDatastoreException clusterJDatastoreException) {
            this.tx.rollback();
        }
        try {
            this.session.setPartitionKey(Employee.class, (Object)2);
            this.tx.begin();
            this.session.find(Employee.class, (Object)2);
            this.tx.commit();
        }
        catch (ClusterJException clusterJException) {
            this.error("setPartitionKey; begin; find; commit caught throwable: " + clusterJException.getMessage());
        }
        this.failOnError();
    }

    public void testRollback() {
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(3)));
        this.tx.commit();
        this.tx.begin();
        this.session.makePersistent((Object)((Employee)this.employees.get(3)));
        try {
            this.tx.rollback();
        }
        catch (ClusterJException clusterJException) {
            this.error("rollback threw: " + clusterJException.getMessage());
        }
        try {
            this.session.setPartitionKey(Employee.class, (Object)3);
            this.tx.begin();
            this.session.find(Employee.class, (Object)3);
            this.tx.commit();
        }
        catch (ClusterJException clusterJException) {
            this.error("setPartitionKey; begin; find; commit caught: " + clusterJException.getMessage());
        }
        this.failOnError();
    }
}

