/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.ColumnMetadata;
import com.mysql.clusterj.ColumnType;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.annotation.PersistenceCapable;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import testsuite.clusterj.AbstractClusterJModelTest;

public class DynamicObjectTest
extends AbstractClusterJModelTest {
    private static final String tablename = "t_basic";
    private static final int NUMBER_TO_INSERT = 5;
    private DynamicObject[] instances = new TBasic[5];
    private DynamicObject tbasic;
    private Object[] expectedTBasicNames = new Object[]{"id", "name", "age", "magic"};
    private Object[] expectedTBasicTypes = new Object[]{ColumnType.Int, ColumnType.Varchar, ColumnType.Int, ColumnType.Int};
    private Object[] expectedTBasicJavaTypes = new Object[]{Integer.TYPE, String.class, Integer.class, Integer.TYPE};
    private Object[] expectedTBasicMaximumLengths = new Object[]{1, 128, 1, 1};
    private Object[] expectedTBasicNumbers = new Object[]{0, 1, 2, 3};
    private Object[] expectedTBasicIsPrimaryKeys = new Object[]{true, false, false, false};
    private Object[] expectedTBasicIsPartitionKeys = new Object[]{true, false, false, false};
    private Object[] expectedTBasicPrecisions = new Object[]{0, 0, 0, 0};
    private Object[] expectedTBasicScales = new Object[]{0, 0, 0, 0};
    private Object[] expectedTBasicNullables = new Object[]{false, true, true, false};
    private Object[] expectedTBasicCharsetNames = new Object[]{null, "utf8mb4", null, null};

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createDynamicInstances(TBasic.class, 5);
        this.tbasic = this.instances[0];
        this.tx = this.session.currentTransaction();
        int n = 0;
        for (int i = 0; i < 5; ++i) {
            try {
                this.session.deletePersistent(TBasic.class, (Object)i);
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addTearDownClasses(TBasic.class);
    }

    private <T extends DynamicObject> void createDynamicInstances(Class<T> clazz, int n) {
        for (int i = 0; i < n; ++i) {
            DynamicObject dynamicObject = (DynamicObject)this.createInstance(clazz, i);
            dynamicObject.set(1, (Object)String.valueOf(i));
            dynamicObject.set(2, (Object)i);
            dynamicObject.set(3, (Object)i);
            this.instances[i] = dynamicObject;
        }
    }

    private <T> T createInstance(Class<T> clazz, int n) {
        Object object = this.session.newInstance(clazz, (Object)n);
        return (T)object;
    }

    public void test() {
        this.insert();
        this.find();
        this.findAnnotated();
        this.lookup();
        this.query();
        this.badClass(DynamicObjectPrivate.class);
        this.badClass(DynamicObjectProtectedConstructor.class);
        this.badClass(DynamicObjectNonStatic.class);
        this.badClass(DynamicObjectPrivateConstructor.class);
        this.badClass(DynamicObjectNullTableName.class);
        this.badClass(DynamicObjectTableDoesNotExist.class);
        this.checkMetadata();
        this.failOnError();
    }

    private void insert() {
        this.session.makePersistent((Object)this.instances);
    }

    private void find() {
        TBasic tBasic = (TBasic)((Object)this.session.find(TBasic.class, (Object)0));
        this.validateInstance(tBasic);
    }

    private void findAnnotated() {
        AnnotatedTBasic annotatedTBasic = (AnnotatedTBasic)((Object)this.session.find(AnnotatedTBasic.class, (Object)0));
        this.validateInstance(annotatedTBasic);
    }

    private void lookup() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(TBasic.class);
        queryDomainType.where(queryDomainType.get("magic").equal(queryDomainType.param("magic")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("magic", (Object)1);
        TBasic tBasic = (TBasic)((Object)query.getResultList().get(0));
        this.validateInstance(tBasic);
    }

    private void query() {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(TBasic.class);
        queryDomainType.where(queryDomainType.get("name").equal(queryDomainType.param("name")));
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("name", (Object)"2");
        TBasic tBasic = (TBasic)((Object)query.getResultList().get(0));
        this.validateInstance(tBasic);
    }

    private void validateInstance(DynamicObject dynamicObject) {
        int n = (Integer)dynamicObject.get(0);
        this.errorIfNotEqual("validate name", String.valueOf(n), dynamicObject.get(1));
        this.errorIfNotEqual("validate age", n, dynamicObject.get(2));
        this.errorIfNotEqual("validate magic", n, dynamicObject.get(3));
    }

    private void badClass(Class<?> clazz) {
        try {
            this.session.newInstance(clazz);
        }
        catch (ClusterJUserException clusterJUserException) {
        }
        catch (Throwable throwable) {
            this.error(clazz.getClass().getName() + " threw wrong exception: " + throwable.getMessage());
        }
    }

    protected void checkMetadata() {
        ColumnMetadata[] columnMetadataArray = this.tbasic.columnMetadata();
        for (int i = 0; i < columnMetadataArray.length; ++i) {
            this.errorIfNotEqual("t_basic column " + i + " name", this.expectedTBasicNames[i], columnMetadataArray[i].name());
            this.errorIfNotEqual("t_basic column " + i + " type", this.expectedTBasicTypes[i], columnMetadataArray[i].columnType());
            this.errorIfNotEqual("t_basic column " + i + " javaType", this.expectedTBasicJavaTypes[i], columnMetadataArray[i].javaType());
            this.errorIfNotEqual("t_basic column " + i + " maximumLength", this.expectedTBasicMaximumLengths[i], columnMetadataArray[i].maximumLength());
            this.errorIfNotEqual("t_basic column " + i + " charsetName", this.expectedTBasicCharsetNames[i], columnMetadataArray[i].charsetName());
            this.errorIfNotEqual("t_basic column " + i + " number", this.expectedTBasicNumbers[i], columnMetadataArray[i].number());
            this.errorIfNotEqual("t_basic column " + i + " isPrimaryKey", this.expectedTBasicIsPrimaryKeys[i], columnMetadataArray[i].isPrimaryKey());
            this.errorIfNotEqual("t_basic column " + i + " isPartitionKey", this.expectedTBasicIsPartitionKeys[i], columnMetadataArray[i].isPartitionKey());
            this.errorIfNotEqual("t_basic column " + i + " precision", this.expectedTBasicPrecisions[i], columnMetadataArray[i].precision());
            this.errorIfNotEqual("t_basic column " + i + " scale", this.expectedTBasicScales[i], columnMetadataArray[i].scale());
            this.errorIfNotEqual("t_basic column " + i + " nullable", this.expectedTBasicNullables[i], columnMetadataArray[i].nullable());
        }
    }

    public static class DynamicObjectNullTableName
    extends DynamicObject {
    }

    public static class DynamicObjectTableDoesNotExist
    extends DynamicObject {
        private DynamicObjectTableDoesNotExist() {
        }

        public String table() {
            return "DynamicObjectTableDoesNotExist";
        }
    }

    public static class DynamicObjectPrivateConstructor
    extends DynamicObject {
        private DynamicObjectPrivateConstructor() {
        }

        public String table() {
            return "DynamicObjectPrivateConstructor";
        }
    }

    public class DynamicObjectNonStatic
    extends DynamicObject {
        public String table() {
            return "DynamicObjectProtectedConstructor";
        }
    }

    private static class DynamicObjectPrivate
    extends DynamicObject {
        private DynamicObjectPrivate() {
        }
    }

    public static class DynamicObjectProtectedConstructor
    extends DynamicObject {
        protected DynamicObjectProtectedConstructor() {
        }

        public String table() {
            return "DynamicObjectProtectedConstructor";
        }
    }

    @PersistenceCapable(table="t_basic")
    public static class AnnotatedTBasic
    extends DynamicObject {
    }

    public static class TBasic
    extends DynamicObject {
        public String table() {
            return DynamicObjectTest.tablename;
        }
    }
}

