/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Blob;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.BlobImpl;
import com.mysql.clusterj.tie.ClusterConnectionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbBlob;
import com.mysql.ndbjtie.ndbapi.NdbErrorConst;
import com.mysql.ndbjtie.ndbapi.NdbOperation;
import com.mysql.ndbjtie.ndbapi.NdbRecAttr;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

class ResultDataImpl
implements ResultData {
    static final I18NHelper local = I18NHelper.getInstance(ResultDataImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(ResultDataImpl.class);
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;
    private NdbOperation ndbOperation = null;
    private NdbRecAttr[] ndbRecAttrs = null;
    private boolean nextDone;
    private ByteBuffer byteBuffer = null;
    private int[] offsets = null;
    private int[] lengths = null;
    private final Column[] storeColumns;
    private DbImpl.BufferManager bufferManager;
    private ClusterConnectionImpl clusterConnection;

    public ResultDataImpl(NdbOperation ndbOperation, List<Column> list, int n, int n2, int[] nArray, int[] nArray2, DbImpl.BufferManager bufferManager, boolean bl) {
        this.ndbOperation = ndbOperation;
        this.bufferManager = bufferManager;
        this.storeColumns = list.toArray(new Column[list.size()]);
        this.offsets = nArray;
        this.lengths = nArray2;
        this.byteBuffer = bl ? ByteBuffer.allocateDirect(n2) : bufferManager.getResultDataBuffer(n2);
        this.byteBuffer.order(ByteOrder.nativeOrder());
        this.ndbRecAttrs = new NdbRecAttr[n + 1];
        for (Column column : list) {
            NdbRecAttr ndbRecAttr = null;
            int n3 = column.getColumnId();
            this.byteBuffer.position(nArray[n3]);
            ndbRecAttr = nArray2[n3] == 0 ? ndbOperation.getValue(n3, null) : ndbOperation.getValue(n3, this.byteBuffer);
            this.handleError(ndbRecAttr, ndbOperation);
            this.ndbRecAttrs[n3] = ndbRecAttr;
        }
    }

    @Override
    public boolean next() {
        NdbErrorConst ndbErrorConst = this.ndbOperation.getNdbError();
        int n = ndbErrorConst.code();
        if (n != 0) {
            this.setNoResult();
        }
        if (this.nextDone) {
            return false;
        }
        this.nextDone = true;
        return true;
    }

    @Override
    public Blob getBlob(int n) {
        return this.getBlob(this.storeColumns[n]);
    }

    @Override
    public Blob getBlob(Column column) {
        NdbBlob ndbBlob = this.ndbOperation.getBlobHandle(column.getColumnId());
        this.handleError(ndbBlob, this.ndbOperation);
        return new BlobImpl(ndbBlob, this.clusterConnection.getByteBufferPool());
    }

    @Override
    public boolean getBoolean(int n) {
        return this.getBoolean(this.storeColumns[n]);
    }

    @Override
    public boolean getBoolean(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return Utility.getBoolean(column, ndbRecAttr);
    }

    @Override
    public boolean[] getBooleans(int n) {
        return this.getBooleans(this.storeColumns[n]);
    }

    @Override
    public boolean[] getBooleans(Column column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Not_Implemented"));
    }

    @Override
    public byte getByte(int n) {
        return this.getByte(this.storeColumns[n]);
    }

    @Override
    public byte getByte(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return Utility.getByte(column, ndbRecAttr);
    }

    @Override
    public short getShort(int n) {
        return this.getShort(this.storeColumns[n]);
    }

    @Override
    public short getShort(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return Utility.getShort(column, ndbRecAttr);
    }

    @Override
    public int getInt(int n) {
        return this.getInt(this.storeColumns[n]);
    }

    @Override
    public int getInt(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return Utility.getInt(column, ndbRecAttr);
    }

    @Override
    public long getLong(int n) {
        return this.getLong(this.storeColumns[n]);
    }

    @Override
    public long getLong(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return Utility.getLong(column, ndbRecAttr.int64_value());
    }

    @Override
    public float getFloat(int n) {
        return this.getFloat(this.storeColumns[n]);
    }

    @Override
    public float getFloat(Column column) {
        int n = column.getColumnId();
        float f = this.ndbRecAttrs[n].float_value();
        return f;
    }

    @Override
    public double getDouble(int n) {
        return this.getDouble(this.storeColumns[n]);
    }

    @Override
    public double getDouble(Column column) {
        int n = column.getColumnId();
        double d = this.ndbRecAttrs[n].double_value();
        return d;
    }

    @Override
    public String getString(int n) {
        return this.getString(this.storeColumns[n]);
    }

    @Override
    public String getString(Column column) {
        int n;
        int n2 = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n2];
        if (ndbRecAttr.isNULL() == 1) {
            return null;
        }
        int n3 = column.getPrefixLength();
        int n4 = this.offsets[n2];
        this.byteBuffer.limit(this.byteBuffer.capacity());
        switch (n3) {
            case 0: {
                n = this.lengths[n2];
                break;
            }
            case 1: {
                n = (this.byteBuffer.get(n4) + 256) % 256;
                ++n4;
                break;
            }
            case 2: {
                n = (this.byteBuffer.get(n4) + 256) % 256;
                int n5 = (this.byteBuffer.get(n4 + 1) + 256) % 256;
                n += 256 * n5;
                n4 += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", n3));
            }
        }
        this.byteBuffer.position(n4);
        this.byteBuffer.limit(n4 + n);
        String string = Utility.decode(this.byteBuffer, column.getCharsetNumber(), this.bufferManager);
        this.byteBuffer.clear();
        return string;
    }

    @Override
    public byte[] getBytes(int n) {
        return this.getBytes(this.storeColumns[n]);
    }

    @Override
    public byte[] getBytes(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        if (ndbRecAttr.isNULL() == 1) {
            return null;
        }
        int n2 = column.getPrefixLength();
        int n3 = this.lengths[n];
        int n4 = this.offsets[n];
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n3 = (this.byteBuffer.get(n4) + 256) % 256;
                ++n4;
                break;
            }
            case 2: {
                n3 = (this.byteBuffer.get(n4) + 256) % 256;
                int n5 = (this.byteBuffer.get(n4 + 1) + 256) % 256;
                n3 += 256 * n5;
                n4 += 2;
                break;
            }
            default: {
                throw new ClusterJFatalInternalException(local.message("ERR_Invalid_Prefix_Length", n2));
            }
        }
        this.byteBuffer.position(n4);
        byte[] byArray = new byte[n3];
        this.byteBuffer.get(byArray);
        return byArray;
    }

    @Override
    public Object getObject(int n) {
        return this.getObject(this.storeColumns[n]);
    }

    @Override
    public Object getObject(Column column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    public boolean wasNull(Column column) {
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public Boolean getObjectBoolean(int n) {
        return this.getObjectBoolean(this.storeColumns[n]);
    }

    @Override
    public Boolean getObjectBoolean(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        if (ndbRecAttr.isNULL() == 1) {
            return null;
        }
        byte by = ndbRecAttr.int8_value();
        Boolean bl = (by & 1) == 1;
        return bl;
    }

    @Override
    public Byte getObjectByte(int n) {
        return this.getObjectByte(this.storeColumns[n]);
    }

    @Override
    public Byte getObjectByte(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return ndbRecAttr.isNULL() == 1 ? null : Byte.valueOf(Utility.getByte(column, ndbRecAttr));
    }

    @Override
    public Short getObjectShort(int n) {
        return this.getObjectShort(this.storeColumns[n]);
    }

    @Override
    public Short getObjectShort(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return ndbRecAttr.isNULL() == 1 ? null : Short.valueOf(Utility.getShort(column, ndbRecAttr));
    }

    @Override
    public Integer getObjectInteger(int n) {
        return this.getObjectInteger(this.storeColumns[n]);
    }

    @Override
    public Integer getObjectInteger(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return ndbRecAttr.isNULL() == 1 ? null : Integer.valueOf(Utility.getInt(column, ndbRecAttr));
    }

    @Override
    public Long getObjectLong(int n) {
        return this.getObjectLong(this.storeColumns[n]);
    }

    @Override
    public Long getObjectLong(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return ndbRecAttr.isNULL() == 1 ? null : Long.valueOf(Utility.getLong(column, ndbRecAttr.int64_value()));
    }

    @Override
    public Float getObjectFloat(int n) {
        return this.getObjectFloat(this.storeColumns[n]);
    }

    @Override
    public Float getObjectFloat(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return ndbRecAttr.isNULL() == 1 ? null : Float.valueOf(this.getFloat(column));
    }

    @Override
    public Double getObjectDouble(int n) {
        return this.getObjectDouble(this.storeColumns[n]);
    }

    @Override
    public Double getObjectDouble(Column column) {
        int n = column.getColumnId();
        NdbRecAttr ndbRecAttr = this.ndbRecAttrs[n];
        return ndbRecAttr.isNULL() == 1 ? null : Double.valueOf(this.getDouble(column));
    }

    @Override
    public BigInteger getBigInteger(int n) {
        return this.getBigInteger(this.storeColumns[n]);
    }

    @Override
    public BigInteger getBigInteger(Column column) {
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        int n3 = column.getPrecision();
        int n4 = column.getScale();
        int n5 = Utility.getDecimalColumnSpace(n3, n4);
        this.byteBuffer.position(n2);
        return Utility.getBigInteger(this.byteBuffer, n5, n3, n4);
    }

    @Override
    public BigDecimal getDecimal(int n) {
        return this.getDecimal(this.storeColumns[n]);
    }

    @Override
    public BigDecimal getDecimal(Column column) {
        int n = column.getColumnId();
        int n2 = this.offsets[n];
        int n3 = column.getPrecision();
        int n4 = column.getScale();
        int n5 = Utility.getDecimalColumnSpace(n3, n4);
        this.byteBuffer.position(n2);
        return Utility.getDecimal(this.byteBuffer, n5, n3, n4);
    }

    private void handleError(Object object, NdbOperation ndbOperation) {
        if (object == null) {
            Utility.throwError(object, ndbOperation.getNdbError());
        }
    }

    public void setNoResult() {
        this.nextDone = true;
    }

    @Override
    public Column[] getColumns() {
        return this.storeColumns;
    }
}

