/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.util.ArrayList;
import java.util.List;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.model.VarbinaryPK;

public class VarbinaryPKTest
extends AbstractClusterJTest {
    protected int NUMBER_OF_INSTANCES = 15;
    protected List<VarbinaryPK> instances = new ArrayList<VarbinaryPK>();

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.tx = this.session.currentTransaction();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(VarbinaryPK.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.createInstances();
        this.addTearDownClasses(VarbinaryPK.class);
    }

    public void test() {
        this.insert();
        this.find();
        this.update();
        this.delete();
        this.failOnError();
    }

    protected void insert() {
        this.session.makePersistentAll(this.instances);
    }

    protected void find() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            byte[] byArray = this.getPK(i);
            VarbinaryPK varbinaryPK = (VarbinaryPK)this.session.find(VarbinaryPK.class, (Object)byArray);
            this.verify(varbinaryPK, i, false);
        }
    }

    protected void update() {
        Object object;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.createInstance(n);
            object.setName(this.getValue(this.NUMBER_OF_INSTANCES - n));
            this.session.updatePersistent(object);
            this.verify((VarbinaryPK)object, n, true);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 4) continue;
            object = this.getPK(n);
            VarbinaryPK varbinaryPK = (VarbinaryPK)this.session.find(VarbinaryPK.class, object);
            this.verify(varbinaryPK, n, true);
        }
    }

    protected void delete() {
        Object object;
        int n;
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.createInstance(n);
            this.session.deletePersistent(object);
        }
        for (n = 0; n < this.NUMBER_OF_INSTANCES; ++n) {
            if (0 != n % 5) continue;
            object = this.getPK(n);
            VarbinaryPK varbinaryPK = (VarbinaryPK)this.session.find(VarbinaryPK.class, object);
            this.errorIfNotEqual("Failed to delete instance: " + n, null, varbinaryPK);
        }
    }

    protected void createInstances() {
        for (int i = 0; i < this.NUMBER_OF_INSTANCES; ++i) {
            VarbinaryPK varbinaryPK = this.createInstance(i);
            if (this.getDebug()) {
                System.out.println(this.toString(varbinaryPK));
            }
            this.instances.add(varbinaryPK);
        }
    }

    protected VarbinaryPK createInstance(int n) {
        VarbinaryPK varbinaryPK = (VarbinaryPK)this.session.newInstance(VarbinaryPK.class);
        varbinaryPK.setId(this.getPK(n));
        varbinaryPK.setNumber(n);
        varbinaryPK.setName(this.getValue(n));
        return varbinaryPK;
    }

    protected String toString(VarbinaryPK varbinaryPK) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("VarbinaryPK[");
        stringBuffer.append(this.toString(varbinaryPK.getId()));
        stringBuffer.append("]: ");
        stringBuffer.append(varbinaryPK.getNumber());
        stringBuffer.append(", \"");
        stringBuffer.append(varbinaryPK.getName());
        stringBuffer.append("\".");
        return stringBuffer.toString();
    }

    protected byte[] getPK(int n) {
        return new byte[]{0, (byte)(n / 256), (byte)(n % 256)};
    }

    protected String getValue(int n) {
        return "Value " + n;
    }

    protected void verify(VarbinaryPK varbinaryPK, int n, boolean bl) {
        this.errorIfNotEqual("id failed", this.toString(this.getPK(n)), this.toString(varbinaryPK.getId()));
        this.errorIfNotEqual("number failed", n, varbinaryPK.getNumber());
        if (bl) {
            this.errorIfNotEqual("Value failed", this.getValue(this.NUMBER_OF_INSTANCES - n), varbinaryPK.getName());
        } else {
            this.errorIfNotEqual("Value failed", this.getValue(n), varbinaryPK.getName());
        }
    }

    private String toString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(String.valueOf(byArray[i]));
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }
}

