/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.LockMode;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.Session;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import testsuite.clusterj.AbstractClusterJTest;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.Employee;

public class QueryScanLockTest
extends AbstractQueryTest {
    private static final int numberOfTableScanNoLockThreads = 20;
    private static final long TWO_SECONDS = 2000L;
    private List<Thread> threadList = new ArrayList<Thread>();
    CyclicBarrier barrier;

    @Override
    public Class<?> getInstanceType() {
        return Employee.class;
    }

    @Override
    void createInstances(int n) {
        this.createEmployeeInstances(10);
        this.instances.addAll(this.employees);
    }

    @Override
    protected boolean getCleanupAfterTest() {
        return true;
    }

    @Override
    public boolean getDebug() {
        return false;
    }

    public void test() {
        this.scanVersusFind(true, LockMode.READ_COMMITTED, LockMode.READ_COMMITTED, 0, 0);
        this.scanVersusFind(true, LockMode.EXCLUSIVE, LockMode.READ_COMMITTED, 1, 1);
        this.scanVersusFind(true, LockMode.EXCLUSIVE, LockMode.EXCLUSIVE, 2, 12);
        this.scanVersusFind(true, LockMode.EXCLUSIVE, LockMode.SHARED, 3, 13);
        this.scanVersusFind(true, LockMode.READ_COMMITTED, LockMode.EXCLUSIVE, 4, 4);
        this.scanVersusFind(false, LockMode.READ_COMMITTED, LockMode.READ_COMMITTED, 5, 5);
        this.scanVersusFind(false, LockMode.EXCLUSIVE, LockMode.READ_COMMITTED, 6, 6);
        this.scanVersusFind(false, LockMode.EXCLUSIVE, LockMode.EXCLUSIVE, 7, 17);
        this.scanVersusFind(false, LockMode.EXCLUSIVE, LockMode.SHARED, 8, 18);
        this.scanVersusFind(false, LockMode.READ_COMMITTED, LockMode.EXCLUSIVE, 9, 9);
        this.failOnError();
    }

    private void scanVersusFind(boolean bl, LockMode lockMode, LockMode lockMode2, int n, int n2) {
        String string;
        this.barrier = new CyclicBarrier(21, new Runnable(){

            @Override
            public void run() {
                if (QueryScanLockTest.this.getDebug()) {
                    System.out.println("barrier completed.");
                }
            }
        });
        String string2 = string = bl ? "table" : "index";
        if (this.getDebug()) {
            System.out.println(string + " scan using scanLockMode: " + lockMode + "; findLockMode: " + lockMode2);
            System.out.flush();
        }
        Session session = this.sessionFactory.getSession();
        session.currentTransaction().begin();
        Employee[] employeeArray = null;
        employeeArray = bl ? this.scanTable(lockMode, session) : this.scanIndex(lockMode, session);
        AbstractClusterJTest.MyUncaughtExceptionHandler myUncaughtExceptionHandler = new AbstractClusterJTest.MyUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(myUncaughtExceptionHandler);
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Find find = new Find(lockMode2, this.sessionFactory.getSession(), n, n2);
        Thread thread = new Thread(threadGroup, find);
        this.threadList.add(thread);
        if (this.getDebug()) {
            System.out.println(string + " main starting find thread.");
        }
        thread.start();
        for (int i = 0; i < 20; ++i) {
            TableScanNoLock tableScanNoLock = new TableScanNoLock(this.sessionFactory.getSession());
            Thread thread2 = new Thread(threadGroup, tableScanNoLock);
            this.threadList.add(thread2);
            if (this.getDebug()) {
                System.out.println(string + " main starting no lock thread " + i);
            }
            thread2.start();
        }
        this.await(this.barrier);
        Employee employee = employeeArray[n];
        this.errorIfNotEqual(string + " found the wrong employee ", n, employee.getId());
        employee.setAge(n + 10);
        try {
            session.updatePersistent((Object)employee);
        }
        catch (Exception exception) {
            System.out.println(string + " scan updatePersistent(" + n + ") with lockmode " + lockMode + " got " + exception);
        }
        if (this.getDebug()) {
            System.out.println("Main committing update.");
        }
        try {
            session.currentTransaction().commit();
        }
        catch (Exception exception) {
            System.out.println(string + " scan commit got " + exception);
        }
        session.close();
        if (this.getDebug()) {
            System.out.println("Main joining threads.\n");
        }
        try {
            for (Thread thread2 : this.threadList) {
                thread2.join(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeException("Interrupted while joining threads.");
        }
    }

    private void await(CyclicBarrier cyclicBarrier) {
        try {
            if (this.getDebug()) {
                System.out.println("Awaiting...");
            }
            cyclicBarrier.await(15L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            this.error("await Interrupted!");
            interruptedException.printStackTrace();
        }
        catch (BrokenBarrierException brokenBarrierException) {
            this.error("await BrokenBarrier!");
            brokenBarrierException.printStackTrace();
        }
        catch (TimeoutException timeoutException) {
            this.error("await Timeout!");
            timeoutException.printStackTrace();
        }
    }

    private Employee[] scanTable(LockMode lockMode, Session session) {
        session.setLockMode(lockMode);
        QueryBuilder queryBuilder = session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        Query query = session.createQuery((QueryDefinition)queryDomainType);
        List list = query.getResultList();
        Employee[] employeeArray = new Employee[list.size()];
        for (Employee employee : list) {
            int n = employee.getId();
            employeeArray[n] = employee;
        }
        return employeeArray;
    }

    private Employee[] scanIndex(LockMode lockMode, Session session) {
        session.setLockMode(lockMode);
        QueryBuilder queryBuilder = session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        queryDomainType.get("age").between(queryDomainType.param("low"), queryDomainType.param("high"));
        Query query = session.createQuery((QueryDefinition)queryDomainType);
        query.setParameter("low", (Object)0);
        query.setParameter("high", (Object)9);
        List list = query.getResultList();
        Employee[] employeeArray = new Employee[list.size()];
        for (Employee employee : list) {
            int n = employee.getId();
            employeeArray[n] = employee;
        }
        return employeeArray;
    }

    private class Find
    implements Runnable {
        private final Session mySession;
        private final LockMode lockMode;
        private final int expectedAge;
        private final int id;

        private Find(LockMode lockMode, Session session, int n, int n2) {
            this.mySession = session;
            this.lockMode = lockMode;
            this.expectedAge = n2;
            this.id = n;
        }

        @Override
        public void run() {
            int n;
            this.mySession.currentTransaction().begin();
            this.mySession.setLockMode(this.lockMode);
            if (QueryScanLockTest.this.getDebug()) {
                System.out.println("Find thread performing find with lockMode " + this.lockMode);
            }
            Employee employee = null;
            try {
                employee = (Employee)this.mySession.find(Employee.class, (Object)this.id);
            }
            catch (Exception exception) {
                System.out.println("Find(" + this.id + ") with lockmode " + this.lockMode + " got " + exception);
            }
            if (QueryScanLockTest.this.getDebug()) {
                System.out.println("Find thread found employee " + this.id);
            }
            if ((n = employee.getAge().intValue()) != this.expectedAge) {
                System.out.println("Find thread found employee with wrong age; expected: " + this.expectedAge + "; actual: " + n);
            }
            QueryScanLockTest.this.errorIfNotEqual("Find thread found employee with wrong age", this.expectedAge, n);
            if (QueryScanLockTest.this.getDebug()) {
                System.out.println("Find thread performing commit.");
            }
            this.mySession.currentTransaction().commit();
            this.mySession.close();
            if (QueryScanLockTest.this.getDebug()) {
                System.out.println("Find thread DONE!");
            }
        }
    }

    private class TableScanNoLock
    implements Runnable {
        private final Session mySession;

        private TableScanNoLock(Session session) {
            this.mySession = session;
        }

        @Override
        public void run() {
            QueryScanLockTest.this.scanTable(LockMode.READ_COMMITTED, this.mySession);
            if (QueryScanLockTest.this.getDebug()) {
                System.out.println("TableScanNoLock thread DONE!");
            }
            try {
                QueryScanLockTest.this.barrier.await();
            }
            catch (InterruptedException interruptedException) {
                QueryScanLockTest.this.error("await Interrupted!");
                interruptedException.printStackTrace();
            }
            catch (BrokenBarrierException brokenBarrierException) {
                QueryScanLockTest.this.error("await BrokenBarrier!");
                brokenBarrierException.printStackTrace();
            }
            this.mySession.close();
        }
    }
}

