/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj;

import com.mysql.clusterj.ClusterJFatalUserException;
import com.mysql.clusterj.Dbug;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.SessionFactoryService;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class ClusterJHelper {
    static ClassLoader CLUSTERJ_HELPER_CLASS_LOADER = ClusterJHelper.class.getClassLoader();

    public static Dbug newDbug() {
        return ClusterJHelper.getServiceInstance(Dbug.class);
    }

    public static SessionFactory getSessionFactory(Map map) {
        return ClusterJHelper.getSessionFactory(map, CLUSTERJ_HELPER_CLASS_LOADER);
    }

    public static SessionFactory getSessionFactory(Map map, ClassLoader classLoader) {
        SessionFactoryService sessionFactoryService = ClusterJHelper.getServiceInstance(SessionFactoryService.class, classLoader);
        SessionFactory sessionFactory = sessionFactoryService.getSessionFactory(map);
        return sessionFactory;
    }

    public static <T> T getServiceInstance(Class<T> clazz) {
        return ClusterJHelper.getServiceInstance(clazz, CLUSTERJ_HELPER_CLASS_LOADER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> getServiceInstances(Class<T> clazz, ClassLoader classLoader, StringBuffer stringBuffer) {
        ArrayList arrayList = new ArrayList();
        String string = clazz.getName();
        String string2 = "META-INF/services/" + string;
        Enumeration<URL> enumeration = null;
        try {
            enumeration = classLoader.getResources(string2);
        }
        catch (IOException iOException) {
            throw new ClusterJFatalUserException(iOException);
        }
        while (enumeration.hasMoreElements()) {
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader bufferedReader = null;
            try {
                URL uRL = enumeration.nextElement();
                inputStream = uRL.openStream();
                inputStreamReader = new InputStreamReader(inputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                string = bufferedReader.readLine();
                Class<?> clazz2 = Class.forName(string, true, classLoader);
                Object obj = clazz2.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj == null) continue;
                arrayList.add(obj);
            }
            catch (IOException iOException) {
                stringBuffer.append(iOException.toString());
            }
            catch (ClassNotFoundException classNotFoundException) {
                stringBuffer.append(classNotFoundException.toString());
            }
            catch (InstantiationException instantiationException) {
                stringBuffer.append(instantiationException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                stringBuffer.append(illegalAccessException.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                stringBuffer.append(invocationTargetException.toString());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                stringBuffer.append(noSuchMethodException.toString());
            }
            finally {
                try {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList;
    }

    public static <T> T getServiceInstance(Class<T> clazz, ClassLoader classLoader) {
        StringBuffer stringBuffer = new StringBuffer();
        List<T> list = ClusterJHelper.getServiceInstances(clazz, classLoader, stringBuffer);
        if (list.size() != 0) {
            return list.get(0);
        }
        String string = clazz.getName();
        String string2 = "META-INF/services/" + string;
        throw new ClusterJFatalUserException("No instance for service " + string + " could be found. Make sure that there is a file " + string2 + " in your class path naming the factory class." + stringBuffer);
    }

    public static <T> T getServiceInstance(Class<T> clazz, String string, ClassLoader classLoader) {
        if (string == null) {
            return ClusterJHelper.getServiceInstance(clazz, classLoader);
        }
        try {
            Class<?> clazz2 = Class.forName(string, true, classLoader);
            Class<?> clazz3 = null;
            if (!clazz.isAssignableFrom(clazz2)) {
                throw new ClassCastException(clazz.getName() + " " + string);
            }
            clazz3 = clazz2;
            Object obj = clazz3.getConstructor(new Class[0]).newInstance(new Object[0]);
            return (T)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ClusterJFatalUserException(string, classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new ClusterJFatalUserException(string, classCastException);
        }
        catch (InstantiationException instantiationException) {
            throw new ClusterJFatalUserException(string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClusterJFatalUserException(string, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ClusterJFatalUserException(string, invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ClusterJFatalUserException(string, noSuchMethodException);
        }
    }

    public static <T> T getServiceInstance(Class<T> clazz, String string) {
        return ClusterJHelper.getServiceInstance(clazz, string, CLUSTERJ_HELPER_CLASS_LOADER);
    }

    public static boolean getBooleanProperty(String string, String string2) {
        String string3 = System.getenv(string);
        String string4 = System.getProperty(string, string3 == null ? string2 : string3);
        boolean bl = string4.equals("true");
        return bl;
    }

    public static String getStringProperty(String string, String string2) {
        String string3 = System.getenv(string);
        String string4 = System.getProperty(string, string3 == null ? string2 : string3);
        return string4;
    }
}

