/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.tie;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.core.store.Column;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.tie.ClusterTransactionImpl;
import com.mysql.clusterj.tie.DbImpl;
import com.mysql.clusterj.tie.ScanOperationImpl;
import com.mysql.clusterj.tie.Utility;
import com.mysql.ndbjtie.ndbapi.NdbIndexScanOperation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

class IndexScanOperationImpl
extends ScanOperationImpl
implements IndexScanOperation {
    static final I18NHelper local = I18NHelper.getInstance(IndexScanOperationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(IndexScanOperationImpl.class);
    private NdbIndexScanOperation ndbIndexScanOperation;
    private DbImpl.BufferManager bufferManager;

    public IndexScanOperationImpl(Table table, NdbIndexScanOperation ndbIndexScanOperation, ClusterTransactionImpl clusterTransactionImpl) {
        super(table, ndbIndexScanOperation, clusterTransactionImpl);
        this.ndbIndexScanOperation = ndbIndexScanOperation;
        this.bufferManager = clusterTransactionImpl.getBufferManager();
    }

    @Override
    public void setBoundBigInteger(Column column, IndexScanOperation.BoundType boundType, BigInteger bigInteger) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, bigInteger));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundByte(Column column, IndexScanOperation.BoundType boundType, byte by) {
        ByteBuffer byteBuffer = this.bufferManager.borrowBuffer(1);
        Utility.convertValue(byteBuffer, column, by);
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), byteBuffer);
        this.bufferManager.returnBuffer(1, byteBuffer);
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundBytes(Column column, IndexScanOperation.BoundType boundType, byte[] byArray) {
        ByteBuffer byteBuffer = this.bufferManager.borrowBuffer(byArray.length + 3);
        Utility.convertValue(byteBuffer, column, byArray);
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), byteBuffer);
        this.bufferManager.returnBuffer(byArray.length + 3, byteBuffer);
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundDecimal(Column column, IndexScanOperation.BoundType boundType, BigDecimal bigDecimal) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, bigDecimal));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundDouble(Column column, IndexScanOperation.BoundType boundType, Double d) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, d));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundFloat(Column column, IndexScanOperation.BoundType boundType, Float f) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, f.floatValue()));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundShort(Column column, IndexScanOperation.BoundType boundType, short s) {
        ByteBuffer byteBuffer = this.bufferManager.borrowBuffer(2);
        Utility.convertValue(byteBuffer, column, s);
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), byteBuffer);
        this.bufferManager.returnBuffer(2, byteBuffer);
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundInt(Column column, IndexScanOperation.BoundType boundType, Integer n) {
        ByteBuffer byteBuffer = this.bufferManager.borrowBuffer(4);
        Utility.convertValue(byteBuffer, column, n);
        int n2 = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), byteBuffer);
        this.bufferManager.returnBuffer(4, byteBuffer);
        this.handleError(n2, this.ndbIndexScanOperation);
    }

    public void setBoundInt(Column column, IndexScanOperation.BoundType boundType, int n) {
        ByteBuffer byteBuffer = this.bufferManager.borrowBuffer(4);
        Utility.convertValue(byteBuffer, column, n);
        int n2 = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), byteBuffer);
        this.bufferManager.returnBuffer(4, byteBuffer);
        this.handleError(n2, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundLong(Column column, IndexScanOperation.BoundType boundType, long l) {
        ByteBuffer byteBuffer = this.bufferManager.borrowBuffer(8);
        Utility.convertValue(byteBuffer, column, l);
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), byteBuffer);
        this.bufferManager.returnBuffer(8, byteBuffer);
        this.handleError(n, this.ndbIndexScanOperation);
    }

    @Override
    public void setBoundString(Column column, IndexScanOperation.BoundType boundType, String string) {
        int n = this.ndbIndexScanOperation.setBound(column.getName(), this.convertBoundType(boundType), Utility.convertValue(column, string));
        this.handleError(n, this.ndbIndexScanOperation);
    }

    private int convertBoundType(IndexScanOperation.BoundType boundType) {
        switch (boundType) {
            case BoundEQ: {
                return 4;
            }
            case BoundGE: {
                return 2;
            }
            case BoundGT: {
                return 3;
            }
            case BoundLE: {
                return 0;
            }
            case BoundLT: {
                return 1;
            }
        }
        throw new ClusterJFatalInternalException(local.message("ERR_Implementation_Should_Not_Occur"));
    }

    @Override
    public void endBound(int n) {
        if (logger.isDetailEnabled()) {
            logger.detail("IndexScanOperationImpl.endBound(" + n + ")");
        }
        int n2 = this.ndbIndexScanOperation.end_of_bound(n);
        this.handleError(n2, this.ndbIndexScanOperation);
    }
}

