/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.Predicate;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Dn2id;

public class MultiplePKTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_OF_INSTANCES = 10;
    QueryBuilder builder;
    QueryDomainType dobj;
    Predicate equalA0;
    Predicate equalA1;
    Predicate equalA2;
    Predicate equalA3;
    Predicate lessEqualA3;
    Predicate greaterEqualA3;
    Predicate lessA3;
    Predicate greaterA3;
    Predicate betweenA3;
    Predicate equalA4;
    Predicate equalA5;
    Predicate equalA6;
    Predicate equalA7;
    Predicate equalA8;
    Predicate equalA9;
    Predicate equalA10;
    Predicate equalA11;
    Predicate equalA12;
    Predicate equalA13;
    Predicate equalA14;
    Predicate equalA15;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        try {
            this.tx.begin();
            this.session.deletePersistentAll(Dn2id.class);
            this.tx.commit();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.addTearDownClasses(Dn2id.class);
    }

    protected void setupQuery() {
        this.builder = this.session.getQueryBuilder();
        this.dobj = this.builder.createQueryDefinition(Dn2id.class);
        this.equalA0 = this.dobj.get("a0").equal(this.dobj.param("a0"));
        this.equalA1 = this.dobj.get("a1").equal(this.dobj.param("a1"));
        this.equalA2 = this.dobj.get("a2").equal(this.dobj.param("a2"));
        this.equalA3 = this.dobj.get("a3").equal(this.dobj.param("a3"));
        this.lessA3 = this.dobj.get("a3").lessThan(this.dobj.param("a3Upper"));
        this.lessEqualA3 = this.dobj.get("a3").lessEqual(this.dobj.param("a3Upper"));
        this.greaterA3 = this.dobj.get("a3").greaterThan(this.dobj.param("a3Lower"));
        this.greaterEqualA3 = this.dobj.get("a3").greaterEqual(this.dobj.param("a3Lower"));
        this.betweenA3 = this.dobj.get("a3").between(this.dobj.param("a3Lower"), this.dobj.param("a3Upper"));
        this.equalA4 = this.dobj.get("a4").equal(this.dobj.param("a4"));
        this.equalA5 = this.dobj.get("a5").equal(this.dobj.param("a5"));
        this.equalA6 = this.dobj.get("a6").equal(this.dobj.param("a6"));
        this.equalA7 = this.dobj.get("a7").equal(this.dobj.param("a7"));
        this.equalA8 = this.dobj.get("a8").equal(this.dobj.param("a8"));
        this.equalA9 = this.dobj.get("a9").equal(this.dobj.param("a9"));
        this.equalA10 = this.dobj.get("a10").equal(this.dobj.param("a10"));
        this.equalA11 = this.dobj.get("a11").equal(this.dobj.param("a11"));
        this.equalA12 = this.dobj.get("a12").equal(this.dobj.param("a12"));
        this.equalA13 = this.dobj.get("a13").equal(this.dobj.param("a13"));
        this.equalA14 = this.dobj.get("a14").equal(this.dobj.param("a14"));
        this.equalA15 = this.dobj.get("a15").equal(this.dobj.param("a15"));
    }

    public void test() {
        this.insert();
        this.findByPrimaryKey();
        this.queryEqualPartialPrimaryKey();
        this.queryLessEqualGreaterEqualPartialPrimaryKey();
        this.queryLessGreaterEqualPartialPrimaryKey();
        this.queryLessEqualGreaterPartialPrimaryKey();
        this.queryLessGreaterPartialPrimaryKey();
        this.queryBetweenPartialPrimaryKey();
        this.queryCompletePrimaryKey();
        this.update();
        this.delete();
        this.failOnError();
    }

    private void insert() {
        this.createDn2idInstances(10);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.dn2ids);
        this.tx.commit();
    }

    protected void findByPrimaryKey() {
        this.tx.begin();
        for (int i = 0; i < 10; ++i) {
            MultiplePKTest.dn2idPK[1] = this.getA1for(10, i);
            MultiplePKTest.dn2idPK[3] = "employeenumber=100000" + i;
            int n = i;
            Dn2id dn2id = (Dn2id)this.session.find(Dn2id.class, (Object)dn2idPK);
            long l = dn2id.getEid();
            if ((long)n == l) continue;
            this.error("findByPrimaryKey failed to find dn2id " + i + " expected eid " + n + " actual eid " + l);
        }
        this.tx.commit();
    }

    private void queryEqualPartialPrimaryKey() {
        this.tx.begin();
        this.setupQuery();
        this.dobj.where(this.equalA0.and(this.equalA1.and(this.equalA2.and(this.equalA3))));
        Query query = this.session.createQuery((QueryDefinition)this.dobj);
        query.setParameter("a0", (Object)"dc=com");
        query.setParameter("a1", (Object)this.getA1for(10, 8));
        query.setParameter("a2", (Object)"ou=people");
        query.setParameter("a3", (Object)this.getA3for(8L));
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("queryEqualPartialPrimaryKey wrong Dn2id eids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    private void queryLessEqualGreaterEqualPartialPrimaryKey() {
        this.tx.begin();
        this.setupQuery();
        this.dobj.where(this.equalA0.and(this.equalA1.and(this.equalA2.and(this.lessEqualA3.and(this.greaterEqualA3)))));
        Query query = this.session.createQuery((QueryDefinition)this.dobj);
        query.setParameter("a0", (Object)"dc=com");
        query.setParameter("a1", (Object)this.getA1for(10, 8));
        query.setParameter("a2", (Object)"ou=people");
        query.setParameter("a3Upper", (Object)this.getA3for(9L));
        query.setParameter("a3Lower", (Object)this.getA3for(8L));
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        hashSet.add(9L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("queryLessEqualGreaterEqualPartialPrimaryKey wrong Dn2id eids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    private void queryLessGreaterEqualPartialPrimaryKey() {
        this.tx.begin();
        this.setupQuery();
        this.dobj.where(this.equalA0.and(this.equalA1.and(this.equalA2.and(this.lessA3.and(this.greaterEqualA3)))));
        Query query = this.session.createQuery((QueryDefinition)this.dobj);
        query.setParameter("a0", (Object)"dc=com");
        query.setParameter("a1", (Object)this.getA1for(10, 8));
        query.setParameter("a2", (Object)"ou=people");
        query.setParameter("a3Lower", (Object)this.getA3for(8L));
        query.setParameter("a3Upper", (Object)this.getA3for(9L));
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("queryLessGreaterEqualPartialPrimaryKey wrong Dn2id eids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    private void queryLessEqualGreaterPartialPrimaryKey() {
        this.tx.begin();
        this.setupQuery();
        this.dobj.where(this.equalA0.and(this.equalA1.and(this.equalA2.and(this.lessEqualA3.and(this.greaterA3)))));
        Query query = this.session.createQuery((QueryDefinition)this.dobj);
        query.setParameter("a0", (Object)"dc=com");
        query.setParameter("a1", (Object)this.getA1for(10, 8));
        query.setParameter("a2", (Object)"ou=people");
        query.setParameter("a3Lower", (Object)this.getA3for(7L));
        query.setParameter("a3Upper", (Object)this.getA3for(8L));
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("queryLessEqualGreaterPartialPrimaryKey wrong Dn2id eids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    private void queryLessGreaterPartialPrimaryKey() {
        this.tx.begin();
        this.setupQuery();
        this.dobj.where(this.equalA0.and(this.equalA1.and(this.equalA2.and(this.lessA3.and(this.greaterA3)))));
        Query query = this.session.createQuery((QueryDefinition)this.dobj);
        query.setParameter("a0", (Object)"dc=com");
        query.setParameter("a1", (Object)this.getA1for(10, 8));
        query.setParameter("a2", (Object)"ou=people");
        query.setParameter("a3Lower", (Object)this.getA3for(7L));
        query.setParameter("a3Upper", (Object)this.getA3for(9L));
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("queryLessGreaterPartialPrimaryKey wrong Dn2id eids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    private void queryBetweenPartialPrimaryKey() {
        this.tx.begin();
        this.setupQuery();
        this.dobj.where(this.equalA0.and(this.equalA1.and(this.equalA2.and(this.betweenA3))));
        Query query = this.session.createQuery((QueryDefinition)this.dobj);
        query.setParameter("a0", (Object)"dc=com");
        query.setParameter("a1", (Object)this.getA1for(10, 8));
        query.setParameter("a2", (Object)"ou=people");
        query.setParameter("a3Lower", (Object)this.getA3for(8L));
        query.setParameter("a3Upper", (Object)this.getA3for(9L));
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        hashSet.add(9L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("queryBetweenPartialPrimaryKey wrong Dn2id eids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    private void queryCompletePrimaryKey() {
        this.tx.begin();
        this.setupQuery();
        this.dobj.where(this.equalA0.and(this.equalA1.and(this.equalA2.and(this.equalA3))).and(this.equalA4.and(this.equalA5.and(this.equalA6.and(this.equalA7)))).and(this.equalA8.and(this.equalA9.and(this.equalA10.and(this.equalA11)))).and(this.equalA12.and(this.equalA13.and(this.equalA14.and(this.equalA15)))));
        Query query = this.session.createQuery((QueryDefinition)this.dobj);
        query.setParameter("a0", (Object)"dc=com");
        query.setParameter("a1", (Object)this.getA1for(10, 8));
        query.setParameter("a2", (Object)"ou=people");
        query.setParameter("a3", (Object)this.getA3for(8L));
        query.setParameter("a4", (Object)"");
        query.setParameter("a5", (Object)"");
        query.setParameter("a6", (Object)"");
        query.setParameter("a7", (Object)"");
        query.setParameter("a8", (Object)"");
        query.setParameter("a9", (Object)"");
        query.setParameter("a10", (Object)"");
        query.setParameter("a11", (Object)"");
        query.setParameter("a12", (Object)"");
        query.setParameter("a13", (Object)"");
        query.setParameter("a14", (Object)"");
        query.setParameter("a15", (Object)"");
        List list = query.getResultList();
        this.consistencyCheck(list);
        HashSet<Long> hashSet = new HashSet<Long>();
        hashSet.add(8L);
        HashSet<Long> hashSet2 = new HashSet<Long>();
        for (Dn2id dn2id : list) {
            hashSet2.add(dn2id.getEid());
        }
        this.errorIfNotEqual("queryCompletePrimaryKey wrong Dn2id eids returned from query: ", hashSet, hashSet2);
        this.tx.commit();
    }

    private void queryUniqueKey() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void update() {
        long l;
        Dn2id dn2id;
        long l2;
        int n;
        this.tx.begin();
        ArrayList<Dn2id> arrayList = new ArrayList<Dn2id>();
        for (n = 0; n < 10; ++n) {
            MultiplePKTest.dn2idPK[1] = this.getA1for(10, n);
            MultiplePKTest.dn2idPK[3] = "employeenumber=100000" + n;
            l2 = n;
            dn2id = (Dn2id)this.session.find(Dn2id.class, (Object)dn2idPK);
            l = dn2id.getEid();
            if (l2 != l) {
                this.error("Failed to find dn2id " + n + " expected eid " + l2 + " actual eid " + l);
            }
            dn2id.setEid(10L + dn2id.getEid());
            arrayList.add(dn2id);
        }
        this.session.updatePersistentAll(arrayList);
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 10; ++n) {
            MultiplePKTest.dn2idPK[1] = this.getA1for(10, n);
            MultiplePKTest.dn2idPK[3] = "employeenumber=100000" + n;
            l2 = 10 + n;
            dn2id = (Dn2id)this.session.find(Dn2id.class, (Object)dn2idPK);
            l = dn2id.getEid();
            if (l2 == l) continue;
            this.error("Failed to find updated dn2id " + n + " expected eid " + l2 + " actual eid " + l);
        }
        this.tx.commit();
    }

    private void delete() {
        this.tx.begin();
        for (int i = 0; i < 10; ++i) {
            MultiplePKTest.dn2idPK[1] = this.getA1for(10, i);
            MultiplePKTest.dn2idPK[3] = "employeenumber=100000" + i;
            this.session.deletePersistent(Dn2id.class, (Object)dn2idPK);
        }
        this.tx.commit();
    }
}

