/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.core;

import com.mysql.clusterj.ClusterJException;
import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJUserException;
import com.mysql.clusterj.DynamicObject;
import com.mysql.clusterj.DynamicObjectDelegate;
import com.mysql.clusterj.LockMode;
import com.mysql.clusterj.Query;
import com.mysql.clusterj.Transaction;
import com.mysql.clusterj.core.CacheManager;
import com.mysql.clusterj.core.SessionFactoryImpl;
import com.mysql.clusterj.core.StateManager;
import com.mysql.clusterj.core.StoreManager;
import com.mysql.clusterj.core.TransactionImpl;
import com.mysql.clusterj.core.query.QueryBuilderImpl;
import com.mysql.clusterj.core.query.QueryDomainTypeImpl;
import com.mysql.clusterj.core.query.QueryImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.SessionSPI;
import com.mysql.clusterj.core.spi.SmartValueHandler;
import com.mysql.clusterj.core.spi.ValueHandler;
import com.mysql.clusterj.core.store.ClusterTransaction;
import com.mysql.clusterj.core.store.Db;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.store.Index;
import com.mysql.clusterj.core.store.IndexOperation;
import com.mysql.clusterj.core.store.IndexScanOperation;
import com.mysql.clusterj.core.store.Operation;
import com.mysql.clusterj.core.store.PartitionKey;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.store.ScanOperation;
import com.mysql.clusterj.core.store.Table;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SessionImpl
implements SessionSPI,
CacheManager,
StoreManager {
    static final I18NHelper local = I18NHelper.getInstance(SessionImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(SessionImpl.class);
    protected SessionFactoryImpl factory;
    protected Db db;
    protected Dictionary dictionary;
    protected TransactionImpl transactionImpl;
    protected PartitionKey partitionKey = null;
    protected boolean rollbackOnly = false;
    protected ClusterTransaction clusterTransaction;
    protected String joinTransactionId = null;
    protected Map properties;
    protected final int RESULT_READY = 0;
    protected final int SCAN_FINISHED = 1;
    protected final int CACHE_EMPTY = 2;
    protected List<StateManager> changeList = new ArrayList<StateManager>();
    protected List<Runnable> postExecuteOperations = new ArrayList<Runnable>();
    protected TransactionState transactionState;
    private ClusterJException transactionException;
    protected int nestedAutoTransactionCounter = 0;
    protected int numberOfRetries = 5;
    private LockMode lockmode = LockMode.READ_COMMITTED;
    protected TransactionState transactionStateNotActive = new TransactionState(){

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public TransactionState begin() {
            try {
                SessionImpl.this.internalBegin();
                return SessionImpl.this.transactionStateActive;
            }
            catch (ClusterJException clusterJException) {
                SessionImpl.this.transactionException = clusterJException;
                return SessionImpl.this.transactionStateNotActive;
            }
        }

        @Override
        public TransactionState commit() {
            SessionImpl.this.transactionException = new ClusterJUserException(local.message("ERR_Transaction_Must_Be_Active_For_Method", (Object)"commit"));
            return SessionImpl.this.transactionStateNotActive;
        }

        @Override
        public TransactionState rollback() {
            SessionImpl.this.transactionException = new ClusterJUserException(local.message("ERR_Transaction_Must_Be_Active_For_Method", (Object)"rollback"));
            return SessionImpl.this.transactionStateNotActive;
        }

        @Override
        public TransactionState start() {
            try {
                SessionImpl.this.internalBegin();
                SessionImpl.this.clusterTransaction.setAutocommit(true);
                SessionImpl.this.nestedAutoTransactionCounter = 1;
                return SessionImpl.this.transactionStateAutocommit;
            }
            catch (ClusterJException clusterJException) {
                SessionImpl.this.transactionException = clusterJException;
                return SessionImpl.this.transactionStateNotActive;
            }
        }

        @Override
        public TransactionState end() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_Start", (Object)"end"));
        }

        @Override
        public TransactionState fail() {
            return SessionImpl.this.transactionStateNotActive;
        }
    };
    protected TransactionState transactionStateActive = new TransactionState(){

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public TransactionState begin() {
            SessionImpl.this.transactionException = new ClusterJUserException(local.message("ERR_Transaction_Must_Not_Be_Active_For_Method", (Object)"begin"));
            return SessionImpl.this.transactionStateActive;
        }

        @Override
        public TransactionState commit() {
            try {
                SessionImpl.this.flush(true);
            }
            catch (ClusterJException clusterJException) {
                SessionImpl.this.transactionException = clusterJException;
            }
            return SessionImpl.this.transactionStateNotActive;
        }

        @Override
        public TransactionState rollback() {
            try {
                SessionImpl.this.internalRollback();
                return SessionImpl.this.transactionStateNotActive;
            }
            catch (ClusterJException clusterJException) {
                SessionImpl.this.transactionException = clusterJException;
                return SessionImpl.this.transactionStateNotActive;
            }
        }

        @Override
        public TransactionState start() {
            return SessionImpl.this.transactionStateActive;
        }

        @Override
        public TransactionState end() {
            return SessionImpl.this.transactionStateActive;
        }

        @Override
        public TransactionState fail() {
            return SessionImpl.this.transactionStateActive;
        }
    };
    protected TransactionState transactionStateAutocommit = new TransactionState(){

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public TransactionState begin() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_End", (Object)"begin"));
        }

        @Override
        public TransactionState commit() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_End", (Object)"commit"));
        }

        @Override
        public TransactionState rollback() {
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_End", (Object)"rollback"));
        }

        @Override
        public TransactionState start() {
            ++SessionImpl.this.nestedAutoTransactionCounter;
            return SessionImpl.this.transactionStateAutocommit;
        }

        @Override
        public TransactionState end() {
            if (--SessionImpl.this.nestedAutoTransactionCounter > 0) {
                return SessionImpl.this.transactionStateAutocommit;
            }
            if (SessionImpl.this.nestedAutoTransactionCounter == 0) {
                try {
                    SessionImpl.this.internalCommit();
                }
                catch (ClusterJException clusterJException) {
                    SessionImpl.this.transactionException = clusterJException;
                }
                return SessionImpl.this.transactionStateNotActive;
            }
            throw new ClusterJFatalInternalException(local.message("ERR_Transaction_Auto_Start", (Object)"end"));
        }

        @Override
        public TransactionState fail() {
            try {
                SessionImpl.this.nestedAutoTransactionCounter = 0;
                SessionImpl.this.internalRollback();
                return SessionImpl.this.transactionStateNotActive;
            }
            catch (ClusterJException clusterJException) {
                return SessionImpl.this.transactionStateNotActive;
            }
        }
    };

    SessionImpl(SessionFactoryImpl sessionFactoryImpl, Map map, Db db, Dictionary dictionary) {
        this.factory = sessionFactoryImpl;
        this.db = db;
        this.dictionary = dictionary;
        this.properties = map;
        this.transactionImpl = new TransactionImpl(this);
        this.transactionState = this.transactionStateNotActive;
    }

    @Override
    public <T> Query<T> createQuery(QueryDefinition<T> queryDefinition) {
        this.assertNotClosed();
        if (!(queryDefinition instanceof QueryDomainTypeImpl)) {
            throw new ClusterJUserException(local.message("ERR_Exception_On_Method", (Object)"createQuery"));
        }
        return new QueryImpl(this, (QueryDomainTypeImpl)queryDefinition);
    }

    @Override
    public <T> T find(Class<T> clazz, Object object) {
        this.assertNotClosed();
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(clazz);
        ValueHandler valueHandler = domainTypeHandler.createKeyValueHandler(object, this.db);
        return this.initializeFromDatabase(domainTypeHandler, null, null, valueHandler);
    }

    @Override
    public <T> T initializeFromDatabase(DomainTypeHandler<T> domainTypeHandler, T t, ValueHandler valueHandler, ValueHandler valueHandler2) {
        this.startAutoTransaction();
        if (valueHandler2 instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler2;
                this.setPartitionKey(domainTypeHandler, smartValueHandler);
                Operation operation = smartValueHandler.load(this.clusterTransaction);
                this.endAutoTransaction();
                if (this.isActive()) {
                    this.clusterTransaction.executeNoCommit(false, true);
                }
                if (smartValueHandler.found().booleanValue()) {
                    return domainTypeHandler.newInstance(smartValueHandler);
                }
                valueHandler2.release();
                return null;
            }
            catch (ClusterJException clusterJException) {
                this.failAutoTransaction();
                throw clusterJException;
            }
        }
        try {
            ResultData resultData = this.selectUnique(domainTypeHandler, valueHandler2, null);
            if (resultData.next()) {
                if (valueHandler == null) {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Creating instanceHandler for class " + domainTypeHandler.getName() + " table: " + domainTypeHandler.getTableName() + valueHandler2.pkToString(domainTypeHandler));
                    }
                    t = domainTypeHandler.newInstance(this.db);
                    valueHandler = domainTypeHandler.getValueHandler(t);
                } else if (t == null) {
                    if (logger.isDetailEnabled()) {
                        logger.detail("Creating instance for class " + domainTypeHandler.getName() + " table: " + domainTypeHandler.getTableName() + valueHandler2.pkToString(domainTypeHandler));
                    }
                    t = domainTypeHandler.getInstance(valueHandler);
                }
            } else {
                if (logger.isDetailEnabled()) {
                    logger.detail("No instance found in database for class " + domainTypeHandler.getName() + " table: " + domainTypeHandler.getTableName() + valueHandler2.pkToString(domainTypeHandler));
                }
                if (valueHandler != null) {
                    valueHandler.found(Boolean.FALSE);
                    valueHandler.release();
                }
                this.endAutoTransaction();
                return null;
            }
            valueHandler.found(Boolean.TRUE);
            domainTypeHandler.objectSetValues(resultData, valueHandler);
            domainTypeHandler.objectSetCacheManager(this, valueHandler);
            domainTypeHandler.objectResetModified(valueHandler);
        }
        catch (ClusterJException clusterJException) {
            this.failAutoTransaction();
            throw clusterJException;
        }
        this.endAutoTransaction();
        return t;
    }

    private void setPartitionKey(DomainTypeHandler<?> domainTypeHandler, ValueHandler valueHandler) {
        this.assertNotClosed();
        if (this.partitionKey == null && !this.isEnlisted()) {
            this.partitionKey = domainTypeHandler.createPartitionKey(valueHandler);
            this.clusterTransaction.setPartitionKey(this.partitionKey);
        }
    }

    @Override
    public <T> T newInstance(Class<T> clazz) {
        this.assertNotClosed();
        return this.factory.newInstance(clazz, this.dictionary, this.db);
    }

    @Override
    public <T> T newInstance(Class<T> clazz, Object object) {
        this.assertNotClosed();
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(clazz);
        T t = this.factory.newInstance(clazz, this.dictionary, this.db);
        domainTypeHandler.objectSetKeys(object, t);
        return t;
    }

    @Override
    public <T> T newInstance(ResultData resultData, DomainTypeHandler<T> domainTypeHandler) {
        T t = domainTypeHandler.newInstance(resultData, this.db);
        return t;
    }

    @Override
    public <T> T load(T t) {
        if (t == null) {
            return null;
        }
        if (Iterable.class.isAssignableFrom(t.getClass())) {
            Iterable iterable = (Iterable)t;
            for (Object t2 : iterable) {
                this.load(t2);
            }
            return t;
        }
        if (t.getClass().isArray()) {
            Object[] objectArray;
            for (Object object : objectArray = (Object[])t) {
                this.load(object);
            }
            return t;
        }
        this.assertActive();
        final DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(t);
        final ValueHandler valueHandler = domainTypeHandler.getValueHandler(t);
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            Operation operation = ((SmartValueHandler)valueHandler).load(this.clusterTransaction);
            return t;
        }
        Table table = domainTypeHandler.getStoreTable();
        Operation operation = this.clusterTransaction.getSelectOperation(table);
        operation.beginDefinition();
        domainTypeHandler.operationSetKeys(valueHandler, operation);
        domainTypeHandler.operationGetValues(operation);
        operation.endDefinition();
        final ResultData resultData = operation.resultData(false);
        final SessionImpl sessionImpl = this;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (resultData.next()) {
                    valueHandler.found(Boolean.TRUE);
                    domainTypeHandler.objectSetValues(resultData, valueHandler);
                    domainTypeHandler.objectSetCacheManager(sessionImpl, valueHandler);
                    domainTypeHandler.objectResetModified(valueHandler);
                } else {
                    valueHandler.found(Boolean.FALSE);
                }
            }
        };
        this.clusterTransaction.postExecuteCallback(runnable);
        return t;
    }

    @Override
    public Boolean found(Object object) {
        this.assertNotClosed();
        if (object == null) {
            return null;
        }
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).found();
        }
        this.getDomainTypeHandler(object);
        return true;
    }

    @Override
    public <T> T makePersistent(T t) {
        if (t == null) {
            return null;
        }
        if (Iterable.class.isAssignableFrom(t.getClass())) {
            this.startAutoTransaction();
            Iterable iterable = (Iterable)t;
            for (Object t2 : iterable) {
                this.makePersistent(t2);
            }
            this.endAutoTransaction();
            return t;
        }
        if (t.getClass().isArray()) {
            Object[] objectArray;
            this.startAutoTransaction();
            for (Object object : objectArray = (Object[])t) {
                this.makePersistent(object);
            }
            this.endAutoTransaction();
            return t;
        }
        this.assertNotClosed();
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(t);
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(t);
        this.insert(domainTypeHandler, valueHandler);
        return t;
    }

    @Override
    public Operation insert(DomainTypeHandler<?> domainTypeHandler, ValueHandler valueHandler) {
        this.startAutoTransaction();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                Operation operation = smartValueHandler.insert(this.clusterTransaction);
                valueHandler.resetModified();
                this.endAutoTransaction();
                return operation;
            }
            catch (ClusterJException clusterJException) {
                this.failAutoTransaction();
                throw clusterJException;
            }
        }
        Operation operation = null;
        Table table = null;
        try {
            table = domainTypeHandler.getStoreTable();
            operation = this.clusterTransaction.getInsertOperation(table);
            operation.beginDefinition();
            domainTypeHandler.operationSetKeys(valueHandler, operation);
            domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, operation);
            operation.endDefinition();
            domainTypeHandler.objectResetModified(valueHandler);
        }
        catch (ClusterJUserException clusterJUserException) {
            this.failAutoTransaction();
            throw clusterJUserException;
        }
        catch (ClusterJException clusterJException) {
            this.failAutoTransaction();
            logger.error(local.message("ERR_Insert", (Object)table.getName()));
            throw new ClusterJException(local.message("ERR_Insert", (Object)table.getName()), clusterJException);
        }
        catch (RuntimeException runtimeException) {
            this.failAutoTransaction();
            logger.error(local.message("ERR_Insert", (Object)table.getName()));
            throw new ClusterJException(local.message("ERR_Insert", (Object)table.getName()), runtimeException);
        }
        this.endAutoTransaction();
        return operation;
    }

    public Iterable makePersistentAll(Iterable iterable) {
        this.startAutoTransaction();
        ArrayList arrayList = new ArrayList();
        for (Object t : iterable) {
            arrayList.add(this.makePersistent(t));
        }
        this.endAutoTransaction();
        return arrayList;
    }

    @Override
    public <T> void deletePersistent(Class<T> clazz, Object object) {
        this.assertNotClosed();
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(clazz);
        ValueHandler valueHandler = domainTypeHandler.createKeyValueHandler(object, this.db);
        this.delete((DomainTypeHandler)domainTypeHandler, valueHandler);
    }

    @Override
    public void deletePersistent(Object object) {
        this.assertNotClosed();
        if (object == null) {
            return;
        }
        DomainTypeHandler<Object> domainTypeHandler = this.getDomainTypeHandler(object);
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(object);
        this.delete((DomainTypeHandler)domainTypeHandler, valueHandler);
    }

    public Operation delete(DomainTypeHandler domainTypeHandler, ValueHandler valueHandler) {
        this.startAutoTransaction();
        Table table = domainTypeHandler.getStoreTable();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                Operation operation = smartValueHandler.delete(this.clusterTransaction);
                this.endAutoTransaction();
                return operation;
            }
            catch (ClusterJException clusterJException) {
                this.failAutoTransaction();
                throw clusterJException;
            }
        }
        Operation operation = null;
        try {
            operation = this.clusterTransaction.getDeleteOperation(table);
            operation.beginDefinition();
            domainTypeHandler.operationSetKeys(valueHandler, operation);
            operation.endDefinition();
        }
        catch (ClusterJException clusterJException) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Delete", (Object)table.getName()), clusterJException);
        }
        this.endAutoTransaction();
        return operation;
    }

    public void deletePersistentAll(Iterable iterable) {
        this.startAutoTransaction();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            this.deletePersistent(iterator.next());
        }
        this.endAutoTransaction();
    }

    @Override
    public <T> int deletePersistentAll(Class<T> clazz) {
        this.assertNotClosed();
        DomainTypeHandler<T> domainTypeHandler = this.getDomainTypeHandler(clazz);
        return this.deletePersistentAll(domainTypeHandler);
    }

    @Override
    public int deletePersistentAll(DomainTypeHandler<?> domainTypeHandler) {
        this.startAutoTransaction();
        Table table = domainTypeHandler.getStoreTable();
        String string = table.getName();
        ScanOperation scanOperation = null;
        int n = 0;
        try {
            scanOperation = this.clusterTransaction.getTableScanOperationLockModeExclusiveScanFlagKeyInfo(table);
            n = this.deletePersistentAll(scanOperation, true);
        }
        catch (ClusterJException clusterJException) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Delete_All", (Object)string), clusterJException);
        }
        this.endAutoTransaction();
        return n;
    }

    @Override
    public int deletePersistentAll(ScanOperation scanOperation, boolean bl) {
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = true;
        this.clusterTransaction.setAutocommit(false);
        this.clusterTransaction.executeNoCommit(true, true);
        block5: while (!bl2) {
            int n3 = scanOperation.nextResult(bl3);
            switch (n3) {
                case 0: {
                    scanOperation.deleteCurrentTuple();
                    ++n2;
                    ++n;
                    bl3 = false;
                    continue block5;
                }
                case 1: {
                    bl2 = true;
                    if (n != 0) {
                        this.clusterTransaction.executeNoCommit(bl, true);
                    }
                    scanOperation.close();
                    continue block5;
                }
                case 2: {
                    this.clusterTransaction.executeNoCommit(bl, true);
                    n = 0;
                    bl3 = true;
                    continue block5;
                }
            }
            throw new ClusterJException(local.message("ERR_Next_Result_Illegal", n3));
        }
        return n2;
    }

    @Override
    public ResultData selectUnique(DomainTypeHandler<?> domainTypeHandler, ValueHandler valueHandler, BitSet bitSet) {
        this.assertActive();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        Table table = domainTypeHandler.getStoreTable();
        Operation operation = this.clusterTransaction.getSelectOperation(table);
        operation.beginDefinition();
        domainTypeHandler.operationSetKeys(valueHandler, operation);
        domainTypeHandler.operationGetValues(operation);
        operation.endDefinition();
        ResultData resultData = operation.resultData();
        return resultData;
    }

    @Override
    public void updatePersistent(Object object) {
        this.assertNotClosed();
        if (object == null) {
            return;
        }
        DomainTypeHandler<Object> domainTypeHandler = this.getDomainTypeHandler(object);
        if (logger.isDetailEnabled()) {
            logger.detail("UpdatePersistent on object " + object);
        }
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(object);
        this.update(domainTypeHandler, valueHandler);
    }

    @Override
    public Operation update(DomainTypeHandler<?> domainTypeHandler, ValueHandler valueHandler) {
        this.startAutoTransaction();
        this.setPartitionKey(domainTypeHandler, valueHandler);
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                Operation operation = smartValueHandler.update(this.clusterTransaction);
                this.endAutoTransaction();
                return operation;
            }
            catch (ClusterJException clusterJException) {
                this.failAutoTransaction();
                throw clusterJException;
            }
        }
        Table table = null;
        Operation operation = null;
        try {
            table = domainTypeHandler.getStoreTable();
            operation = this.clusterTransaction.getUpdateOperation(table);
            domainTypeHandler.operationSetKeys(valueHandler, operation);
            domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, operation);
            if (logger.isDetailEnabled()) {
                logger.detail("Updated object " + valueHandler);
            }
        }
        catch (ClusterJException clusterJException) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Update", (Object)table.getName()), clusterJException);
        }
        this.endAutoTransaction();
        return operation;
    }

    public void updatePersistentAll(Iterable iterable) {
        this.startAutoTransaction();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            this.updatePersistent(iterator.next());
        }
        this.endAutoTransaction();
    }

    @Override
    public <T> T savePersistent(T t) {
        ValueHandler valueHandler;
        DomainTypeHandler<T> domainTypeHandler;
        this.startAutoTransaction();
        if (logger.isDetailEnabled()) {
            logger.detail("SavePersistent on object " + t);
        }
        try {
            domainTypeHandler = this.getDomainTypeHandler(t);
            valueHandler = domainTypeHandler.getValueHandler(t);
            this.setPartitionKey(domainTypeHandler, valueHandler);
        }
        catch (ClusterJException clusterJException) {
            this.failAutoTransaction();
            throw clusterJException;
        }
        if (valueHandler instanceof SmartValueHandler) {
            try {
                SmartValueHandler smartValueHandler = (SmartValueHandler)valueHandler;
                smartValueHandler.write(this.clusterTransaction);
                valueHandler.resetModified();
                this.endAutoTransaction();
                return t;
            }
            catch (ClusterJException clusterJException) {
                this.failAutoTransaction();
                throw clusterJException;
            }
        }
        Table table = null;
        try {
            table = domainTypeHandler.getStoreTable();
            Operation operation = null;
            operation = this.clusterTransaction.getWriteOperation(table);
            domainTypeHandler.operationSetKeys(valueHandler, operation);
            domainTypeHandler.operationSetModifiedNonPKValues(valueHandler, operation);
        }
        catch (ClusterJException clusterJException) {
            this.failAutoTransaction();
            throw new ClusterJException(local.message("ERR_Write", (Object)table.getName()), clusterJException);
        }
        this.endAutoTransaction();
        return t;
    }

    public Iterable savePersistentAll(Iterable iterable) {
        ArrayList arrayList = new ArrayList();
        this.startAutoTransaction();
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            arrayList.add(this.savePersistent(iterator.next()));
        }
        this.endAutoTransaction();
        return arrayList;
    }

    @Override
    public Transaction currentTransaction() {
        return this.transactionImpl;
    }

    @Override
    public void close() {
        if (this.clusterTransaction != null) {
            this.clusterTransaction.close();
            this.clusterTransaction = null;
        }
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    @Override
    public boolean isClosed() {
        return this.db == null;
    }

    protected void assertNotClosed() {
        if (this.isClosed()) {
            throw new ClusterJUserException(local.message("ERR_Session_Closed"));
        }
    }

    @Override
    public void begin() {
        this.assertNotClosed();
        if (logger.isDebugEnabled()) {
            logger.debug("begin transaction.");
        }
        this.transactionState = this.transactionState.begin();
        this.handleTransactionException();
    }

    protected void internalBegin() {
        try {
            this.clusterTransaction = this.db.startTransaction(this.joinTransactionId);
            this.clusterTransaction.setLockMode(this.lockmode);
            if (this.partitionKey != null) {
                this.clusterTransaction.setPartitionKey(this.partitionKey);
            }
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Ndb_Start"), clusterJException);
        }
    }

    @Override
    public void commit() {
        this.assertNotClosed();
        if (logger.isDebugEnabled()) {
            logger.debug("commit transaction.");
        }
        this.transactionState = this.transactionState.commit();
        this.handleTransactionException();
    }

    protected void internalCommit() {
        if (this.rollbackOnly) {
            try {
                this.internalRollback();
                throw new ClusterJException(local.message("ERR_Transaction_Rollback_Only"));
            }
            catch (ClusterJException clusterJException) {
                throw new ClusterJException(local.message("ERR_Transaction_Rollback_Only"), clusterJException);
            }
        }
        try {
            this.clusterTransaction.executeCommit();
        }
        finally {
            this.clusterTransaction.close();
            this.clusterTransaction = null;
            this.partitionKey = null;
        }
    }

    @Override
    public void rollback() {
        this.assertNotClosed();
        if (logger.isDebugEnabled()) {
            logger.debug("roll back transaction.");
        }
        this.transactionState = this.transactionState.rollback();
        this.handleTransactionException();
    }

    protected void internalRollback() {
        try {
            this.clusterTransaction.executeRollback();
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Transaction_Execute", (Object)"rollback"), clusterJException);
        }
        finally {
            if (this.clusterTransaction != null) {
                this.clusterTransaction.close();
            }
            this.clusterTransaction = null;
            this.partitionKey = null;
        }
    }

    @Override
    public void startAutoTransaction() {
        this.assertNotClosed();
        if (logger.isDebugEnabled()) {
            logger.debug("start AutoTransaction");
        }
        this.transactionState = this.transactionState.start();
        this.handleTransactionException();
    }

    @Override
    public void endAutoTransaction() {
        if (logger.isDebugEnabled()) {
            logger.debug("end AutoTransaction");
        }
        this.transactionState = this.transactionState.end();
        this.handleTransactionException();
    }

    @Override
    public void failAutoTransaction() {
        if (logger.isDebugEnabled()) {
            logger.debug("fail AutoTransaction");
        }
        this.transactionState = this.transactionState.fail();
    }

    protected void handleTransactionException() {
        if (this.transactionException == null) {
            return;
        }
        ClusterJException clusterJException = this.transactionException;
        this.transactionException = null;
        throw clusterJException;
    }

    @Override
    public void setRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public boolean getRollbackOnly() {
        return this.rollbackOnly;
    }

    protected synchronized <T> DomainTypeHandler<T> getDomainTypeHandler(T t) {
        DomainTypeHandler<T> domainTypeHandler = this.factory.getDomainTypeHandler(t, this.dictionary);
        return domainTypeHandler;
    }

    public synchronized <T> DomainTypeHandler<T> getDomainTypeHandler(Class<T> clazz) {
        DomainTypeHandler<Class<T>> domainTypeHandler = this.factory.getDomainTypeHandler(clazz, this.dictionary);
        return domainTypeHandler;
    }

    @Override
    public Dictionary getDictionary() {
        return this.dictionary;
    }

    boolean isActive() {
        return this.transactionState.isActive();
    }

    @Override
    public boolean isEnlisted() {
        return this.clusterTransaction == null ? false : this.clusterTransaction.isEnlisted();
    }

    private void assertActive() {
        this.assertNotClosed();
        if (!this.transactionState.isActive()) {
            throw new ClusterJUserException(local.message("ERR_Transaction_Must_Be_Active"));
        }
    }

    private void assertNotActive(String string) {
        if (this.transactionState.isActive()) {
            throw new ClusterJUserException(local.message("ERR_Transaction_Must_Not_Be_Active_For_Method", (Object)string));
        }
    }

    public Query createQuery(Class clazz) {
        this.assertNotClosed();
        throw new UnsupportedOperationException(local.message("ERR_NotImplemented"));
    }

    @Override
    public QueryBuilder getQueryBuilder() {
        this.assertNotClosed();
        return new QueryBuilderImpl(this);
    }

    @Override
    public IndexScanOperation getIndexScanOperation(Index index, Table table) {
        this.assertActive();
        try {
            IndexScanOperation indexScanOperation = this.clusterTransaction.getIndexScanOperation(index, table);
            return indexScanOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Index_Scan", (Object)table.getName(), (Object)index.getName()), clusterJException);
        }
    }

    @Override
    public IndexScanOperation getIndexScanOperationMultiRange(Index index, Table table) {
        this.assertActive();
        try {
            IndexScanOperation indexScanOperation = this.clusterTransaction.getIndexScanOperationMultiRange(index, table);
            return indexScanOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Index_Scan", (Object)table.getName(), (Object)index.getName()), clusterJException);
        }
    }

    @Override
    public IndexScanOperation getIndexScanDeleteOperation(Index index, Table table) {
        this.assertActive();
        try {
            IndexScanOperation indexScanOperation = this.clusterTransaction.getIndexScanOperationLockModeExclusiveScanFlagKeyInfo(index, table);
            return indexScanOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Index_Scan", (Object)table.getName(), (Object)index.getName()), clusterJException);
        }
    }

    @Override
    public ScanOperation getTableScanOperation(Table table) {
        this.assertActive();
        try {
            ScanOperation scanOperation = this.clusterTransaction.getTableScanOperation(table);
            return scanOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Table_Scan", (Object)table.getName()), clusterJException);
        }
    }

    @Override
    public ScanOperation getTableScanDeleteOperation(Table table) {
        this.assertActive();
        try {
            ScanOperation scanOperation = this.clusterTransaction.getTableScanOperationLockModeExclusiveScanFlagKeyInfo(table);
            return scanOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Table_Scan", (Object)table.getName()), clusterJException);
        }
    }

    @Override
    public IndexOperation getUniqueIndexOperation(Index index, Table table) {
        this.assertActive();
        try {
            IndexOperation indexOperation = this.clusterTransaction.getUniqueIndexOperation(index, table);
            return indexOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Unique_Index", (Object)table.getName(), (Object)index.getName()), clusterJException);
        }
    }

    @Override
    public IndexOperation getUniqueIndexUpdateOperation(Index index, Table table) {
        this.assertActive();
        try {
            IndexOperation indexOperation = this.clusterTransaction.getUniqueIndexUpdateOperation(index, table);
            return indexOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Unique_Index_Update", (Object)table.getName(), (Object)index.getName()), clusterJException);
        }
    }

    @Override
    public Operation getSelectOperation(Table table) {
        this.assertActive();
        try {
            Operation operation = this.clusterTransaction.getSelectOperation(table);
            return operation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Select", (Object)table), clusterJException);
        }
    }

    @Override
    public Operation getDeleteOperation(Table table) {
        this.assertActive();
        try {
            Operation operation = this.clusterTransaction.getDeleteOperation(table);
            return operation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Delete", (Object)table), clusterJException);
        }
    }

    @Override
    public Operation getUpdateOperation(Table table) {
        this.assertActive();
        try {
            Operation operation = this.clusterTransaction.getUpdateOperation(table);
            return operation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Update", (Object)table), clusterJException);
        }
    }

    @Override
    public IndexOperation getUniqueIndexDeleteOperation(Index index, Table table) {
        this.assertActive();
        try {
            IndexOperation indexOperation = this.clusterTransaction.getUniqueIndexDeleteOperation(index, table);
            return indexOperation;
        }
        catch (ClusterJException clusterJException) {
            throw new ClusterJException(local.message("ERR_Unique_Index_Delete", (Object)table.getName(), (Object)index.getName()), clusterJException);
        }
    }

    public void flush(boolean bl) {
        if (logger.isDetailEnabled()) {
            logger.detail("flush changes with changeList size: " + this.changeList.size());
        }
        if (!this.changeList.isEmpty()) {
            for (StateManager stateManager : this.changeList) {
                stateManager.flush(this);
            }
            this.changeList.clear();
        }
        if (this.clusterTransaction != null) {
            if (bl) {
                this.internalCommit();
            } else {
                this.executeNoCommit();
                this.handleTransactionException();
            }
        }
    }

    @Override
    public void flush() {
        this.assertNotClosed();
        this.flush(false);
    }

    public List getChangeList() {
        this.assertNotClosed();
        return Collections.unmodifiableList(this.changeList);
    }

    @Override
    public void persist(Object object) {
        this.makePersistent(object);
    }

    @Override
    public void remove(Object object) {
        this.deletePersistent(object);
    }

    @Override
    public void markModified(StateManager stateManager) {
        this.assertNotClosed();
        this.changeList.add(stateManager);
    }

    @Override
    public void setPartitionKey(Class<?> clazz, Object object) {
        this.assertNotClosed();
        DomainTypeHandler<?> domainTypeHandler = this.getDomainTypeHandler(clazz);
        String string = domainTypeHandler.getTableName();
        if (this.isEnlisted()) {
            throw new ClusterJUserException(local.message("ERR_Set_Partition_Key_After_Enlistment", (Object)string));
        }
        if (this.partitionKey != null) {
            throw new ClusterJUserException(local.message("ERR_Set_Partition_Key_Twice", (Object)string));
        }
        ValueHandler valueHandler = domainTypeHandler.createKeyValueHandler(object, this.db);
        this.partitionKey = domainTypeHandler.createPartitionKey(valueHandler);
        if (this.clusterTransaction != null) {
            this.clusterTransaction.setPartitionKey(this.partitionKey);
        }
        valueHandler.release();
    }

    @Override
    public void markModified(Object object, String string) {
        this.assertNotClosed();
        DomainTypeHandler<Object> domainTypeHandler = this.getDomainTypeHandler(object);
        ValueHandler valueHandler = domainTypeHandler.getValueHandler(object);
        domainTypeHandler.objectMarkModified(valueHandler, string);
    }

    @Override
    public void executeNoCommit(boolean bl, boolean bl2) {
        if (this.clusterTransaction != null) {
            try {
                this.clusterTransaction.executeNoCommit(bl, bl2);
            }
            catch (ClusterJException clusterJException) {
                this.transactionException = clusterJException;
            }
        }
    }

    @Override
    public void executeNoCommit() {
        this.executeNoCommit(false, true);
    }

    @Override
    public <T> QueryDomainType<T> createQueryDomainType(DomainTypeHandler<T> domainTypeHandler) {
        QueryBuilderImpl queryBuilderImpl = (QueryBuilderImpl)this.getQueryBuilder();
        return queryBuilderImpl.createQueryDefinition(domainTypeHandler);
    }

    @Override
    public String getCoordinatedTransactionId() {
        this.assertNotClosed();
        return this.clusterTransaction.getCoordinatedTransactionId();
    }

    @Override
    public void setCoordinatedTransactionId(String string) {
        this.assertNotClosed();
        this.clusterTransaction.setCoordinatedTransactionId(string);
    }

    @Override
    public void setLockMode(LockMode lockMode) {
        this.assertNotClosed();
        this.lockmode = lockMode;
        if (this.clusterTransaction != null) {
            this.clusterTransaction.setLockMode(lockMode);
        }
    }

    @Override
    public String unloadSchema(Class<?> clazz) {
        this.assertNotClosed();
        return this.factory.unloadSchema(clazz, this.dictionary);
    }

    @Override
    public <T> T release(T t) {
        block7: {
            block9: {
                block8: {
                    Object[] objectArray;
                    block6: {
                        if (t == null) {
                            throw new ClusterJUserException(local.message("ERR_Release_Parameter"));
                        }
                        if (!Iterable.class.isAssignableFrom(t.getClass())) break block6;
                        Iterable iterable = (Iterable)t;
                        for (Object t2 : iterable) {
                            this.release(t2);
                        }
                        break block7;
                    }
                    if (!t.getClass().isArray()) break block8;
                    for (Object object : objectArray = (Object[])t) {
                        this.release(object);
                    }
                    break block7;
                }
                this.assertNotClosed();
                if (!DynamicObject.class.isAssignableFrom(t.getClass())) break block9;
                DynamicObject dynamicObject = (DynamicObject)t;
                DynamicObjectDelegate dynamicObjectDelegate = dynamicObject.delegate();
                if (dynamicObjectDelegate == null) break block7;
                dynamicObjectDelegate.release();
                break block7;
            }
            try {
                InvocationHandler invocationHandler = Proxy.getInvocationHandler(t);
                if (!ValueHandler.class.isAssignableFrom(invocationHandler.getClass())) {
                    throw new ClusterJUserException(local.message("ERR_Release_Parameter"));
                }
                ValueHandler valueHandler = (ValueHandler)invocationHandler;
                valueHandler.release();
            }
            catch (Throwable throwable) {
                throw new ClusterJUserException(local.message("ERR_Release_Parameter"), throwable);
            }
        }
        return t;
    }

    protected static interface TransactionState {
        public boolean isActive();

        public TransactionState begin();

        public TransactionState commit();

        public TransactionState rollback();

        public TransactionState start();

        public TransactionState end();

        public TransactionState fail();
    }
}

