/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.store.ResultData;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.AbstractResult;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;

public class NdbOpenJPAResult
extends AbstractResult
implements Result {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPAResult.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAResult.class);
    protected ResultData resultData;
    protected DomainTypeHandler<?> domainTypeHandler;
    protected BitSet fields;
    private Map<String, com.mysql.clusterj.core.store.Column> columnMap = new HashMap<String, com.mysql.clusterj.core.store.Column>();

    public NdbOpenJPAResult(ResultData resultData, DomainTypeHandler<?> domainTypeHandler, BitSet bitSet) {
        this.resultData = resultData;
        this.domainTypeHandler = domainTypeHandler;
        this.fields = bitSet;
        Set<com.mysql.clusterj.core.store.Column> set = domainTypeHandler.getStoreColumns(bitSet);
        for (com.mysql.clusterj.core.store.Column column : set) {
            this.columnMap.put(column.getName(), column);
        }
    }

    protected boolean nextInternal() throws SQLException {
        boolean bl = this.resultData.next();
        if (logger.isDetailEnabled()) {
            logger.detail("returning: " + bl);
        }
        return bl;
    }

    protected boolean containsInternal(Object object, Joins joins) throws SQLException {
        com.mysql.clusterj.core.store.Column column = this.resolve(object);
        return column != null;
    }

    protected Object getObjectInternal(Object object, int n, Object object2, Joins joins) throws SQLException {
        Object object3 = null;
        com.mysql.clusterj.core.store.Column column = this.resolve(object);
        switch (n) {
            case 5: 
            case 21: {
                object3 = this.resultData.getInt(column);
                break;
            }
            case 3: 
            case 19: {
                object3 = this.resultData.getDouble(column);
                break;
            }
            case 4: 
            case 20: {
                object3 = Float.valueOf(this.resultData.getFloat(column));
                break;
            }
            case 9: {
                object3 = this.resultData.getString(column);
                break;
            }
            case 6: 
            case 22: {
                object3 = this.resultData.getLong(column);
                break;
            }
            case 24: {
                object3 = this.resultData.getDecimal(column);
                break;
            }
            case 25: {
                object3 = this.resultData.getBigInteger(column);
                break;
            }
            case 14: {
                object3 = new java.util.Date(this.resultData.getLong(column));
                break;
            }
            case 1010: {
                object3 = new Time(this.resultData.getLong(column));
                break;
            }
            case 1007: {
                object3 = new Date(this.resultData.getLong(column));
                break;
            }
            case 1011: {
                object3 = new Timestamp(this.resultData.getLong(column));
                break;
            }
            case 1004: {
                object3 = this.resultData.getBytes(column);
                break;
            }
            case 0: 
            case 16: {
                object3 = this.resultData.getObjectBoolean(column);
                break;
            }
            default: {
                Column column2;
                if (object instanceof Column && ((column2 = (Column)object).getType() == 2004 || column2.getType() == -3)) {
                    object3 = this.resultData.getBytes(column);
                }
                object3 = this.resultData.getInt(column);
            }
        }
        if (logger.isDetailEnabled()) {
            logger.detail("obj: " + object + " arg: " + object2 + " joins: " + joins + " metaType: " + n + " result: " + object3);
        }
        return object3;
    }

    protected Object getStreamInternal(JDBCStore jDBCStore, Object object, int n, Object object2, Joins joins) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int size() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected long getLongInternal(Object object, Joins joins) throws SQLException {
        Number number = (Number)this.checkNull(this.getObjectInternal(object, 6, null, joins));
        return number == null ? 0L : number.longValue();
    }

    protected com.mysql.clusterj.core.store.Column resolve(Object object) {
        String string = null;
        com.mysql.clusterj.core.store.Column column = null;
        if (logger.isDetailEnabled()) {
            logger.detail("resolving object of type: " + object.getClass().getName());
        }
        if (object instanceof String) {
            string = (String)object;
            column = this.columnMap.get(string);
        } else if (object instanceof Column) {
            string = ((Column)object).getName();
            column = this.columnMap.get(string);
        } else {
            throw new UnsupportedOperationException(local.message("ERR_Unsupported_Object_Type_For_Resolve", (Object)object.getClass().getName()));
        }
        if (logger.isDetailEnabled()) {
            logger.detail("key: " + string + " column: " + (column == null ? "<null>" : column.getName()));
        }
        return column;
    }

    public Set<String> getColumnNames() {
        return this.columnMap.keySet();
    }
}

