/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.jpatest;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import junit.framework.TestCase;
import junit.framework.TestResult;

public abstract class PersistenceTestCase
extends TestCase {
    protected TestResult testResult;
    private StringBuffer errorMessages;
    private String NL = "\n";
    protected Map map;

    protected EntityManagerFactory createEMF(Object ... objectArray) {
        String string = this.getPersistenceUnitName();
        EntityManagerFactory entityManagerFactory = this.createNamedEMF(string, objectArray);
        return entityManagerFactory;
    }

    protected String getPersistenceUnitName() {
        String string = System.getProperty("com.mysql.clusterj.jpa.PersistenceUnit", "ndb");
        if (string.length() == 0 || string.equals("${com.mysql.clusterj.jpa.PersistenceUnit}")) {
            return "ndb";
        }
        return string;
    }

    protected EntityManagerFactory createNamedEMF(String string, Object ... objectArray) {
        this.map = new HashMap();
        boolean bl = false;
        for (int i = 0; objectArray != null && i < objectArray.length; ++i) {
            if (bl) {
                this.map.put(objectArray[i - 1], objectArray[i]);
                bl = false;
                continue;
            }
            if (objectArray[i] == null) continue;
            bl = true;
        }
        return Persistence.createEntityManagerFactory((String)string, (Map)this.map);
    }

    public void run(TestResult testResult) {
        this.testResult = testResult;
        super.run(testResult);
    }

    public void tearDown() throws Exception {
        block2: {
            try {
                super.tearDown();
            }
            catch (Exception exception) {
                if (!this.testResult.wasSuccessful()) break block2;
                throw exception;
            }
        }
    }

    protected boolean closeEMF(EntityManagerFactory entityManagerFactory) {
        if (entityManagerFactory == null || !entityManagerFactory.isOpen()) {
            return false;
        }
        entityManagerFactory.close();
        return !entityManagerFactory.isOpen();
    }

    protected void initializeErrorMessages() {
        if (this.errorMessages == null) {
            this.errorMessages = new StringBuffer();
            this.errorMessages.append(this.NL);
        }
    }

    protected void error(String string) {
        this.initializeErrorMessages();
        this.errorMessages.append(string + this.NL);
    }

    protected void errorIfNotEqual(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(string + this.NL);
        this.errorMessages.append("Expected: " + (object == null ? "null" : object.toString()) + " actual: " + (object2 == null ? "null" : object2.toString()) + this.NL);
    }

    protected void errorIfNull(String string, Object object) {
        if (object != null) {
            return;
        }
        this.initializeErrorMessages();
        this.errorMessages.append(string + this.NL);
    }

    protected void failOnError() {
        if (this.errorMessages != null) {
            PersistenceTestCase.fail((String)this.errorMessages.toString());
        }
    }
}

