/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.clusterj.openjpa;

import com.mysql.clusterj.ClusterJFatalInternalException;
import com.mysql.clusterj.ClusterJHelper;
import com.mysql.clusterj.Constants;
import com.mysql.clusterj.SessionFactory;
import com.mysql.clusterj.core.SessionFactoryImpl;
import com.mysql.clusterj.core.spi.DomainTypeHandler;
import com.mysql.clusterj.core.spi.DomainTypeHandlerFactory;
import com.mysql.clusterj.core.spi.ValueHandlerFactory;
import com.mysql.clusterj.core.store.Dictionary;
import com.mysql.clusterj.core.util.I18NHelper;
import com.mysql.clusterj.core.util.Logger;
import com.mysql.clusterj.core.util.LoggerFactoryService;
import com.mysql.clusterj.openjpa.NdbOpenJPAConfiguration;
import com.mysql.clusterj.openjpa.NdbOpenJPADomainTypeHandlerImpl;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.lib.conf.BooleanValue;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.StringValue;

public class NdbOpenJPAConfigurationImpl
extends JDBCConfigurationImpl
implements NdbOpenJPAConfiguration,
Constants,
DomainTypeHandlerFactory {
    static final I18NHelper local = I18NHelper.getInstance(NdbOpenJPAConfigurationImpl.class);
    static final Logger logger = LoggerFactoryService.getFactory().getInstance(NdbOpenJPAConfigurationImpl.class);
    public StringValue connectString;
    public IntValue connectRetries;
    public IntValue connectDelay;
    public IntValue connectVerbose;
    public IntValue connectTimeoutBefore;
    public IntValue connectTimeoutAfter;
    public StringValue username;
    public StringValue password;
    public StringValue database;
    public IntValue maxTransactions;
    public BooleanValue failOnJDBCPath;
    public SessionFactoryImpl sessionFactory;
    private final Map<Class<?>, NdbOpenJPADomainTypeHandlerImpl<?>> domainTypeHandlerMap = new HashMap();
    private static Method intValueMethod;
    private static Method booleanValueMethod;

    int getIntValue(IntValue intValue) {
        try {
            return (Integer)intValueMethod.invoke((Object)intValue, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClusterJFatalInternalException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClusterJFatalInternalException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ClusterJFatalInternalException(invocationTargetException);
        }
    }

    boolean getBooleanValue(BooleanValue booleanValue) {
        try {
            return (Boolean)booleanValueMethod.invoke((Object)booleanValue, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ClusterJFatalInternalException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ClusterJFatalInternalException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ClusterJFatalInternalException(invocationTargetException);
        }
    }

    public NdbOpenJPAConfigurationImpl() {
        this(true);
    }

    public NdbOpenJPAConfigurationImpl(boolean bl) {
        this(true, bl);
    }

    public NdbOpenJPAConfigurationImpl(boolean bl, boolean bl2) {
        super(false, false);
        this.connectString = this.addString("ndb.connectString");
        this.connectRetries = this.addInt("ndb.connectRetries");
        this.connectRetries.set(4);
        this.connectDelay = this.addInt("ndb.connectDelay");
        this.connectDelay.set(5);
        this.connectVerbose = this.addInt("ndb.connectVerbose");
        this.connectVerbose.set(0);
        this.connectTimeoutBefore = this.addInt("ndb.connectTimeoutBefore");
        this.connectTimeoutBefore.set(30);
        this.connectTimeoutAfter = this.addInt("ndb.connectTimeoutAfter");
        this.connectTimeoutAfter.set(20);
        this.username = this.addString("ndb.username");
        this.password = this.addString("ndb.password");
        this.database = this.addString("ndb.database");
        this.database.set("test");
        this.maxTransactions = this.addInt("ndb.maxTransactions");
        this.maxTransactions.set(1024);
        this.failOnJDBCPath = this.addBoolean("ndb.failOnJDBCPath");
        this.failOnJDBCPath.set(false);
        this.sessionFactory = null;
        if (bl) {
            ProductDerivations.beforeConfigurationLoad((Configuration)this);
        }
        if (bl2) {
            this.loadGlobals();
        }
    }

    public NdbOpenJPAConfigurationImpl(NdbOpenJPAConfiguration ndbOpenJPAConfiguration) {
        this(true, false);
        if (ndbOpenJPAConfiguration != null) {
            this.fromProperties(ndbOpenJPAConfiguration.toProperties(false));
        }
    }

    @Override
    public String getConnectString() {
        return this.connectString.get();
    }

    @Override
    public void setConnectString(String string) {
        this.connectString.set(string);
    }

    @Override
    public int getConnectRetries() {
        return this.getIntValue(this.connectRetries);
    }

    @Override
    public void setConnectRetries(int n) {
        this.connectRetries.set(n);
    }

    @Override
    public int getConnectDelay() {
        return this.getIntValue(this.connectDelay);
    }

    @Override
    public void setConnectDelay(int n) {
        this.connectDelay.set(n);
    }

    @Override
    public int getConnectVerbose() {
        return this.getIntValue(this.connectVerbose);
    }

    @Override
    public void setConnectVerbose(int n) {
        this.connectVerbose.set(n);
    }

    @Override
    public int getConnectTimeoutBefore() {
        return this.getIntValue(this.connectTimeoutBefore);
    }

    @Override
    public void setConnectTimeoutBefore(int n) {
        this.connectTimeoutBefore.set(n);
    }

    @Override
    public int getConnectTimeoutAfter() {
        return this.getIntValue(this.connectTimeoutAfter);
    }

    @Override
    public void setConnectTimeoutAfter(int n) {
        this.connectTimeoutAfter.set(n);
    }

    @Override
    public String getUsername() {
        return this.username.getString();
    }

    @Override
    public void setUsername(String string) {
        this.username.setString(string);
    }

    @Override
    public String getPassword() {
        return this.password.getString();
    }

    @Override
    public void setPassword(String string) {
        this.password.setString(string);
    }

    @Override
    public String getDatabase() {
        return this.database.getString();
    }

    @Override
    public void setDatabase(String string) {
        this.database.setString(string);
    }

    @Override
    public int getMaxTransactions() {
        return this.getIntValue(this.maxTransactions);
    }

    @Override
    public void setMaxTransactions(int n) {
        this.maxTransactions.set(n);
    }

    @Override
    public boolean getFailOnJDBCPath() {
        return this.getBooleanValue(this.failOnJDBCPath);
    }

    @Override
    public void setFailOnJDBCPath(boolean bl) {
        this.failOnJDBCPath.set(bl);
    }

    @Override
    public SessionFactoryImpl getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        return this.sessionFactory;
    }

    @Override
    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = (SessionFactoryImpl)sessionFactory;
    }

    public SessionFactoryImpl createSessionFactory() {
        if (this.connectString.get() == null) {
            throw new IllegalStateException(local.message("ERR_Missing_Connect_String"));
        }
        Properties properties = new Properties();
        properties.put("com.mysql.clusterj.connectstring", this.connectString.get());
        properties.put("com.mysql.clusterj.connect.retries", this.connectRetries.getString());
        properties.put("com.mysql.clusterj.connect.delay", this.connectDelay.getString());
        properties.put("com.mysql.clusterj.connect.verbose", this.connectVerbose.getString());
        properties.put("com.mysql.clusterj.connect.timeout.before", this.connectTimeoutBefore.getString());
        properties.put("com.mysql.clusterj.connect.timeout.after", this.connectTimeoutAfter.getString());
        properties.put("com.mysql.clusterj.database", this.database.getString());
        properties.put("com.mysql.clusterj.max.transactions", this.maxTransactions.getString());
        SessionFactoryImpl sessionFactoryImpl = (SessionFactoryImpl)ClusterJHelper.getSessionFactory(properties);
        sessionFactoryImpl.setDomainTypeHandlerFactory(this);
        return sessionFactoryImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NdbOpenJPADomainTypeHandlerImpl<?> getDomainTypeHandler(ClassMapping classMapping, Dictionary dictionary) {
        NdbOpenJPADomainTypeHandlerImpl<?> ndbOpenJPADomainTypeHandlerImpl;
        Class clazz = classMapping.getDescribedType();
        Map<Class<?>, NdbOpenJPADomainTypeHandlerImpl<?>> map = this.domainTypeHandlerMap;
        synchronized (map) {
            ndbOpenJPADomainTypeHandlerImpl = this.domainTypeHandlerMap.get(clazz);
            if (ndbOpenJPADomainTypeHandlerImpl == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("domain class: " + clazz.getName());
                }
                ndbOpenJPADomainTypeHandlerImpl = this.createDomainTypeHandler(classMapping, dictionary);
                this.domainTypeHandlerMap.put(clazz, ndbOpenJPADomainTypeHandlerImpl);
                ndbOpenJPADomainTypeHandlerImpl.initializeRelations();
                logger.info("New domain type " + ndbOpenJPADomainTypeHandlerImpl.getName() + (ndbOpenJPADomainTypeHandlerImpl.isSupportedType() ? " is supported." : " is not known to be supported because " + ndbOpenJPADomainTypeHandlerImpl.getReasons()));
            }
        }
        return ndbOpenJPADomainTypeHandlerImpl;
    }

    private NdbOpenJPADomainTypeHandlerImpl<?> createDomainTypeHandler(ClassMapping classMapping, Dictionary dictionary) {
        return new NdbOpenJPADomainTypeHandlerImpl(dictionary, classMapping, this);
    }

    protected void preClose() {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
        }
        super.preClose();
    }

    protected boolean isInvalidProperty(String string) {
        if (super.isInvalidProperty(string)) {
            return true;
        }
        String string2 = string.toLowerCase();
        String[] stringArray = ProductDerivations.getConfigurationPrefixes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.startsWith(stringArray[i] + ".ndb")) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> DomainTypeHandler<T> createDomainTypeHandler(Class<T> clazz, Dictionary dictionary, ValueHandlerFactory valueHandlerFactory) {
        DomainTypeHandler domainTypeHandler = this.domainTypeHandlerMap.get(clazz);
        if (domainTypeHandler == null) {
            throw new ClusterJFatalInternalException(local.message("ERR_Create_Domain_Type_Handler_First", (Object)clazz.getName()));
        }
        return domainTypeHandler;
    }

    static {
        try {
            intValueMethod = IntValue.class.getMethod("get", null);
            booleanValueMethod = BooleanValue.class.getMethod("get", null);
        }
        catch (SecurityException securityException) {
            throw new ClusterJFatalInternalException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ClusterJFatalInternalException(noSuchMethodException);
        }
    }
}

