/*****************************************************************************

Copyright (c) 1995, 2009, Innobase Oy. All Rights Reserved.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 
51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

*****************************************************************************/

#include "univ.i"
#line 2 "lexyy.c"

#line 4 "lexyy.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 31
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined __STDC_VERSION__ && __STDC_VERSION__ >= 199901L
#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart(yyin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

static int yyleng;

static FILE *yyin, *yyout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when yytext is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
static int yyleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static void yyrestart (FILE *input_file  );
__attribute__((unused)) static void yy_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
static YY_BUFFER_STATE yy_create_buffer (FILE *file,int size  );
static void yy_delete_buffer (YY_BUFFER_STATE b  );
static void yy_flush_buffer (YY_BUFFER_STATE b  );
__attribute__((unused)) static void yypush_buffer_state (YY_BUFFER_STATE new_buffer  );
__attribute__((unused)) static void yypop_buffer_state (void );

static void yyensure_buffer_stack (void );
static void yy_load_buffer_state (void );
static void yy_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER yy_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE yy_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE yy_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE yy_scan_bytes (yyconst char *bytes,int len  );

static void *yyalloc (yy_size_t  );
static void *yyrealloc (void *,yy_size_t  );
static void yyfree (void *  );

#define yy_new_buffer yy_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer(yyin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define yywrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

static FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

typedef int yy_state_type;

static int yylineno;

static int yylineno = 1;

static char *yytext;
#define yytext_ptr yytext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	yyleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 119
#define YY_END_OF_BUFFER 120
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[399] =
    {   0,
        0,    0,  114,  114,    0,    0,    0,    0,  120,  118,
      117,  117,    8,  118,  109,    5,   98,  104,  107,  105,
      102,  106,  118,  108,    1,  118,  103,  101,   99,  100,
      112,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
      110,  111,  114,  115,    6,    7,    9,   10,  117,    4,
       93,  113,    2,    1,    3,   94,   95,   97,   96,   92,
       92,   92,   92,   92,   92,   44,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   28,   17,   25,   92,   92,   92,   92,   92,

       54,   61,   92,   14,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   92,  114,  115,  115,  116,    6,    7,    9,   10,
        2,   13,   45,   92,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       92,   27,   92,   92,   92,   41,   92,   92,   92,   92,
       21,   92,   92,   92,   92,   15,   92,   92,   92,   18,
       92,   92,   92,   92,   92,   80,   92,   92,   92,   51,
       92,   12,   92,   36,   92,   92,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   20,   24,

       92,   92,   92,   92,   92,   92,   92,   92,   92,   92,
       46,   92,   92,   30,   92,   87,   92,   92,   39,   92,
       92,   92,   92,   92,   48,   92,   89,   32,   91,   92,
       11,   64,   92,   92,   92,   42,   92,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   29,   92,   92,   92,
       92,   92,   92,   92,   92,   92,   85,   92,   26,   92,
       66,   92,   92,   92,   37,   92,   92,   92,   92,   92,
       92,   92,   31,   65,   23,   92,   57,   92,   75,   92,
       92,   92,   43,   92,   92,   92,   92,   92,   92,   92,
       92,   90,   92,   92,   56,   92,   92,   92,   92,   92,

       92,   92,   40,   33,   79,   19,   92,   83,   74,   55,
       92,   63,   92,   52,   92,   92,   92,   47,   92,   76,
       92,   78,   92,   92,   34,   92,   92,   92,   35,   72,
       92,   92,   92,   92,   58,   92,   50,   49,   92,   92,
       53,   62,   92,   92,   92,   22,   92,   92,   73,   81,
       92,   92,   77,   92,   68,   92,   92,   92,   92,   38,
       92,   88,   67,   92,   84,   92,   92,   92,   86,   92,
       59,   92,   16,   92,   70,   69,   92,   92,   82,   92,
       92,   92,   92,   92,   92,   92,   92,   92,   92,   71,
       92,   92,   92,   92,   92,   92,   60,    0

    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    4,    1,    5,    6,    1,    7,    8,
        9,   10,   11,   12,   13,   14,   15,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   17,   18,   19,
       20,   21,   22,    1,   23,   24,   25,   26,   27,   28,
       29,   30,   31,   32,   33,   34,   35,   36,   37,   38,
       39,   40,   41,   42,   43,   44,   45,   46,   47,   32,
        1,    1,    1,    1,   48,    1,   32,   32,   32,   32,

       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   32,   32,   32,   32,   32,   32,   32,   32,
       32,   32,   49,    1,   50,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[51] =
    {   0,
        1,    1,    1,    2,    1,    1,    3,    1,    1,    4,
        1,    1,    1,    1,    1,    5,    1,    1,    1,    6,
        1,    1,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    1,    1
    } ;

static yyconst flex_int16_t yy_base[409] =
    {   0,
        0,    0,  437,  436,  438,  437,  439,  438,  441,  448,
       49,   51,  448,    0,  448,  448,  448,  448,  448,  448,
      448,  448,  426,  429,   41,  418,  448,   38,  448,  417,
      448,   20,   33,   32,   46,   40,   44,    0,   54,   52,
      399,   48,   60,  395,   65,   67,   81,   27,  411,   75,
      448,  448,    0,   98,    0,  426,    0,  428,  113,    0,
      448,  448,  415,   54,  410,  448,  448,  448,  448,    0,
      403,   68,  399,  391,  389,    0,  402,   80,   84,  397,
      383,   96,  381,  394,  379,  393,  387,  375,  379,  375,
      377,  377,    0,   98,    0,  376,   97,  385,  368,  375,

        0,    0,  381,  381,  364,   94,  103,  379,   98,   65,
      381,  369,  109,  361,  377,  373,  351,   97,  372,  363,
      115,  356,    0,  137,  138,  448,    0,  388,    0,  390,
      377,    0,    0,  365,  360,  367,  365,  348,  346,  345,
      350,  359,  347,  359,   95,  347,  353,  354,  336,  336,
      123,    0,  334,  350,  351,    0,  338,  347,  344,  122,
      124,  341,  336,  330,  340,  338,  331,  328,  336,    0,
      326,  336,  334,  325,  315,  309,  322,  307,  327,    0,
      313,    0,  311,    0,  325,  316,  313,  131,  309,  316,
      323,  302,  304,  309,  309,  301,  304,  299,    0,    0,

      311,  295,  305,  312,  292,  291,  305,  294,  307,  287,
        0,  297,  279,    0,  298,    0,  295,  282,    0,  281,
      276,  281,  280,  290,    0,  276,    0,    0,    0,  280,
        0,    0,  276,  273,  287,    0,  272,  272,  270,  286,
      271,  283,  280,  264,  282,  277,    0,  272,  272,  258,
      257,  270,  256,  270,  269,  268,    0,  252,    0,  246,
        0,  265,  249,  248,    0,  262,  252,  247,  246,  258,
      248,  247,    0,    0,    0,  251,    0,  239,    0,  253,
      249,  235,    0,  249,  250,  233,  238,  231,  249,  231,
      228,    0,  229,  226,    0,  231,  243,  230,  237,  227,

      235,  220,    0,    0,    0,  212,  219,    0,    0,    0,
      216,    0,  230,    0,  231,  218,  217,    0,  213,    0,
      216,    0,  208,  210,    0,  209,  223,  216,    0,    0,
      219,  222,  204,  219,    0,  215,    0,    0,  199,  213,
        0,    0,  197,  196,  201,    0,  210,  195,    0,    0,
      201,  197,    0,  192,    0,  204,  204,  192,  202,    0,
      179,    0,    0,  199,    0,  183,  177,  183,    0,  174,
        0,  193,    0,  192,    0,    0,  183,  187,    0,  174,
      174,  180,  166,  189,  181,  180,  166,  151,  118,    0,
      130,  136,  127,  123,  119,  111,    0,  448,  167,  173,

      179,  152,  181,  124,  187,  193,  199,  205
    } ;

static yyconst flex_int16_t yy_def[409] =
    {   0,
      398,    1,  399,  399,  400,  400,  401,  401,  398,  398,
      398,  398,  398,  402,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  403,  398,  398,  398,  398,
      398,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      398,  398,  405,  406,  407,  398,  408,  398,  398,  402,
      398,  398,  398,  398,  403,  398,  398,  398,  398,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,

      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  405,  406,  406,  398,  407,  398,  408,  398,
      398,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,

      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,

      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,  404,  404,  404,
      404,  404,  404,  404,  404,  404,  404,    0,  398,  398,

      398,  398,  398,  398,  398,  398,  398,  398
    } ;

static yyconst flex_int16_t yy_nxt[499] =
    {   0,
       10,   11,   12,   13,   14,   15,   16,   17,   18,   19,
       20,   21,   22,   23,   24,   25,   26,   27,   28,   29,
       30,   31,   32,   33,   34,   35,   36,   37,   38,   38,
       39,   38,   38,   40,   41,   42,   43,   44,   38,   45,
       46,   47,   48,   49,   50,   38,   38,   38,   51,   52,
       59,   59,   59,   59,   63,   71,   64,   67,   68,   73,
       72,   77,  118,   74,  119,   78,   75,   63,   79,   64,
       88,   80,   82,   85,   81,   86,   83,   89,   96,   76,
       90,   93,   84,   91,   99,   87,   92,  101,   97,   94,
      100,  107,  133,  110,   95,  102,  111,  103,  179,  104,

      108,  109,  105,  115,  121,  112,  180,  125,  134,  113,
      116,  122,  126,  114,   59,   59,  139,  117,  141,  142,
      146,  163,  140,  159,  171,  173,  143,  189,   70,  147,
      172,  177,  183,  164,  207,  208,  148,  190,  160,  161,
      174,  193,  178,  184,  175,  194,  398,  125,  222,  214,
      224,  398,  126,  215,  248,  249,   60,  397,  396,  395,
      225,  394,  393,  223,  392,  391,  250,   53,   53,   53,
       53,   53,   53,   55,   55,   55,   55,   55,   55,   57,
       57,   57,   57,   57,   57,   65,   65,  123,  123,  123,
      390,  123,  123,  124,  124,  124,  124,  124,  124,  127,

      127,  389,  127,  127,  127,  129,  388,  129,  129,  129,
      129,  387,  386,  385,  384,  383,  382,  381,  380,  379,
      378,  377,  376,  375,  374,  373,  372,  371,  370,  369,
      368,  367,  366,  365,  364,  363,  362,  361,  360,  359,
      358,  357,  356,  355,  354,  353,  352,  351,  350,  349,
      348,  347,  346,  345,  344,  343,  342,  341,  340,  339,
      338,  337,  336,  335,  334,  333,  332,  331,  330,  329,
      328,  327,  326,  325,  324,  323,  322,  321,  320,  319,
      318,  317,  316,  315,  314,  313,  312,  311,  310,  309,
      308,  307,  306,  305,  304,  303,  302,  301,  300,  299,

      298,  297,  296,  295,  294,  293,  292,  291,  290,  289,
      288,  287,  286,  285,  284,  283,  282,  281,  280,  279,
      278,  277,  276,  275,  274,  273,  272,  271,  270,  269,
      268,  267,  266,  265,  264,  263,  262,  261,  260,  259,
      258,  257,  256,  255,  254,  253,  252,  251,  247,  246,
      245,  244,  243,  242,  241,  240,  239,  238,  237,  236,
      235,  234,  233,  232,  231,  230,  229,  228,  227,  226,
      221,  220,  219,  218,  217,  216,  213,  212,  211,  210,
      209,  206,  205,  204,  203,  202,  201,  200,  199,  198,
      197,  196,  131,  130,  128,  195,  192,  191,  188,  187,

      186,  185,  182,  181,  176,  170,  169,  168,  167,  166,
      165,  162,  158,  157,  156,  155,  154,  153,  152,  151,
      150,  149,  145,  144,  138,  137,  136,  135,  132,  398,
      131,  130,  128,  120,  106,   98,   69,   66,   62,   61,
      398,   58,   58,   56,   56,   54,   54,    9,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398

    } ;

static yyconst flex_int16_t yy_chk[499] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
       11,   11,   12,   12,   25,   32,   25,   28,   28,   33,
       32,   34,   48,   33,   48,   34,   33,   64,   34,   64,
       37,   34,   35,   36,   34,   36,   35,   37,   40,   33,
       37,   39,   35,   37,   42,   36,   37,   43,   40,   39,
       42,   45,   72,   46,   39,   43,   46,   43,  110,   43,

       45,   45,   43,   47,   50,   46,  110,   54,   72,   46,
       47,   50,   54,   46,   59,   59,   78,   47,   79,   79,
       82,   97,   78,   94,  106,  107,   79,  118,  404,   82,
      106,  109,  113,   97,  145,  145,   82,  118,   94,   94,
      107,  121,  109,  113,  107,  121,  124,  125,  160,  151,
      161,  124,  125,  151,  188,  188,  402,  396,  395,  394,
      161,  393,  392,  160,  391,  389,  188,  399,  399,  399,
      399,  399,  399,  400,  400,  400,  400,  400,  400,  401,
      401,  401,  401,  401,  401,  403,  403,  405,  405,  405,
      388,  405,  405,  406,  406,  406,  406,  406,  406,  407,

      407,  387,  407,  407,  407,  408,  386,  408,  408,  408,
      408,  385,  384,  383,  382,  381,  380,  378,  377,  374,
      372,  370,  368,  367,  366,  364,  361,  359,  358,  357,
      356,  354,  352,  351,  348,  347,  345,  344,  343,  340,
      339,  336,  334,  333,  332,  331,  328,  327,  326,  324,
      323,  321,  319,  317,  316,  315,  313,  311,  307,  306,
      302,  301,  300,  299,  298,  297,  296,  294,  293,  291,
      290,  289,  288,  287,  286,  285,  284,  282,  281,  280,
      278,  276,  272,  271,  270,  269,  268,  267,  266,  264,
      263,  262,  260,  258,  256,  255,  254,  253,  252,  251,

      250,  249,  248,  246,  245,  244,  243,  242,  241,  240,
      239,  238,  237,  235,  234,  233,  230,  226,  224,  223,
      222,  221,  220,  218,  217,  215,  213,  212,  210,  209,
      208,  207,  206,  205,  204,  203,  202,  201,  198,  197,
      196,  195,  194,  193,  192,  191,  190,  189,  187,  186,
      185,  183,  181,  179,  178,  177,  176,  175,  174,  173,
      172,  171,  169,  168,  167,  166,  165,  164,  163,  162,
      159,  158,  157,  155,  154,  153,  150,  149,  148,  147,
      146,  144,  143,  142,  141,  140,  139,  138,  137,  136,
      135,  134,  131,  130,  128,  122,  120,  119,  117,  116,

      115,  114,  112,  111,  108,  105,  104,  103,  100,   99,
       98,   96,   92,   91,   90,   89,   88,   87,   86,   85,
       84,   83,   81,   80,   77,   75,   74,   73,   71,   65,
       63,   58,   56,   49,   44,   41,   30,   26,   24,   23,
        9,    8,    7,    6,    5,    4,    3,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398,  398,  398,
      398,  398,  398,  398,  398,  398,  398,  398

    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

static int yy_flex_debug;
static int yy_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
static char *yytext;
#line 1 "pars0lex.l"
/**************************************************//**
SQL parser lexical analyzer: input file for the GNU Flex lexer generator

(c) 1997 Innobase Oy

Created 12/14/1997 Heikki Tuuri
Published under the GPL version 2

The InnoDB parser is frozen because MySQL takes care of SQL parsing.
Therefore we normally keep the InnoDB parser C files as they are, and do
not automatically generate them from pars0grm.y and pars0lex.l.

How to make the InnoDB parser and lexer C files:

1. Run ./make_flex.sh to generate lexer files.

2. Run ./make_bison.sh to generate parser files.

These instructions seem to work at least with bison-1.875d and flex-2.5.31 on
Linux.
*******************************************************/
#define YY_NO_INPUT 1
#define YY_NO_UNISTD_H 1
#line 38 "pars0lex.l"
#define YYSTYPE que_node_t*

#include "univ.i"
#include "pars0pars.h"
#include "pars0grm.h"
#include "pars0sym.h"
#include "mem0mem.h"
#include "os0proc.h"

#define malloc(A)	ut_malloc(A)
#define free(A)		ut_free(A)
#define realloc(P, A)	ut_realloc(P, A)
#define exit(A) 	ut_error

#define YY_INPUT(buf, result, max_size) pars_get_lex_chars(buf, &result, max_size)

/* String buffer for removing quotes */
static ulint	stringbuf_len_alloc = 0; /* Allocated length */
static ulint	stringbuf_len = 0; /* Current length */
static char*	stringbuf; /* Start of buffer */
/** Appends a string to the buffer. */
static
void
string_append(
/*==========*/
	const char*	str,	/*!< in: string to be appended */
	ulint		len)	/*!< in: length of the string */
{
	if (stringbuf == NULL) {
		stringbuf = malloc(1);
		stringbuf_len_alloc = 1;
	}

	if (stringbuf_len + len > stringbuf_len_alloc) {
		while (stringbuf_len + len > stringbuf_len_alloc) {
			stringbuf_len_alloc <<= 1;
		}
		stringbuf = realloc(stringbuf, stringbuf_len_alloc);
	}

	memcpy(stringbuf + stringbuf_len, str, len);
	stringbuf_len += len;
}




#line 759 "lexyy.c"

#define INITIAL 0
#define comment 1
#define quoted 2
#define id 3

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap (void );
#else
extern int yywrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( yytext, yyleng, 1, yyout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, yyin))==0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

UNIV_INTERN int yylex (void);

#define YY_DECL UNIV_INTERN int yylex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 92 "pars0lex.l"


#line 914 "lexyy.c"

	if ( (yy_init) )
		{
		(yy_init) = 0;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer(yyin,YY_BUF_SIZE );
		}

		yy_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of yytext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 399 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_current_state != 398 );
		yy_cp = (yy_last_accepting_cpos);
		yy_current_state = (yy_last_accepting_state);

yy_find_action:
		yy_act = yy_accept[yy_current_state];

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 94 "pars0lex.l"
{
			yylval = sym_tab_add_int_lit(pars_sym_tab_global,
								atoi(yytext));
			return(PARS_INT_LIT);
}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 100 "pars0lex.l"
{
			ut_error;	/* not implemented */

			return(PARS_FLOAT_LIT);
}
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 106 "pars0lex.l"
{
			ulint	type;

			yylval = sym_tab_add_bound_lit(pars_sym_tab_global,
				yytext + 1, &type);

			return((int) type);
}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 115 "pars0lex.l"
{
			yylval = sym_tab_add_bound_id(pars_sym_tab_global,
				yytext + 1);

			return(PARS_ID_TOKEN);
}
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 122 "pars0lex.l"
{
/* Quoted character string literals are handled in an explicit
start state 'quoted'.  This state is entered and the buffer for
the scanned string is emptied upon encountering a starting quote.

In the state 'quoted', only two actions are possible (defined below). */
			BEGIN(quoted);
			stringbuf_len = 0;
}
	YY_BREAK
case 6:
/* rule 6 can match eol */
YY_RULE_SETUP
#line 131 "pars0lex.l"
{
			/* Got a sequence of characters other than "'":
			append to string buffer */
			string_append(yytext, yyleng);
}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 136 "pars0lex.l"
{
			/* Got a sequence of "'" characters:
			append half of them to string buffer,
			as "''" represents a single "'".
			We apply truncating division,
			so that "'''" will result in "'". */

			string_append(yytext, yyleng / 2);

			/* If we got an odd number of quotes, then the
			last quote we got is the terminating quote.
			At the end of the string, we return to the
			initial start state and report the scanned
			string literal. */

			if (yyleng % 2) {
				BEGIN(INITIAL);
				yylval = sym_tab_add_str_lit(
					pars_sym_tab_global,
					(byte*) stringbuf, stringbuf_len);
				return(PARS_STR_LIT);
			}
}
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 160 "pars0lex.l"
{
/* Quoted identifiers are handled in an explicit start state 'id'.
This state is entered and the buffer for the scanned string is emptied
upon encountering a starting quote.

In the state 'id', only two actions are possible (defined below). */
			BEGIN(id);
			stringbuf_len = 0;
}
	YY_BREAK
case 9:
/* rule 9 can match eol */
YY_RULE_SETUP
#line 169 "pars0lex.l"
{
			/* Got a sequence of characters other than '"':
			append to string buffer */
			string_append(yytext, yyleng);
}
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 174 "pars0lex.l"
{
			/* Got a sequence of '"' characters:
			append half of them to string buffer,
			as '""' represents a single '"'.
			We apply truncating division,
			so that '"""' will result in '"'. */

			string_append(yytext, yyleng / 2);

			/* If we got an odd number of quotes, then the
			last quote we got is the terminating quote.
			At the end of the string, we return to the
			initial start state and report the scanned
			identifier. */

			if (yyleng % 2) {
				BEGIN(INITIAL);
				yylval = sym_tab_add_id(
					pars_sym_tab_global,
					(byte*) stringbuf, stringbuf_len);

				return(PARS_ID_TOKEN);
			}
}
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 199 "pars0lex.l"
{
			yylval = sym_tab_add_null_lit(pars_sym_tab_global);

			return(PARS_NULL_LIT);
}
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 205 "pars0lex.l"
{
			/* Implicit cursor name */
			yylval = sym_tab_add_str_lit(pars_sym_tab_global,
							(byte*) yytext, yyleng);
			return(PARS_SQL_TOKEN);
}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 212 "pars0lex.l"
{
			return(PARS_AND_TOKEN);
}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 216 "pars0lex.l"
{
			return(PARS_OR_TOKEN);
}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 220 "pars0lex.l"
{
			return(PARS_NOT_TOKEN);
}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 224 "pars0lex.l"
{
			return(PARS_PROCEDURE_TOKEN);
}
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 228 "pars0lex.l"
{
			return(PARS_IN_TOKEN);
}
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 232 "pars0lex.l"
{
			return(PARS_OUT_TOKEN);
}
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 236 "pars0lex.l"
{
	 		return(PARS_BINARY_TOKEN);
}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 240 "pars0lex.l"
{
	 		return(PARS_BLOB_TOKEN);
}
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 244 "pars0lex.l"
{
	 		return(PARS_INT_TOKEN);
}
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 248 "pars0lex.l"
{
	 		return(PARS_INT_TOKEN);
}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 252 "pars0lex.l"
{
	 		return(PARS_FLOAT_TOKEN);
}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 256 "pars0lex.l"
{
	 		return(PARS_CHAR_TOKEN);
}
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 260 "pars0lex.l"
{
			return(PARS_IS_TOKEN);
}
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 264 "pars0lex.l"
{
			return(PARS_BEGIN_TOKEN);
}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 268 "pars0lex.l"
{
			return(PARS_END_TOKEN);
}
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 272 "pars0lex.l"
{
			return(PARS_IF_TOKEN);
}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 276 "pars0lex.l"
{
			return(PARS_THEN_TOKEN);
}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 280 "pars0lex.l"
{
			return(PARS_ELSE_TOKEN);
}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 284 "pars0lex.l"
{
			return(PARS_ELSIF_TOKEN);
}
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 288 "pars0lex.l"
{
			return(PARS_LOOP_TOKEN);
}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 292 "pars0lex.l"
{
			return(PARS_WHILE_TOKEN);
}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 296 "pars0lex.l"
{
			return(PARS_RETURN_TOKEN);
}
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 300 "pars0lex.l"
{
			return(PARS_SELECT_TOKEN);
}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 304 "pars0lex.l"
{
			return(PARS_SUM_TOKEN);
}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 308 "pars0lex.l"
{
			return(PARS_COUNT_TOKEN);
}
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 312 "pars0lex.l"
{
			return(PARS_DISTINCT_TOKEN);
}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 316 "pars0lex.l"
{
			return(PARS_FROM_TOKEN);
}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 320 "pars0lex.l"
{
			return(PARS_WHERE_TOKEN);
}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 324 "pars0lex.l"
{
			return(PARS_FOR_TOKEN);
}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 328 "pars0lex.l"
{
			return(PARS_READ_TOKEN);
}
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 332 "pars0lex.l"
{
			return(PARS_ORDER_TOKEN);
}
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 336 "pars0lex.l"
{
			return(PARS_BY_TOKEN);
}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 340 "pars0lex.l"
{
			return(PARS_ASC_TOKEN);
}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 344 "pars0lex.l"
{
			return(PARS_DESC_TOKEN);
}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 348 "pars0lex.l"
{
			return(PARS_INSERT_TOKEN);
}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 352 "pars0lex.l"
{
			return(PARS_INTO_TOKEN);
}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 356 "pars0lex.l"
{
			return(PARS_VALUES_TOKEN);
}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 360 "pars0lex.l"
{
			return(PARS_UPDATE_TOKEN);
}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 364 "pars0lex.l"
{
			return(PARS_SET_TOKEN);
}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 368 "pars0lex.l"
{
			return(PARS_DELETE_TOKEN);
}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 372 "pars0lex.l"
{
			return(PARS_CURRENT_TOKEN);
}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 376 "pars0lex.l"
{
			return(PARS_OF_TOKEN);
}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 380 "pars0lex.l"
{
			return(PARS_CREATE_TOKEN);
}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 384 "pars0lex.l"
{
			return(PARS_TABLE_TOKEN);
}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 388 "pars0lex.l"
{
	 		return(PARS_INDEX_TOKEN);
}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 392 "pars0lex.l"
{
	 		return(PARS_UNIQUE_TOKEN);
}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 396 "pars0lex.l"
{
	 		return(PARS_CLUSTERED_TOKEN);
}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 400 "pars0lex.l"
{
			return(PARS_DOES_NOT_FIT_IN_MEM_TOKEN);
}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 404 "pars0lex.l"
{
	 		return(PARS_ON_TOKEN);
}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 408 "pars0lex.l"
{
			return(PARS_DECLARE_TOKEN);
}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 412 "pars0lex.l"
{
			return(PARS_CURSOR_TOKEN);
}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 416 "pars0lex.l"
{
			return(PARS_OPEN_TOKEN);
}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 420 "pars0lex.l"
{
			return(PARS_FETCH_TOKEN);
}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 424 "pars0lex.l"
{
			return(PARS_CLOSE_TOKEN);
}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 428 "pars0lex.l"
{
			return(PARS_NOTFOUND_TOKEN);
}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 432 "pars0lex.l"
{
			return(PARS_TO_CHAR_TOKEN);
}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 436 "pars0lex.l"
{
			return(PARS_TO_NUMBER_TOKEN);
}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 440 "pars0lex.l"
{
			return(PARS_TO_BINARY_TOKEN);
}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 444 "pars0lex.l"
{
			return(PARS_BINARY_TO_NUMBER_TOKEN);
}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 448 "pars0lex.l"
{
			return(PARS_SUBSTR_TOKEN);
}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 452 "pars0lex.l"
{
			return(PARS_REPLSTR_TOKEN);
}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 456 "pars0lex.l"
{
			return(PARS_CONCAT_TOKEN);
}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 460 "pars0lex.l"
{
			return(PARS_INSTR_TOKEN);
}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 464 "pars0lex.l"
{
			return(PARS_LENGTH_TOKEN);
}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 468 "pars0lex.l"
{
			return(PARS_SYSDATE_TOKEN);
}
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 472 "pars0lex.l"
{
			return(PARS_PRINTF_TOKEN);
}
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 476 "pars0lex.l"
{
			return(PARS_ASSERT_TOKEN);
}
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 480 "pars0lex.l"
{
			return(PARS_RND_TOKEN);
}
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 484 "pars0lex.l"
{
			return(PARS_RND_STR_TOKEN);
}
	YY_BREAK
case 82:
YY_RULE_SETUP
#line 488 "pars0lex.l"
{
			return(PARS_ROW_PRINTF_TOKEN);
}
	YY_BREAK
case 83:
YY_RULE_SETUP
#line 492 "pars0lex.l"
{
			return(PARS_COMMIT_TOKEN);
}
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 496 "pars0lex.l"
{
			return(PARS_ROLLBACK_TOKEN);
}
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 500 "pars0lex.l"
{
			return(PARS_WORK_TOKEN);
}
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 504 "pars0lex.l"
{
			return(PARS_UNSIGNED_TOKEN);
}
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 508 "pars0lex.l"
{
			return(PARS_EXIT_TOKEN);
}
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 512 "pars0lex.l"
{
			return(PARS_FUNCTION_TOKEN);
}
	YY_BREAK
case 89:
YY_RULE_SETUP
#line 516 "pars0lex.l"
{
			return(PARS_LOCK_TOKEN);
}
	YY_BREAK
case 90:
YY_RULE_SETUP
#line 520 "pars0lex.l"
{
			return(PARS_SHARE_TOKEN);
}
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 524 "pars0lex.l"
{
			return(PARS_MODE_TOKEN);
}
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 528 "pars0lex.l"
{
			yylval = sym_tab_add_id(pars_sym_tab_global,
							(byte*)yytext,
							ut_strlen(yytext));
			return(PARS_ID_TOKEN);
}
	YY_BREAK
case 93:
YY_RULE_SETUP
#line 535 "pars0lex.l"
{
			return(PARS_DDOT_TOKEN);
}
	YY_BREAK
case 94:
YY_RULE_SETUP
#line 539 "pars0lex.l"
{
			return(PARS_ASSIGN_TOKEN);
}
	YY_BREAK
case 95:
YY_RULE_SETUP
#line 543 "pars0lex.l"
{
			return(PARS_LE_TOKEN);
}
	YY_BREAK
case 96:
YY_RULE_SETUP
#line 547 "pars0lex.l"
{
			return(PARS_GE_TOKEN);
}
	YY_BREAK
case 97:
YY_RULE_SETUP
#line 551 "pars0lex.l"
{
			return(PARS_NE_TOKEN);
}
	YY_BREAK
case 98:
YY_RULE_SETUP
#line 555 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 99:
YY_RULE_SETUP
#line 560 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 100:
YY_RULE_SETUP
#line 565 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 101:
YY_RULE_SETUP
#line 570 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 102:
YY_RULE_SETUP
#line 575 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 103:
YY_RULE_SETUP
#line 580 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 104:
YY_RULE_SETUP
#line 585 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 105:
YY_RULE_SETUP
#line 590 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 106:
YY_RULE_SETUP
#line 595 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 107:
YY_RULE_SETUP
#line 600 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 108:
YY_RULE_SETUP
#line 605 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 109:
YY_RULE_SETUP
#line 610 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 110:
YY_RULE_SETUP
#line 615 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 111:
YY_RULE_SETUP
#line 620 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 112:
YY_RULE_SETUP
#line 625 "pars0lex.l"
{

			return((int)(*yytext));
}
	YY_BREAK
case 113:
YY_RULE_SETUP
#line 630 "pars0lex.l"
BEGIN(comment); /* eat up comment */
	YY_BREAK
case 114:
/* rule 114 can match eol */
YY_RULE_SETUP
#line 632 "pars0lex.l"

	YY_BREAK
case 115:
/* rule 115 can match eol */
YY_RULE_SETUP
#line 633 "pars0lex.l"

	YY_BREAK
case 116:
YY_RULE_SETUP
#line 634 "pars0lex.l"
BEGIN(INITIAL);
	YY_BREAK
case 117:
/* rule 117 can match eol */
YY_RULE_SETUP
#line 636 "pars0lex.l"
/* eat up whitespace */
	YY_BREAK
case 118:
YY_RULE_SETUP
#line 639 "pars0lex.l"
{
			fprintf(stderr,"Unrecognized character: %02x\n",
				*yytext);

			ut_error;

			return(0);
}
	YY_BREAK
case 119:
YY_RULE_SETUP
#line 648 "pars0lex.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 1916 "lexyy.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(comment):
case YY_STATE_EOF(quoted):
case YY_STATE_EOF(id):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_last_accepting_cpos);
				yy_current_state = (yy_last_accepting_state);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( yywrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart(yyin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 399 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 399 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 398);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (int)((yy_c_buf_p) - (yytext_ptr));
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart(yyin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve yytext */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    static void yyrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer(yyin,YY_BUF_SIZE );
	}

	yy_init_buffer(YY_CURRENT_BUFFER,input_file );
	yy_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    __attribute__((unused)) static void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void yy_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    static YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * 
 */
    static void yy_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree((void *) b->yy_ch_buf  );

	yyfree((void *) b  );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	yy_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    static void yy_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
__attribute__((unused)) static void yypush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack();

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
__attribute__((unused)) static void yypop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)yyrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = (yy_hold_char); \
		(yy_c_buf_p) = yytext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
__attribute__((unused)) static int yyget_lineno  (void)
{
        
    return yylineno;
}

/** Get the input stream.
 * 
 */
__attribute__((unused)) static FILE *yyget_in  (void)
{
        return yyin;
}

/** Get the output stream.
 * 
 */
__attribute__((unused)) static FILE *yyget_out  (void)
{
        return yyout;
}

/** Get the length of the current token.
 * 
 */
__attribute__((unused)) static int yyget_leng  (void)
{
        return yyleng;
}

/** Get the current token.
 * 
 */

__attribute__((unused)) static char *yyget_text  (void)
{
        return yytext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
__attribute__((unused)) static void yyset_lineno (int  line_number )
{
    
    yylineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see yy_switch_to_buffer
 */
__attribute__((unused)) static void yyset_in (FILE *  in_str )
{
        yyin = in_str ;
}

__attribute__((unused)) static void yyset_out (FILE *  out_str )
{
        yyout = out_str ;
}

__attribute__((unused)) static int yyget_debug  (void)
{
        return yy_flex_debug;
}

__attribute__((unused)) static void yyset_debug (int  bdebug )
{
        yy_flex_debug = bdebug ;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
__attribute__((unused)) static int yylex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state();
	}

	/* Destroy the stack itself. */
	yyfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
    	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
    	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

static void *yyalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

static void *yyrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

static void yyfree (void * ptr )
{
	free( (char *) ptr );	/* see yyrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#undef YY_NEW_FILE
#undef YY_FLUSH_BUFFER
#undef yy_set_bol
#undef yy_new_buffer
#undef yy_set_interactive
#undef yytext_ptr
#undef YY_DO_BEFORE_ACTION

#ifdef YY_DECL_IS_OURS
#undef YY_DECL_IS_OURS
#undef YY_DECL
#endif
#line 648 "pars0lex.l"




/**********************************************************************
Release any resources used by the lexer. */
UNIV_INTERN
void
pars_lexer_close(void)
/*==================*/
{
	yylex_destroy();
	free(stringbuf);
	stringbuf = NULL;
	stringbuf_len_alloc = stringbuf_len = 0;
}
