/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.SQLClientHandler;
import com.ice.util.AWTUtilities;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

public class UpdatePanel
extends JPanel
implements ActionListener {
    private JTextArea updateText;
    private JTextArea resultText;
    private JButton queryButton;
    private JPanel updatePanel;
    private JPanel resultPanel;
    private JSplitPane splitPane;

    public UpdatePanel() {
        this.setDoubleBuffered(true);
        this.establishContents();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("UPDATE")) {
            String string2 = this.updateText.getText();
            SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
            if (sQLClientHandler == null) {
                this.resultText.setText("INTERNAL ERROR: current handler is null.");
                return;
            }
            if (!sQLClientHandler.isOpen()) {
                this.resultText.setText("INTERNAL ERROR: connection is not open.");
                return;
            }
            try {
                int n = sQLClientHandler.performSQLUpdate(String.valueOf(string2) + "\n");
                this.resultText.setText(n + " row" + (n > 1 ? "s" : "") + " affected.");
                return;
            }
            catch (SQLException sQLException) {
                this.resultText.setText("SQLException: performing update\n" + sQLException.getMessage());
                return;
            }
        }
        this.resultText.setText("INTERNAL ERROR: unknown command: " + string);
    }

    private void establishContents() {
        int n = 0;
        ((Container)((Object)this)).setLayout(new BorderLayout());
        this.updatePanel = new JPanel();
        this.updatePanel.setLayout(new GridBagLayout());
        this.updatePanel.setPreferredSize(new Dimension(450, 125));
        JLabel jLabel = new JLabel("Update:");
        AWTUtilities.constrain((Container)this.updatePanel, (Component)jLabel, 0, 17, 0, n, 2, 1, 0.0, 0.0);
        this.updateText = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.updateText);
        AWTUtilities.constrain((Container)this.updatePanel, (Component)jScrollPane, 1, 10, 0, ++n, 2, 1, 1.0, 1.0);
        this.queryButton = new JButton("Perform Update");
        this.queryButton.setActionCommand("UPDATE");
        this.queryButton.addActionListener((ActionListener)this);
        AWTUtilities.constrain((Container)this.updatePanel, (Component)this.queryButton, 2, 10, 0, ++n, 2, 1, 1.0, 0.0);
        this.resultPanel = new JPanel();
        this.resultPanel.setLayout(new GridBagLayout());
        n = 0;
        jLabel = new JLabel("Result:");
        AWTUtilities.constrain((Container)this.resultPanel, (Component)jLabel, 0, 17, 0, n, 1, 1, 0.0, 0.0);
        this.resultText = new JTextArea();
        jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this.resultText);
        AWTUtilities.constrain((Container)this.resultPanel, (Component)jScrollPane, 1, 10, 0, ++n, 1, 1, 1.0, 1.0);
        ++n;
        this.splitPane = new JSplitPane(0, (Component)this.updatePanel, (Component)this.resultPanel);
        this.splitPane.setDividerSize(3);
        this.splitPane.setContinuousLayout(true);
        ((Container)((Object)this)).add((Component)this.splitPane, "Center");
    }
}

