#!/usr/bin/perl -w
# genquery.pl  Author:Marc Beneteau Mailto:marc@odbsoft.com  Date:Oct/98
# "Generic" SQL query generator and html form and table generator.  

package genquery;

#########################
#Open database connection
sub main'dbOpen {
	if(1) { 
	#remote database
		$dbh = DBI->connect('dbi:mysql:cook', 'cook', 'xxx')
			|| die "Cannot connect to db server $DBI::errstr,\n";
		$remote_db=1;
	}else{
		$dbh = DBI->connect('dbi:ODBC:cook', '', '') 
			|| die "Cannot connect to db server $DBI::errstr,\n";
		$remote_db=0;
	}
}

#########################
#Open cursor
sub main'dbExecute {
	my ($sql)=@_;
	$cursor =$dbh->prepare($sql) 
		|| die "Cannot prepare statement: $DBI::errstr\n";
    $cursor->execute;
}

#########################
#Fetch
sub main'dbFetch {
	$cursor->fetchrow;	 #returns @fields
}

#########################
#Execute statement
sub main'dbDo {
	my ($sql)=@_;
	my $rows=$dbh->do($sql) || die $dbh->errstr;
	$rows;
}

#########################
#Close cursor
sub main'dbCloseCursor {
	$cursor->finish;
}

#########################
#Close connection
sub main'dbClose {
	$dbh->disconnect;
}

#########################
#Automatically generate an SQL INSERT statement from the names/values of form parameters 
sub main'GenInsert {
	my ($q,$table)=@_;
	my @fparam=$q->param; #names of all parameters
	my $first_where=1;
	my $first_col=1;
	$sql='insert into '.$table.' (';
	$values=' values (';
	for($i=0;defined(my $fname=$fparam[$i]);$i++) {
		$fn=lc($fname);
		my $fvalue=$q->param($fname);
		if(length($fvalue)==0) {next;}
		if($fn eq 'debug' || $fn eq 'submit' || $fn eq 'id' 
		|| $fn eq 'table' || $fn eq 'date_created' || $fn eq 'orderby') 
			{next;}
		if($fn eq 'state' || $fn eq 'country') {$fvalue=uc($fvalue)}
		if($first_col) {
			$first_col=0;
		}else{
			$sql.=',';
			$values.=',';
		}
		$sql.=$fname;
		$fvalue=~s/\cM//g;
		$fvalue=~s/\n\n/<p>/g;
		$fvalue=~s/\n/<br>/g;
		$values.=$dbh->quote($fvalue);
	}
	$sql.=')';
	$values.=')';
	$sql.$values; 
}

####################
#Generate an SQL UPDATE statement from the names/values of form parameters 
sub main'GenUpdate {
	my ($q,$table,$id)=@_;
	my @fparam=$q->param; 
	my $first_col=1;
	$sql='update '.$table.' set ';
	for($i=0;defined(my $fname=$fparam[$i]);$i++) {
		$fn=lc($fname);
		if($fn eq 'debug' || $fn eq 'submit' || $fn eq 'id' 
		|| $fn eq 'table' || $fn eq 'date_created' || $fn eq 'orderby' || $fn eq 'userkey') 
			{next;}
		my $fvalue=$q->param($fname);
		if($fn eq 'state' || $fn eq 'country') {$fvalue=uc($fvalue)}
		if($first_col) {
			$first_col=0;
		}else{
			$sql.=',';
		}
		$sql.=$fname."=";
		$fvalue=~s/\cM//g;
		$fvalue=~s/\n/<br>/g;
		$sql.=$dbh->quote($fvalue);
	}
	$sql.=" where id=".$id;
	$sql;
}

##################
#Generate the WHERE clause from form parameters
#Pass in the initial sql statement ('Select abc from xyx')
sub main'GenWhere {
	my ($q,$sql)=@_;
	my @fparam=$q->param; #names of all parameters
	my $first_where=1;
	my $first_col=1;
	for($i=0;defined(my $fname=$fparam[$i]);$i++) {
		$fn=lc($fname);
		my $fvalue=$q->param($fname);
		if($fvalue eq '(any)') {$fvalue=''}
		if(length($fvalue)==0 || length($fvalue)>80) {next;}
		if($fn eq 'submit' || $fn eq 'table' || $fn eq 'debug' || $fn eq 'fields' 
			||$fn eq 'orderby') {next;}
		if($first_where) {$first_where=0;$sql.=" WHERE ";}
		if($first_col) {
			$first_col=0; 
		}else{
			$sql.=" AND ";
		}
		$sql.=$fname."=";
		if(lc($fname) eq 'id') { 
			$sql.=$fvalue; #insert numeric value
		} else {
			$sql.=$dbh->quote($fvalue);  #add quotes and escape special chars
		}
	}
	$sql; 
}


####################
#Generates an html table from a cursor
#Parameter is the name of the cgi to execute for the detail view (one record per page)
sub main'GenTable {
	my ($cgipgm)=@_;
	my $cols=$cursor->{NUM_OF_FIELDS};
	print "<table border=1>\n";
	my $i=0;
	print "<tr>";
	for($i=0;$i<$cols;$i++) {
		my $fname=$cursor->{NAME}->[$i];
		$datatype=$cursor->{TYPE}->[$i]; #ODBC 1==char 11==date 4==int -1==text
		if($datatype == -1 || $datatype==252) {next} #don't show longvarchars
		$fn=lc($fname);
		if($fn eq 'userkey' || $fn eq 'password') {next};
		print "<td bgcolor=\"#FFFFCC\"><b>",$fname,"</b></td>";
	}
	print("</tr>");
	
	my $anyrecs=0;
	while(@fields = $cursor->fetchrow) {
		$anyrecs=1;
		print "<TR>";
		my $cols=$cursor->{NUM_OF_FIELDS};
		for($i=0;$i<$cols;$i++) {
			$datatype=$cursor->{TYPE}->[$i]; #ODBC 1==char 11==date 4==int -1==text
			if($datatype == -1 || $datatype==252) {next}
			my $fvalue=$fields[$i];
			my $fname=$cursor->{NAME}->[$i];
			#print $fname,"datatype=",$datatype;
			print "<td nowrap>";
			$fn=lc($fname);
			$fn=lc($fname);
			if($fn eq 'userkey' || $fn eq 'password') {next};
			if($fn eq 'id') { #generate a submit href
				print "<a href=\"",$cgipgm,"&id=",$fvalue,"\">&nbsp",$fields[$i],"&nbsp&nbsp</a>";
			} elsif ($fn eq 'link') { #generate a link href
				print "<a href=\"http://",$fvalue,"\">",$fields[$i],"</a>";
			} else {
				print $fvalue;
				#print $datatype;
			}
		}
		print("</TR>\n");
	}
	print "</table><p>\n";
	if(!$anyrecs) {print "<p>No records matched your query - try removing some of your search criteria";}
	
}

#################
#Generate a full record printout 
sub main'GenFullRecord {
	my ($table,$id,$debug)=@_;
	$sql = "select * from " . $table . " where id=" . $id;
	if(defined $debug) {print "sql=",$sql,"\n";}
	$cursor =$dbh->prepare($sql) 
		|| die "Cannot prepare statement: $DBI::errstr\n";
    $cursor->execute;
	@fields = $cursor->fetchrow;
	main'printCenter($table.":View record");
	print "<table>";
	my $cols=$cursor->{NUM_OF_FIELDS};
	$prec=0;
	for ($i=0;$i<$cols;$i++) {
		$fvalue=$fields[$i];
		if(!defined $fvalue) {$fvalue='';}
		my $fname=$cursor->{NAME}->[$i];
		if($fname eq 'userkey' || $fname eq 'password') {next}
		$fname=~s/_/ /g;
		print "<tr><td align=right valign=top>",$fname,":<td><b>",$fvalue,"</b>";
	}
	print "</table>";
}

#Support functions
sub printRow{
	my($txt,$val)=@_;
	print "<tr><td align=right>",$txt;
	print "<td>",$val;
}
sub main'printCenter {
	my ($txt)=@_;
	print "<center><h2>",$txt,"</h2></center>";
}
sub printSelect {
	my ($name,@values)=@_;
	print "<td><select name=",$name,">";
	foreach $val(@values) {
		print '<option value="',$val,'">',$val;
	}
	print "</select>\n";
}

####################
#Generate a data-entry form for @fields columns (default '*') from table name
#Optionally fill in form with record_id given
sub main'GenForm {
	my ($debug,$table,$id,$fields)=@_;
	$do_update=0;
	$do_query=0;
	if(!(defined $id)) {$id=0}
	if($id>0) {$do_update=1}
	if($id<0) {$do_query=1}
	if(!defined $fields || $fields eq '*') {$fields='*'}
	$sql = "select " . $fields . " from " . $table;
	if($do_update) {$sql.=" where id=" . $id}
	if($debug) {print "sql=",$sql,"\n";}
	main'dbExecute($sql);
	if($do_update) {	@fields = $cursor->fetchrow}
	print "<table><tr><td colspan=2>";

	#####help elements on forms go here####
	#associative array of column names and explanation text
	$tab=lc($table);
	if($tab eq 'ads') {
		%formhelp=('fieldxx1','expl1');
	}elsif($tab eq 'dkdkdk') {

	}

	for($i=0;defined (my $fname=$cursor->{NAME}->[$i]);$i++) {
		#print "$i=",$i,"\n";
		$fn=$lfname=lc($fname);
		$fname=~s/_/ /;
		if($remote_db) {
			$prec=$cursor->{LENGTH}->[$i];
		}else{
			#$prec=$cursor->{PRECISION}->[$i]; doesn't work
			$prec=60;
			if($fn eq 'vegetarian') {$prec=1} #for testing
		}
		$datatype=$cursor->{TYPE}->[$i]; #1==char 11==date 4==int -1==text
		#print "datatype=",$datatype," prec=",$prec,"\n";
		$value='';
		if($do_update) {$value=$fields[$i]}
		
		######Special processing of individual fields goes here####
		if($fn eq 'date_created' || $fn eq 'date_updated') {next} 
		if($fn eq 'id') {
			if($do_query) {
				printRow('Record ID','<input type=text name=id size=5 maxlength=5>');
				next;
			}
			if(!$do_update) {next;} #don't show id field on add new record
			#not all browsers support readonly text variables, put in hidden field for safety
			print "<tr><td align=right>Record ID<td><b>",$id,"</b>";
			print '<input type=hidden name=id value="',$id,'">';
		} elsif($fn eq 'userkey') {
			if($do_query) {next}
			if(0) {
				#user logged in,init from env.
			}else{
				#user always enters
				print "<tr><td align=right>",$fname;
				print '<td><input type=text name=userkey value="" size=',$prec,
					' maxlength=',$prec,'> ';
			}
		} elsif($fn eq 'recipe_type') {
			print "<tr><td align=right>",$fname;
			if($value eq '') {$value='(any)'};
			@opt=($value,'BEVERAGE','APPETIZER','SOUP','BREAD','MAIN DISH','SALAD','DESSERT','OTHER');
			printSelect($fn,@opt);
		} elsif($fn eq 'resource_type') {
			if($value eq '') {$value='(any)'};
			print "<tr><td align=right>",$fname;
			@opt=($value,'ARTICLE','BOOK REVIEW','SITE','OTHER');
			printSelect($fn,@opt);
		} else {
		#standard field processing
			if($prec==1) {
				#check box
				print "<tr><td align=right>",$fname;
				print '<td><input type=checkbox name=',$lfname,' value="Y"';
				if($value) {print ' checked'};
				print '> ';
			}elsif ($prec<200 && $datatype!=-1) { 
				#simple textfield
				print "<tr><td align=right>",$fname;
				print '<td><input type=text name=',$lfname,' value="',$value,
				'" size=',$prec,' maxlength=',$prec,'> ';
			}else{ 
				#textarea
				if($do_query) {next}
				print "<tr><td align=right valign=top>",$fname;
				$value=~s/<br>/\n/g;
				print '<td><textarea name=',$lfname,' wrap=physical rows=18 cols=80>',$value,
				'</textarea> ';
			}
		}
		#print help text
		if(defined %formhelp) {
			print "&nbsp&nbsp",$formhelp{$fn};
		}
	}	
	print "</table>";
	main'dbCloseCursor();
}
1;