// Connection.h : Declaration of the CConnection

#ifndef __CONNECTION_H_
#define __CONNECTION_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CConnection
class ATL_NO_VTABLE CConnection : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CConnection, &CLSID_Connection>,
	public IDispatchImpl<IConnection, &IID_IConnection, &LIBID_MYSQLDBLib>
{
public:
	CConnection()
	{
		port = 3306;
		conn_Open = FALSE;
		db_Open = FALSE;
		this->int_res = NULL;
		this->row = NULL;
		this->fields = NULL;
		this->eofVal = TRUE;
		this->bofVal = TRUE;
		this->fCount = 0;
		this->rCount = 0;
	}
	~CConnection()
	{
		
		this->cleanUP();
	}

DECLARE_REGISTRY_RESOURCEID(IDR_CONNECTION)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CConnection)
	COM_INTERFACE_ENTRY(IConnection)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()
//member variables
private:
	void cleanUP();
	void initMysql();
	CComBSTR userName;
	CComBSTR password;
	CComBSTR host;
	CComBSTR dbname;
	CComBSTR debugInf;
	CComBSTR last_sql;
	CComBSTR error_info;
	int port;
	int rCount;
	int fCount;
	int err_no;
	BOOL eofVal;
	BOOL bofVal;
	BOOL emptyRS;
	BOOL conn_Open;
	BOOL db_Open;
	MYSQL *myData ;
	MYSQL_RES *int_res;
	MYSQL_RES *ext_res;
	MYSQL_FIELD	*fields;
	MYSQL_ROW row ;


// IConnection
public:
	STDMETHOD(get_ErrorNumber)(/*[out, retval]*/ short *pVal);
	STDMETHOD(get_Error)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(Connect)();
	STDMETHOD(Close)();
	STDMETHOD(get_BOF)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(get_EOF)(/*[out, retval]*/ BOOL *pVal);
	STDMETHOD(NextRow)();
	STDMETHOD(get_RowCount)(/*[out, retval]*/ short *pVal);
	STDMETHOD(get_FieldCount)(/*[out, retval]*/ short *pVal);
	STDMETHOD(FieldProperty)(/*[in]*/ short fieldNum, /*[in]*/ fieldProp enumOp,/*[out,retval]*/ BSTR *pVal);
	STDMETHOD(get_DEBUGINFO)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_GetItem)(/*[in]*/short fieldNum,/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(ExecuteInt)(/*[in]*/ BSTR sqlString);
	STDMETHOD(get_Database)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Database)(/*[in]*/ BSTR newVal);
	STDMETHOD(Open)();
	STDMETHOD(get_Port)(/*[out, retval]*/ short *pVal);
	STDMETHOD(put_Port)(/*[in]*/ short newVal);
	STDMETHOD(get_Password)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Password)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Username)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Username)(/*[in]*/ BSTR newVal);
	STDMETHOD(get_Host)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(put_Host)(/*[in]*/ BSTR newVal);
};

#endif //__CONNECTION_H_
