/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public final class ListToString {
    private String prefix;
    private String separator;
    private String postfix;

    public ListToString() {
        this("[", "][", "]");
    }

    public ListToString(String prefix, String separator, String postfix) {
        this.prefix = prefix;
        this.separator = separator;
        this.postfix = postfix;
    }

    public String toString(Object[] objs) {
        if (objs == null) {
            return String.valueOf(null);
        }
        return this.toString(Arrays.asList(objs));
    }

    public String toString(Map map) {
        if (map == null) {
            return String.valueOf(null);
        }
        return this.toString(map.entrySet());
    }

    public String toString(Collection objs) {
        if (objs == null) {
            return String.valueOf(objs);
        }
        StringBuffer buf = new StringBuffer(this.prefix);
        Iterator iter = objs.iterator();
        while (iter.hasNext()) {
            buf.append(this.toString(iter.next()));
            if (!iter.hasNext()) continue;
            buf.append(this.separator);
        }
        buf.append(this.postfix);
        return buf.toString();
    }

    public String toString(Object obj) {
        if (obj instanceof Object[]) {
            return this.toString((Object[])obj);
        }
        if (obj instanceof Collection) {
            return this.toString((Collection)obj);
        }
        if (obj instanceof Map) {
            return this.toString((Map)obj);
        }
        if (obj instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)obj;
            return entry.getKey() + "=" + this.toString(entry.getValue());
        }
        return String.valueOf(obj);
    }
}

