/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.Files;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CommandLineOptionsParser {
    private Map params = new HashMap();
    private Files fileUtil = new Files();

    public CommandLineOptionsParser(String[] args) {
        this(Arrays.asList(args));
    }

    public CommandLineOptionsParser(List args) {
        int i = 0;
        while (i < args.size()) {
            int equalsPos;
            String arg = (String)args.get(i);
            if (arg.startsWith("--")) {
                arg = arg.substring(2);
            }
            if ((equalsPos = arg.indexOf("=")) == -1) {
                equalsPos = arg.length();
            }
            String key = arg.substring(0, equalsPos).trim();
            String value = null;
            if (arg.length() > equalsPos) {
                value = arg.substring(equalsPos + 1, arg.length()).trim();
            }
            this.params.put(key, value);
            ++i;
        }
    }

    public boolean containsKey(String key) {
        return this.asMap().containsKey(key);
    }

    public Object remove(String key) {
        return this.asMap().remove(key);
    }

    public Map asMap() {
        return this.params;
    }

    public File getBaseDir() {
        return this.newFile("basedir");
    }

    public File getDataDir() {
        return this.newFile("datadir");
    }

    private File newFile(String key) {
        if (!this.params.containsKey(key)) {
            return this.fileUtil.nullFile();
        }
        return this.fileUtil.newFile(this.params.get(key));
    }

    public String getVersion() {
        return (String)this.params.get("mysql-version");
    }

    public boolean isShutdown() {
        return this.containsKey("shutdown");
    }

    public Integer getKillDelay(PrintStream err) {
        try {
            String killStr = (String)this.params.get("kill-delay");
            if (killStr != null) {
                return new Integer(killStr);
            }
        }
        catch (Exception e) {
            e.printStackTrace(err);
        }
        return null;
    }
}

