/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.lookup.AjLookupEnvironment;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;

public class SuperFixerVisitor
extends ASTVisitor {
    Set superMethodsCalled = new HashSet();
    AbstractMethodDeclaration method;
    ReferenceBinding targetClass;

    SuperFixerVisitor(AbstractMethodDeclaration method, ReferenceBinding targetClass) {
        this.method = method;
        this.targetClass = targetClass;
    }

    public void endVisit(MessageSend call, BlockScope scope) {
        char[] accessName;
        if (call.codegenBinding == null) {
            return;
        }
        MethodBinding superBinding = call.codegenBinding;
        if (superBinding instanceof ProblemMethodBinding) {
            return;
        }
        if (superBinding instanceof InterTypeMethodBinding) {
            return;
        }
        EclipseFactory factory = ((AjLookupEnvironment)this.method.scope.environment()).factory;
        if (call.isSuperAccess() && !call.binding.isStatic()) {
            call.receiver = new ThisReference(call.receiver.sourceStart, call.receiver.sourceEnd);
            accessName = NameMangler.superDispatchMethod(factory.fromBinding(this.targetClass), new String(superBinding.selector)).toCharArray();
        } else if (call.receiver.isThis() && call.binding.isProtected() && !call.binding.isStatic()) {
            accessName = superBinding.declaringClass.equals(this.targetClass) ? NameMangler.protectedDispatchMethod(factory.fromBinding(this.targetClass), new String(superBinding.selector)).toCharArray() : NameMangler.superDispatchMethod(factory.fromBinding(this.targetClass), new String(superBinding.selector)).toCharArray();
        } else {
            return;
        }
        MethodBinding superAccessBinding = new MethodBinding(1, accessName, superBinding.returnType, superBinding.parameters, superBinding.thrownExceptions, this.targetClass);
        AstUtil.replaceMethodBinding(call, superAccessBinding);
        ResolvedMember targetMember = factory.makeResolvedMember(superBinding);
        this.superMethodsCalled.add(targetMember);
    }
}

