/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.jdbc.Driver;
import com.mysql.management.MysqldResource;
import com.mysql.management.MysqldResourceI;
import com.mysql.management.util.Files;
import com.mysql.management.util.QueryUtil;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.Str;
import com.mysql.management.util.TestUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;

public class AcceptanceTest
extends QuietTestCase {
    private Connection conn = null;
    private File tmpDir;
    private MysqldResourceI mysqld;
    private Files fileUtil;
    private TestUtil testUtil;

    protected void setUp() {
        super.setUp();
        this.fileUtil = new Files();
        this.tmpDir = new Files().testDir();
        this.testUtil = new TestUtil();
    }

    protected void tearDown() {
        super.tearDown();
        if (this.conn != null) {
            try {
                this.conn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.conn = null;
        }
        if (this.mysqld != null) {
            try {
                this.mysqld.setKillDelay(this.testUtil.testKillDelay());
                this.mysqld.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void testMain() throws Exception {
        int port1 = this.testUtil.testPort();
        File baseDir1 = new File(this.tmpDir, "cmxj-dir.1");
        String url1 = "jdbc:mysql://127.0.0.1:" + port1 + "/test";
        String[] startArgs1 = new String[]{"--port=" + port1, "--basedir=" + baseDir1, "--kill-delay=" + this.testUtil.testKillDelay()};
        String[] stopArgs1 = new String[]{"--basedir=" + baseDir1, "--shutdown", "--kill-delay=" + this.testUtil.testKillDelay()};
        MysqldResource.main(startArgs1);
        int port2 = port1 + 1000;
        String url2 = "jdbc:mysql://127.0.0.1:" + port2 + "/test";
        File baseDir2 = new File(this.tmpDir, "cmxj-dir.2");
        String[] startArgs2 = new String[]{"--port=" + port2, "--basedir=" + baseDir2, "--kill-delay=" + this.testUtil.testKillDelay()};
        String[] stopArgs2 = new String[]{"--basedir=" + baseDir2, "--shutdown", "--kill-delay=" + this.testUtil.testKillDelay()};
        MysqldResource.main(startArgs2);
        this.testUtil.assertConnectViaJDBC(url1);
        this.testUtil.assertConnectViaJDBC(url2);
        MysqldResource.main(stopArgs1);
        this.testUtil.assertConnectViaJDBC(url2);
        SQLException expected = null;
        try {
            this.testUtil.assertConnectViaJDBC(url1);
        }
        catch (SQLException e) {
            expected = e;
        }
        AcceptanceTest.assertNotNull((Object)expected);
        MysqldResource.main(stopArgs2);
        expected = null;
        try {
            this.testUtil.assertConnectViaJDBC(url2);
        }
        catch (SQLException e) {
            expected = e;
        }
        AcceptanceTest.assertNotNull((Object)expected);
    }

    public void testCreateUser() throws Exception {
        File baseDir3 = new File(this.tmpDir, "mxj-user-test");
        this.fileUtil.deleteTree(baseDir3);
        this.mysqld = new MysqldResource(baseDir3);
        baseDir3.mkdirs();
        HashMap<String, String> params = new HashMap<String, String>();
        int port = this.testUtil.testPort();
        params.put("port", Integer.toString(port));
        params.put("kill-delay", Integer.toString(this.testUtil.testKillDelay()));
        this.mysqld.start("mxj-user-test", params);
        String url = "jdbc:mysql://localhost:" + port + "/";
        String rootUser = "root";
        String rootPassword = "";
        this.makeDb(url + "test", rootUser, rootPassword);
        this.checkVersion(this.mysqld.getVersion());
        this.conn.close();
        this.conn = null;
        Driver driver = new Driver();
        Properties props = new Properties();
        props.setProperty("user", "JAVA");
        props.setProperty("password", "SAPR3");
        Exception exception = null;
        try {
            this.conn = driver.connect(url + "MY1", props);
        }
        catch (Exception e) {
            exception = e;
        }
        AcceptanceTest.assertNull((String)("" + exception), (Object)exception);
        this.checkVersion(this.mysqld.getVersion());
    }

    private void checkVersion(String version) {
        QueryUtil util = new QueryUtil(this.conn);
        String searchIn = util.queryForString("SELECT VERSION()");
        AcceptanceTest.assertTrue((String)("<" + version + "> not found in <" + searchIn + ">"), (boolean)new Str().containsIgnoreCase(searchIn, version));
    }

    private void makeDb(String url, String userName, String password) throws Exception {
        this.testUtil.assertConnectViaJDBC(url, userName, password, true);
        Class.forName(Driver.class.getName());
        this.conn = DriverManager.getConnection(url, userName, password);
        QueryUtil util = new QueryUtil(this.conn);
        util.execute("CREATE DATABASE MY1");
        util.execute("USE MY1");
        String sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'%' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        util.execute(sql);
        sql = "GRANT ALL PRIVILEGES ON MY1.* TO 'JAVA'@'localhost' IDENTIFIED BY 'SAPR3' WITH GRANT OPTION";
        util.execute(sql);
        util.execute("commit");
    }

    public void testInitializeUser() throws Exception {
        File baseDir4 = new File(this.tmpDir, "mxj-init-user-test");
        this.fileUtil.deleteTree(baseDir4);
        this.mysqld = new MysqldResource(baseDir4);
        this.mysqld.setKillDelay(this.testUtil.testKillDelay());
        HashMap<String, String> params = new HashMap<String, String>();
        int port = this.testUtil.testPort();
        params.put("port", Integer.toString(port));
        String rootUser = "root";
        String rootPass = "";
        String aliceName = "alice";
        String alicePass = "q3htgi98q34";
        this.mysqld.start("init-user", params);
        String url = "jdbc:mysql://127.0.0.1:" + port + "/test";
        this.conn = DriverManager.getConnection(url, rootUser, rootPass);
        QueryUtil util = new QueryUtil(this.conn);
        util.execute("SELECT 1");
        this.conn.close();
        this.conn = null;
        Exception exception = null;
        try {
            this.conn = DriverManager.getConnection(url, aliceName, alicePass);
            AcceptanceTest.fail((String)("Should not be able to connect as " + aliceName));
        }
        catch (Exception e) {
            exception = e;
        }
        AcceptanceTest.assertNotNull((String)("" + exception), (Object)exception);
        this.mysqld.setKillDelay(this.testUtil.testKillDelay());
        this.mysqld.shutdown();
        AcceptanceTest.assertEquals((boolean)false, (boolean)this.mysqld.isRunning());
        this.fileUtil.deleteTree(baseDir4);
        params.put("initialize-user", Boolean.TRUE.toString());
        params.put("initialize-user.user", aliceName);
        params.put("initialize-user.password", alicePass);
        this.mysqld.start("init-user", params);
        this.conn = DriverManager.getConnection(url, aliceName, alicePass);
        util = new QueryUtil(this.conn);
        util.execute("SELECT 1");
        this.conn.close();
        this.conn = null;
        exception = null;
        try {
            this.conn = DriverManager.getConnection(url, rootUser, rootPass);
            AcceptanceTest.fail((String)("Should not be able to connect as " + rootUser));
        }
        catch (Exception e) {
            exception = e;
        }
        AcceptanceTest.assertNotNull((String)("" + exception), (Object)exception);
        this.mysqld.setKillDelay(this.testUtil.testKillDelay());
        this.mysqld.shutdown();
    }
}

