/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management;

import com.mysql.management.MysqldResource;
import com.mysql.management.util.Files;
import com.mysql.management.util.NullPrintStream;
import com.mysql.management.util.QuietTestCase;
import com.mysql.management.util.Shell;
import com.mysql.management.util.Str;
import com.mysql.management.util.Streams;
import com.mysql.management.util.TestUtil;
import com.mysql.management.util.Threads;
import com.mysql.management.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;

public class MysqldResourceTest
extends QuietTestCase {
    private MysqldResource mysqldResource;
    private TestFileUtil fileUtil;
    private TestUtil testUtil;
    private Utils utils;
    private File baseDir;
    private File dataDir;

    protected void setUp() {
        super.setUp();
        this.testUtil = new TestUtil();
        this.fileUtil = new TestFileUtil();
        this.utils = new Utils(this.fileUtil, new Shell.Factory(), new Streams(), new Threads(), new Str());
        this.baseDir = new File(this.fileUtil.testDir(), "MRTest");
        this.dataDir = new File(this.baseDir, "data");
        this.fileUtil.deleteTree(this.baseDir);
        if (this.baseDir.exists()) {
            this.warn("residual files");
        }
        this.mysqldResource = new MysqldResource(this.baseDir, this.dataDir, null, System.out, System.err, this.utils);
        this.mysqldResource.setKillDelay(this.testUtil.testKillDelay());
    }

    protected void tearDown() {
        this.utils.threads().pause(50);
        try {
            if (this.mysqldResource.isRunning()) {
                this.mysqldResource.setKillDelay(this.testUtil.testKillDelay());
                this.mysqldResource.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fileUtil.deleteTree(this.baseDir);
        super.tearDown();
    }

    private void setSystemPropertiesToWinNT() {
        this.mysqldResource.setOsAndArch("Windows NT", "x86");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isWindows());
    }

    private void setSytemPropertiesToLinux() {
        this.mysqldResource.setOsAndArch("Linux", "i386");
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.isWindows());
    }

    public void testLaunch() throws Exception {
        HashMap<String, String> args = new HashMap<String, String>();
        String port = "" + this.testUtil.testPort();
        args.put("port", port);
        String url = "jdbc:mysql://localhost:" + port + "/test";
        String threadName = "testLaunch";
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
        this.mysqldResource.start(threadName, args);
        Shell s1 = this.mysqldResource.getShell();
        this.assertRunning();
        for (int i = 0; i < 100 && !this.mysqldResource.isReadyForConnections(); ++i) {
            this.utils.threads().pause(25);
        }
        this.testUtil.assertConnectViaJDBC(url, true);
        this.mysqldResource.start(threadName, args);
        Shell s2 = this.mysqldResource.getShell();
        MysqldResourceTest.assertEquals((Object)s1, (Object)s2);
        MysqldResourceTest.assertTrue((boolean)s1.isDaemon());
        this.assertRunningThenShutdown();
    }

    public void testUseDatabase() throws Exception {
        String url = "jdbc:mysql://localhost:" + this.testUtil.testPort() + "/test";
        String threadName = "testLaunch";
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
        this.startMysql(threadName);
        Shell s1 = this.mysqldResource.getShell();
        this.assertRunning();
        for (int i = 0; i < 100 && !this.mysqldResource.isReadyForConnections(); ++i) {
            this.utils.threads().pause(25);
        }
        this.testUtil.assertConnectViaJDBC(url);
        if (!this.mysqldResource.isWindows()) {
            File sockFile = new File(this.mysqldResource.getDataDir(), "mysql.sock");
            MysqldResourceTest.assertTrue((boolean)sockFile.exists());
        }
        this.mysqldResource.start(threadName, new HashMap());
        Shell s2 = this.mysqldResource.getShell();
        MysqldResourceTest.assertEquals((Object)s1, (Object)s2);
        MysqldResourceTest.assertTrue((boolean)s1.isDaemon());
        this.assertRunningThenShutdown();
    }

    private void startMysql(String threadName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("port", "" + this.testUtil.testPort());
        this.mysqldResource.start(threadName, map);
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
    }

    public void testGetFileName() {
        File mysqld = this.mysqldResource.getMysqldFilePointer();
        MysqldResourceTest.assertNotNull((Object)mysqld);
        String name = mysqld.getPath();
        MysqldResourceTest.assertTrue((String)name, (name.indexOf("mysqld") > 0 ? 1 : 0) != 0);
    }

    public void testWindowsFileName() {
        this.setSystemPropertiesToWinNT();
        String resourceName = this.mysqldResource.getResourceName();
        String fileName = this.mysqldResource.getMysqldFilePointer().getName();
        MysqldResourceTest.assertTrue((resourceName.indexOf(".exe") > 0 ? 1 : 0) != 0);
        MysqldResourceTest.assertTrue((fileName.indexOf(".exe") > 0 ? 1 : 0) != 0);
    }

    public void testUglyPlatformName() {
        MysqldResourceTest.assertEquals((String)"a_b_c_d", (String)this.mysqldResource.stripUnwantedChars("a b/c\\d"));
        this.mysqldResource.setOsAndArch("Bogus OS W/ Spaces", "\\Arch in Space");
        String resourceName = this.mysqldResource.getResourceName();
        MysqldResourceTest.assertTrue((resourceName.indexOf(32) == -1 ? 1 : 0) != 0);
        MysqldResourceTest.assertTrue((resourceName.indexOf(92) == -1 ? 1 : 0) != 0);
        String expected = "Bogus_OS_W__Spaces-_Arch_in_Space";
        MysqldResourceTest.assertTrue((resourceName.indexOf(expected) >= -1 ? 1 : 0) != 0);
    }

    private void checkMysqldFile() {
        File mysqld = this.mysqldResource.makeMysqld();
        MysqldResourceTest.assertTrue((boolean)mysqld.exists());
        MysqldResourceTest.assertTrue((mysqld.length() > 100L ? 1 : 0) != 0);
    }

    public void testGetMysqldNative() {
        this.checkMysqldFile();
    }

    public void testGetMysqldWinNT() {
        this.setSystemPropertiesToWinNT();
        this.checkMysqldFile();
    }

    public void testGetMysqldLinux() {
        this.setSytemPropertiesToLinux();
        this.checkMysqldFile();
        MysqldResourceTest.assertTrue((boolean)this.fileUtil.madeExecutable(this.mysqldResource.getMysqldFilePointer()));
    }

    public void testUnknownOs() {
        this.mysqldResource.setOsAndArch("bogus", "x86");
        MissingResourceException expected = null;
        try {
            this.mysqldResource.makeMysqld();
        }
        catch (MissingResourceException e) {
            expected = e;
        }
        MysqldResourceTest.assertNotNull((String)("" + this.mysqldResource.getMysqldFilePointer()), (Object)expected);
        MysqldResourceTest.assertTrue((expected.getMessage().indexOf("bogus") > 0 ? 1 : 0) != 0);
    }

    public void testCreateDbFiles() {
        new Files().deleteTree(this.dataDir);
        File dbDataDir = new File(this.dataDir, "mysql");
        File host_frm = new File(dbDataDir, "host.frm");
        MysqldResourceTest.assertEquals((boolean)false, (boolean)host_frm.exists());
        MysqldResourceTest.assertEquals((boolean)false, (boolean)this.dataDir.exists());
        this.mysqldResource.ensureEssentialFilesExist();
        MysqldResourceTest.assertTrue((boolean)host_frm.exists());
    }

    public void testBug35804() {
        this.testCreateDbFiles();
        File dbDataDir = new File(this.dataDir, "mysql");
        File host_frm = new File(dbDataDir, "host.frm");
        MysqldResourceTest.assertTrue((boolean)host_frm.delete());
        MysqldResourceTest.assertFalse((boolean)host_frm.exists());
        this.mysqldResource.ensureEssentialFilesExist();
        MysqldResourceTest.assertFalse((boolean)host_frm.exists());
    }

    private void assertRunningThenShutdown() {
        this.assertRunning();
        this.mysqldResource.shutdown();
        this.assertNotRunning();
    }

    private void assertNotRunning() {
        for (int i = 0; i < 500 && this.mysqldResource.isRunning(); ++i) {
            this.utils.threads().pause(25);
        }
        MysqldResourceTest.assertFalse((String)"mysqld should not be running", (boolean)this.mysqldResource.isRunning());
    }

    private void assertRunning() {
        for (int i = 0; i < 500 && !this.mysqldResource.isRunning(); ++i) {
            this.utils.threads().pause(25);
        }
        MysqldResourceTest.assertTrue((String)"mysqld should be running", (boolean)this.mysqldResource.isRunning());
    }

    public void testServerOptions() {
        Map optionsMap = this.mysqldResource.getServerOptions();
        String expectedBaseDir = this.mysqldResource.getBaseDir().getPath();
        MysqldResourceTest.assertEquals((Object)expectedBaseDir, optionsMap.get("basedir"));
    }

    public void testTestReporting() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        this.mysqldResource = new MysqldResource(this.baseDir, this.dataDir, null, captured, captured, this.utils);
        this.mysqldResource.reportIfNoPidfile(true);
        captured.flush();
        MysqldResourceTest.assertEquals((String)"", (String)new String(baos.toByteArray()));
        this.mysqldResource.reportIfNoPidfile(false);
        captured.flush();
        String output = new String(baos.toByteArray());
        this.testUtil.assertContainsIgnoreCase(output, "pid-file not found");
        this.testUtil.assertContainsIgnoreCase(output, this.baseDir.toString());
    }

    public void testForceKill() {
        this.startMysql("killMe");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
        this.mysqldResource.issueForceKill();
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.isRunning());
    }

    public void testDestroyShell() {
        this.startMysql("DestroyMe");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.isRunning());
        this.mysqldResource.destroyShell();
        if (this.mysqldResource.isRunning()) {
            new MysqldResource(this.fileUtil.nullFile()).shutdown();
        }
    }

    public void testVersion() {
        MysqldResourceTest.assertNotNull((Object)this.mysqldResource.getVersion());
        MysqldResourceTest.assertTrue((this.mysqldResource.getVersion().indexOf("5") >= 0 ? 1 : 0) != 0);
        this.mysqldResource.setVersion("5.11.42");
        MysqldResourceTest.assertEquals((String)"5.11.42", (String)this.mysqldResource.getVersion());
    }

    public void testNoPidFile() {
        MysqldResourceTest.assertEquals((String)this.mysqldResource.pid(), (String)"No PID");
        this.startMysql("pid file");
        MysqldResourceTest.assertTrue((Integer.parseInt(this.mysqldResource.pid()) > 0 ? 1 : 0) != 0);
    }

    public void testTestFinalize() throws Throwable {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        this.mysqldResource = new MysqldResource(this.baseDir, this.dataDir, "", captured, captured, this.utils);
        this.mysqldResource.finalize();
        captured.flush();
        String output = new String(baos.toByteArray());
        MysqldResourceTest.assertEquals((String)"", (String)output);
        NullPrintStream devNull = new NullPrintStream();
        String[] none = new String[]{};
        this.mysqldResource.setShell(new Shell.Default(none, "bogus", devNull, devNull));
        this.mysqldResource.finalize();
        captured.flush();
        output = new String(baos.toByteArray());
        this.testUtil.assertContainsIgnoreCase(output, "MysqldResource.initTrace");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUsage() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream captured = new PrintStream(baos);
        PrintStream stdout = System.out;
        System.setOut(new PrintStream(captured));
        try {
            MysqldResource.main(new String[]{"--help"});
        }
        finally {
            System.setOut(stdout);
        }
        MysqldResourceTest.assertTrue((baos.toString().indexOf("Usage") >= 0 ? 1 : 0) != 0);
    }

    public void testJarName() {
        Properties props = this.utils.streams().loadProperties("connector-mxj.properties", System.err);
        String expected = props.getProperty("windows-share-dir-jar", "win_share_dir.jar");
        this.setSystemPropertiesToWinNT();
        MysqldResourceTest.assertEquals((String)expected, (String)this.mysqldResource.shareJar());
        this.setSytemPropertiesToLinux();
        MysqldResourceTest.assertEquals((String)"share_dir.jar", (String)this.mysqldResource.shareJar());
    }

    public void testCanConnectToServer() {
        MysqldResourceTest.assertFalse((boolean)this.mysqldResource.canConnectToServer(this.testUtil.testPort(), 1));
        this.startMysql("testCanConnectToServer");
        MysqldResourceTest.assertTrue((boolean)this.mysqldResource.canConnectToServer(this.testUtil.testPort(), 1));
    }

    public void testPlatformMapProperties() {
        this.mysqldResource.setOsAndArch("Linux", "x86_64");
        MysqldResourceTest.assertEquals((String)"Linux-i386", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Linux", "i686");
        MysqldResourceTest.assertEquals((String)"Linux-i386", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Windows NT", "x86");
        MysqldResourceTest.assertEquals((String)"Win-x86", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Windows XP", "x86");
        MysqldResourceTest.assertEquals((String)"Win-x86", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Mac OS X", "i386");
        MysqldResourceTest.assertEquals((String)"Mac_OS_X-i386", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("Mac OS X", "ppc");
        MysqldResourceTest.assertEquals((String)"Mac_OS_X-ppc", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("SunOS", "sparc");
        MysqldResourceTest.assertEquals((String)"SunOS-sparc", (String)this.mysqldResource.os_arch());
        this.mysqldResource.setOsAndArch("SunOS", "i386");
        MysqldResourceTest.assertEquals((String)"SunOS-i386", (String)this.mysqldResource.os_arch());
    }

    public void testGetWindowsKillCommand() {
        Properties props = new Properties();
        MysqldResourceTest.assertEquals((String)"kill.exe", (String)this.mysqldResource.getWindowsKillCommand(props));
        props.setProperty("windows-kill-command", " kill.exe ");
        MysqldResourceTest.assertEquals((String)"kill.exe", (String)this.mysqldResource.getWindowsKillCommand(props));
        props.setProperty("windows-kill-command", " ");
        MysqldResourceTest.assertEquals((String)"kill.exe", (String)this.mysqldResource.getWindowsKillCommand(props));
        props.setProperty("windows-kill-command", " foo.bar ");
        MysqldResourceTest.assertEquals((String)"foo.bar", (String)this.mysqldResource.getWindowsKillCommand(props));
    }

    private static class TestFileUtil
    extends Files {
        private List execFiles = new ArrayList();

        private TestFileUtil() {
        }

        public void addExecutableRights(File mysqld, PrintStream out, PrintStream err) {
            this.execFiles.add(mysqld);
            super.addExecutableRights(mysqld, out, err);
        }

        public boolean madeExecutable(File file) {
            return this.execFiles.contains(file);
        }
    }
}

