/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchDocument;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.jdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;

public abstract class AbstractIndexer
implements IIndexConstants {
    SearchDocument document;
    String indexPath;

    public AbstractIndexer(SearchDocument document, String indexPath) {
        this.document = document;
        this.indexPath = indexPath;
    }

    public void addClassDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[] superclass, char[][] superinterfaces) {
        this.addIndexEntry(IIndexConstants.TYPE_DECL, TypeDeclarationPattern.createIndexKey(packageName, enclosingTypeNames, name, true));
        this.addIndexEntry(IIndexConstants.SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'C', superclass, 'C'));
        if (superinterfaces != null) {
            int i = 0;
            int max = superinterfaces.length;
            while (i < max) {
                this.addIndexEntry(IIndexConstants.SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'C', superinterfaces[i], 'I'));
                ++i;
            }
        }
    }

    public void addConstructorDeclaration(char[] typeName, char[][] parameterTypes, char[][] exceptionTypes) {
        int argCount = parameterTypes == null ? 0 : parameterTypes.length;
        this.addIndexEntry(IIndexConstants.CONSTRUCTOR_DECL, ConstructorPattern.createIndexKey(CharOperation.lastSegment(typeName, '.'), argCount));
        int i = 0;
        while (i < argCount) {
            this.addTypeReference(parameterTypes[i]);
            ++i;
        }
        if (exceptionTypes != null) {
            i = 0;
            int max = exceptionTypes.length;
            while (i < max) {
                this.addTypeReference(exceptionTypes[i]);
                ++i;
            }
        }
    }

    public void addConstructorReference(char[] typeName, int argCount) {
        this.addIndexEntry(IIndexConstants.CONSTRUCTOR_REF, ConstructorPattern.createIndexKey(CharOperation.lastSegment(typeName, '.'), argCount));
    }

    public void addFieldDeclaration(char[] typeName, char[] fieldName) {
        this.addIndexEntry(IIndexConstants.FIELD_DECL, FieldPattern.createIndexKey(fieldName));
        this.addTypeReference(typeName);
    }

    public void addFieldReference(char[] fieldName) {
        this.addIndexEntry(IIndexConstants.FIELD_REF, FieldPattern.createIndexKey(fieldName));
    }

    protected void addIndexEntry(char[] category, char[] key) {
        SearchParticipant.addIndexEntry(category, key, this.document, this.indexPath);
    }

    public void addInterfaceDeclaration(int modifiers, char[] packageName, char[] name, char[][] enclosingTypeNames, char[][] superinterfaces) {
        this.addIndexEntry(IIndexConstants.TYPE_DECL, TypeDeclarationPattern.createIndexKey(packageName, enclosingTypeNames, name, false));
        if (superinterfaces != null) {
            int i = 0;
            int max = superinterfaces.length;
            while (i < max) {
                this.addIndexEntry(IIndexConstants.SUPER_REF, SuperTypeReferencePattern.createIndexKey(modifiers, packageName, name, enclosingTypeNames, 'I', superinterfaces[i], 'I'));
                ++i;
            }
        }
    }

    public void addMethodDeclaration(char[] methodName, char[][] parameterTypes, char[] returnType, char[][] exceptionTypes) {
        int argCount = parameterTypes == null ? 0 : parameterTypes.length;
        this.addIndexEntry(IIndexConstants.METHOD_DECL, MethodPattern.createIndexKey(methodName, argCount));
        int i = 0;
        while (i < argCount) {
            this.addTypeReference(parameterTypes[i]);
            ++i;
        }
        if (exceptionTypes != null) {
            i = 0;
            int max = exceptionTypes.length;
            while (i < max) {
                this.addTypeReference(exceptionTypes[i]);
                ++i;
            }
        }
        if (returnType != null) {
            this.addTypeReference(returnType);
        }
    }

    public void addMethodReference(char[] methodName, int argCount) {
        this.addIndexEntry(IIndexConstants.METHOD_REF, MethodPattern.createIndexKey(methodName, argCount));
    }

    public void addNameReference(char[] name) {
        this.addIndexEntry(IIndexConstants.REF, name);
    }

    public void addTypeReference(char[] typeName) {
        this.addIndexEntry(IIndexConstants.TYPE_REF, TypeReferencePattern.createIndexKey(CharOperation.lastSegment(typeName, '.')));
    }

    public abstract void indexDocument();
}

