/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.CoordinatesTranslator;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.FragmentUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.ProjectionDocument;

public final class ProjectionDocumentManager
implements IDocumentListener,
ISlaveDocumentManager {
    public static final String PROJECTION_DOCUMENTS = "__projectiondocuments";
    private IPositionUpdater fProjectionPositionUpdater;
    private Map fRegistar = new HashMap();

    protected IPositionUpdater getProjectionPositionUpdater() {
        if (this.fProjectionPositionUpdater == null) {
            this.fProjectionPositionUpdater = new FragmentUpdater(PROJECTION_DOCUMENTS);
        }
        return this.fProjectionPositionUpdater;
    }

    private void add(IDocument parent, ProjectionDocument projection) {
        ArrayList<ProjectionDocument> list = (ArrayList<ProjectionDocument>)this.fRegistar.get(parent);
        if (list == null) {
            list = new ArrayList<ProjectionDocument>(1);
            this.fRegistar.put(parent, list);
        }
        list.add(projection);
    }

    private void remove(IDocument parent, ProjectionDocument projection) {
        List list = (List)this.fRegistar.get(parent);
        if (list != null) {
            list.remove(projection);
            if (list.size() == 0) {
                this.fRegistar.remove(parent);
            }
        }
    }

    private boolean hasProjection(IDocument parent) {
        return this.fRegistar.get(parent) instanceof List;
    }

    private Iterator getProjectionsIterator(IDocument parent) {
        List list = (List)this.fRegistar.get(parent);
        if (list != null) {
            return list.iterator();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void fireDocumentEvent(boolean about, DocumentEvent event) {
        parent = event.getDocument();
        e = this.getProjectionsIterator(parent);
        if (e != null) ** GOTO lbl10
        return;
lbl-1000:
        // 1 sources

        {
            document = (ProjectionDocument)e.next();
            if (about) {
                document.parentDocumentAboutToBeChanged(event);
                continue;
            }
            document.parentDocumentChanged(event);
lbl10:
            // 3 sources

            ** while (e.hasNext())
        }
lbl11:
        // 1 sources

    }

    public void documentChanged(DocumentEvent event) {
        this.fireDocumentEvent(false, event);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
        this.fireDocumentEvent(true, event);
    }

    public IDocumentInformationMapping createMasterSlaveMapping(IDocument slave) {
        if (slave instanceof ProjectionDocument) {
            ProjectionDocument projectionDocument = (ProjectionDocument)slave;
            return new CoordinatesTranslator(projectionDocument.getParentDocument(), PROJECTION_DOCUMENTS, projectionDocument, "__fragment_category");
        }
        return null;
    }

    public IDocument createSlaveDocument(IDocument master) {
        if (!master.containsPositionCategory(PROJECTION_DOCUMENTS)) {
            master.addPositionCategory(PROJECTION_DOCUMENTS);
            master.addPositionUpdater(this.getProjectionPositionUpdater());
            master.addDocumentListener(this);
        }
        ProjectionDocument slave = new ProjectionDocument(master, PROJECTION_DOCUMENTS);
        this.add(master, slave);
        return slave;
    }

    public void freeSlaveDocument(IDocument slave) {
        if (!(slave instanceof ProjectionDocument)) {
            return;
        }
        ProjectionDocument projectionDocument = (ProjectionDocument)slave;
        IDocument parent = projectionDocument.getParentDocument();
        this.remove(parent, projectionDocument);
        try {
            if (!this.hasProjection(parent)) {
                parent.removeDocumentListener(this);
                parent.removePositionUpdater(this.getProjectionPositionUpdater());
                parent.removePositionCategory(PROJECTION_DOCUMENTS);
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {}
    }

    public IDocument getMasterDocument(IDocument slave) {
        if (slave instanceof ProjectionDocument) {
            return ((ProjectionDocument)slave).getParentDocument();
        }
        return null;
    }

    public boolean isSlaveDocument(IDocument document) {
        return document instanceof ProjectionDocument;
    }

    public void setAutoExpandMode(IDocument slave, boolean autoExpand) {
    }
}

