/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.model;

import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.model.IModel;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ConfigurationPropertyModel;
import org.eclipse.core.runtime.model.ExtensionModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.Factory;
import org.eclipse.core.runtime.model.LibraryModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginFragmentModel;
import org.eclipse.core.runtime.model.PluginModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.osgi.framework.ServiceReference;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PluginParser
extends DefaultHandler
implements IModel {
    Factory factory;
    String locationName = null;
    Stack stateStack = new Stack();
    Stack objectStack = new Stack();
    Locator locator = null;
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int PLUGIN_STATE = 2;
    private static final int PLUGIN_RUNTIME_STATE = 3;
    private static final int PLUGIN_REQUIRES_STATE = 4;
    private static final int PLUGIN_EXTENSION_POINT_STATE = 5;
    private static final int PLUGIN_EXTENSION_STATE = 6;
    private static final int RUNTIME_LIBRARY_STATE = 7;
    private static final int LIBRARY_EXPORT_STATE = 8;
    private static final int LIBRARY_PACKAGES_STATE = 12;
    private static final int PLUGIN_REQUIRES_IMPORT_STATE = 9;
    private static final int CONFIGURATION_ELEMENT_STATE = 10;
    private static final int FRAGMENT_STATE = 11;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private Vector[] scratchVectors = new Vector[2];
    private ServiceReference parserReference;

    public PluginParser(Factory factory) {
        this.factory = factory;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] ch, int start, int length) {
        int state = (Integer)this.stateStack.peek();
        if (state != 10) {
            return;
        }
        if (state == 10) {
            ConfigurationElementModel currentConfigElement = (ConfigurationElementModel)this.objectStack.peek();
            String value = new String(ch, start, length);
            String oldValue = currentConfigElement.getValueAsIs();
            if (oldValue == null) {
                if (value.trim().length() != 0) {
                    currentConfigElement.setValue(value);
                }
            } else {
                currentConfigElement.setValue(String.valueOf(oldValue) + value);
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String uri, String elementName, String qName) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                this.internalError(Policy.bind("parse.internalStack", elementName));
                break;
            }
            case 2: 
            case 11: {
                Vector extVector;
                if (!elementName.equals("plugin") && !elementName.equals("fragment")) break;
                this.stateStack.pop();
                PluginModel root = (PluginModel)this.objectStack.peek();
                Vector extPointVector = this.scratchVectors[0];
                if (extPointVector.size() > 0) {
                    root.setDeclaredExtensionPoints(extPointVector.toArray(new ExtensionPointModel[extPointVector.size()]));
                    this.scratchVectors[0].removeAllElements();
                }
                if ((extVector = this.scratchVectors[1]).size() <= 0) break;
                root.setDeclaredExtensions(extVector.toArray(new ExtensionModel[extVector.size()]));
                this.scratchVectors[1].removeAllElements();
                break;
            }
            case 3: {
                if (!elementName.equals("runtime")) break;
                this.stateStack.pop();
                Vector libVector = (Vector)this.objectStack.pop();
                if (libVector.size() <= 0) break;
                PluginModel model = (PluginModel)this.objectStack.peek();
                model.setRuntime(libVector.toArray(new LibraryModel[libVector.size()]));
                break;
            }
            case 4: {
                if (!elementName.equals("requires")) break;
                this.stateStack.pop();
                Vector importVector = (Vector)this.objectStack.pop();
                if (importVector.size() <= 0) break;
                PluginModel parentDescriptor = (PluginModel)this.objectStack.peek();
                parentDescriptor.setRequires(importVector.toArray(new PluginPrerequisiteModel[importVector.size()]));
                break;
            }
            case 5: {
                if (!elementName.equals("extension-point")) break;
                this.stateStack.pop();
                break;
            }
            case 6: {
                if (!elementName.equals("extension")) break;
                this.stateStack.pop();
                ExtensionModel currentExtension = (ExtensionModel)this.objectStack.pop();
                PluginModel parent = (PluginModel)this.objectStack.peek();
                currentExtension.setParent(parent);
                this.scratchVectors[1].addElement(currentExtension);
                break;
            }
            case 7: {
                if (!elementName.equals("library")) break;
                LibraryModel curLibrary = (LibraryModel)this.objectStack.pop();
                Vector exportsVector = (Vector)this.objectStack.pop();
                if (exportsVector.size() > 0) {
                    curLibrary.setExports(exportsVector.toArray(new String[exportsVector.size()]));
                }
                Vector libraryVector = (Vector)this.objectStack.peek();
                libraryVector.addElement(curLibrary);
                this.stateStack.pop();
                break;
            }
            case 8: {
                if (!elementName.equals("export")) break;
                this.stateStack.pop();
                break;
            }
            case 9: {
                if (!elementName.equals("import")) break;
                this.stateStack.pop();
                break;
            }
            case 10: {
                this.stateStack.pop();
                ConfigurationElementModel currentConfigElement = (ConfigurationElementModel)this.objectStack.pop();
                String value = currentConfigElement.getValueAsIs();
                if (value != null) {
                    currentConfigElement.setValue(value.trim());
                }
                Object parent = this.objectStack.peek();
                currentConfigElement.setParent(parent);
                if ((Integer)this.stateStack.peek() == 6) {
                    ConfigurationElementModel[] oldValues = ((ExtensionModel)parent).getSubElements();
                    int size = oldValues == null ? 0 : oldValues.length;
                    ConfigurationElementModel[] newValues = new ConfigurationElementModel[size + 1];
                    int i = 0;
                    while (i < size) {
                        newValues[i] = oldValues[i];
                        ++i;
                    }
                    newValues[size] = currentConfigElement;
                    ((ExtensionModel)parent).setSubElements(newValues);
                    break;
                }
                ConfigurationElementModel[] oldValues = ((ConfigurationElementModel)parent).getSubElements();
                int size = oldValues == null ? 0 : oldValues.length;
                ConfigurationElementModel[] newValues = new ConfigurationElementModel[size + 1];
                int i = 0;
                while (i < size) {
                    newValues[i] = oldValues[i];
                    ++i;
                }
                newValues[size] = currentConfigElement;
                ((ConfigurationElementModel)parent).setSubElements(newValues);
            }
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    public void handleExtensionPointState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", "extension-point", elementName));
    }

    public void handleExtensionState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(10));
        ConfigurationElementModel currentConfigurationElement = this.factory.createConfigurationElement();
        this.objectStack.push(currentConfigurationElement);
        currentConfigurationElement.setName(elementName);
        this.parseConfigurationElementAttributes(attributes);
    }

    public void handleInitialState(String elementName, Attributes attributes) {
        if (elementName.equals("plugin")) {
            this.stateStack.push(new Integer(2));
            this.parsePluginAttributes(attributes);
        } else if (elementName.equals("fragment")) {
            this.stateStack.push(new Integer(11));
            this.parseFragmentAttributes(attributes);
        } else {
            this.stateStack.push(new Integer(0));
            this.internalError(Policy.bind("parse.unknownTopElement", elementName));
        }
    }

    public void handleLibraryExportState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", "export", elementName));
    }

    public void handleLibraryState(String elementName, Attributes attributes) {
        if (elementName.equals("export")) {
            this.stateStack.push(new Integer(8));
            LibraryModel currentLib = (LibraryModel)this.objectStack.peek();
            if (attributes == null) {
                return;
            }
            String maskValue = null;
            int len = attributes.getLength();
            int i = 0;
            while (i < len) {
                String attrName = attributes.getLocalName(i);
                String attrValue = attributes.getValue(i).trim();
                if (attrName.equals("name")) {
                    maskValue = attrValue;
                } else {
                    this.internalError(Policy.bind("parse.unknownAttribute", "library", attrName));
                }
                ++i;
            }
            this.objectStack.pop();
            Vector exportMask = (Vector)this.objectStack.peek();
            this.objectStack.push(currentLib);
            if (maskValue != null && !exportMask.contains(maskValue)) {
                exportMask.addElement(maskValue);
            }
            return;
        }
        if (elementName.equals("packages")) {
            LibraryModel currentLib = (LibraryModel)this.objectStack.peek();
            if (attributes == null) {
                return;
            }
            int i = 0;
            while (i < attributes.getLength()) {
                if ("prefixes".equals(attributes.getLocalName(i))) {
                    String line = attributes.getValue(i);
                    String[] prefixes = PluginParser.getArrayFromList(line);
                    currentLib.setPackagePrefixes(prefixes);
                }
                ++i;
            }
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", "library", elementName));
    }

    protected static String[] getArrayFromList(String line) {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(line, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    public void handlePluginState(String elementName, Attributes attributes) {
        if (elementName.equals("runtime")) {
            Object whatIsIt = this.objectStack.peek();
            if (whatIsIt instanceof PluginDescriptorModel && ((PluginDescriptorModel)this.objectStack.peek()).getRuntime() != null || whatIsIt instanceof PluginFragmentModel && ((PluginFragmentModel)this.objectStack.peek()).getRuntime() != null) {
                this.stateStack.push(new Integer(0));
                return;
            }
            this.stateStack.push(new Integer(3));
            this.objectStack.push(new Vector());
            return;
        }
        if (elementName.equals("requires")) {
            this.stateStack.push(new Integer(4));
            this.objectStack.push(new Vector());
            this.parseRequiresAttributes(attributes);
            return;
        }
        if (elementName.equals("extension-point")) {
            this.stateStack.push(new Integer(5));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (elementName.equals("extension")) {
            this.stateStack.push(new Integer(6));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", "plugin / fragment", elementName));
    }

    public void handleRequiresImportState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", "import", elementName));
    }

    public void handleRequiresState(String elementName, Attributes attributes) {
        if (elementName.equals("import")) {
            this.parsePluginRequiresImport(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", "requires", elementName));
    }

    public void handleRuntimeState(String elementName, Attributes attributes) {
        if (elementName.equals("library")) {
            this.stateStack.push(new Integer(7));
            this.parseLibraryAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", "runtime", elementName));
    }

    public void ignoreableWhitespace(char[] ch, int start, int length) {
    }

    private void logStatus(SAXParseException ex) {
        String name = ex.getSystemId();
        if (name == null) {
            name = this.locationName;
        }
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        String msg = name.equals("") ? Policy.bind("parse.error", ex.getMessage()) : Policy.bind("parse.errorNameLineColumn", new String[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()});
        this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, msg, ex));
    }

    public synchronized PluginModel parsePlugin(InputSource in) throws Exception {
        SAXParserFactory factory = this.acquireXMLParsing();
        if (factory == null) {
            return null;
        }
        try {
            this.locationName = in.getSystemId();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/string-interning", true);
            factory.setValidating(false);
            factory.newSAXParser().parse(in, (DefaultHandler)this);
            PluginModel pluginModel = (PluginModel)this.objectStack.pop();
            Object var3_4 = null;
            this.releaseXMLParsing();
            return pluginModel;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.releaseXMLParsing();
            throw throwable;
        }
    }

    private SAXParserFactory acquireXMLParsing() {
        this.parserReference = InternalPlatform.getDefault().getBundleContext().getServiceReference("javax.xml.parsers.SAXParserFactory");
        if (this.parserReference == null) {
            return null;
        }
        return (SAXParserFactory)InternalPlatform.getDefault().getBundleContext().getService(this.parserReference);
    }

    private void releaseXMLParsing() {
        if (this.parserReference != null) {
            InternalPlatform.getDefault().getBundleContext().ungetService(this.parserReference);
        }
    }

    public void parseConfigurationElementAttributes(Attributes attributes) {
        int len;
        ConfigurationElementModel parentConfigurationElement = (ConfigurationElementModel)this.objectStack.peek();
        parentConfigurationElement.setStartLine(this.locator.getLineNumber());
        Vector<ConfigurationPropertyModel> propVector = null;
        int n = len = attributes != null ? attributes.getLength() : 0;
        if (len == 0) {
            return;
        }
        propVector = new Vector<ConfigurationPropertyModel>();
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i);
            ConfigurationPropertyModel currentConfigurationProperty = this.factory.createConfigurationProperty();
            currentConfigurationProperty.setName(attrName);
            currentConfigurationProperty.setValue(attrValue);
            propVector.addElement(currentConfigurationProperty);
            ++i;
        }
        parentConfigurationElement.setProperties(propVector.toArray(new ConfigurationPropertyModel[propVector.size()]));
        propVector = null;
    }

    public void parseExtensionAttributes(Attributes attributes) {
        PluginModel parent = (PluginModel)this.objectStack.peek();
        ExtensionModel currentExtension = this.factory.createExtension();
        currentExtension.setStartLine(this.locator.getLineNumber());
        this.objectStack.push(currentExtension);
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtension.setName(attrValue);
            } else if (attrName.equals("id")) {
                currentExtension.setId(attrValue);
            } else if (attrName.equals("point")) {
                String targetName;
                if (attrValue.lastIndexOf(46) == -1) {
                    String baseId = parent instanceof PluginDescriptorModel ? parent.getId() : ((PluginFragmentModel)parent).getPlugin();
                    targetName = String.valueOf(baseId) + "." + attrValue;
                } else {
                    targetName = attrValue;
                }
                currentExtension.setExtensionPoint(targetName);
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", "extension", attrName));
            }
            ++i;
        }
    }

    public void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPointModel currentExtPoint = this.factory.createExtensionPoint();
        currentExtPoint.setStartLine(this.locator.getLineNumber());
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtPoint.setName(attrValue);
            } else if (attrName.equals("id")) {
                currentExtPoint.setId(attrValue);
            } else if (attrName.equals("schema")) {
                currentExtPoint.setSchema(attrValue);
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", "extension-point", attrName));
            }
            ++i;
        }
        PluginModel root = (PluginModel)this.objectStack.peek();
        currentExtPoint.setParent(root);
        this.scratchVectors[0].addElement(currentExtPoint);
    }

    public void parseFragmentAttributes(Attributes attributes) {
        PluginFragmentModel current = this.factory.createPluginFragment();
        current.setStartLine(this.locator.getLineNumber());
        this.objectStack.push(current);
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                current.setId(attrValue);
            } else if (attrName.equals("name")) {
                current.setName(attrValue);
            } else if (attrName.equals("version")) {
                current.setVersion(attrValue);
            } else if (attrName.equals("provider-name")) {
                current.setProviderName(attrValue);
            } else if (attrName.equals("plugin-id")) {
                current.setPlugin(attrValue);
            } else if (attrName.equals("plugin-version")) {
                current.setPluginVersion(attrValue);
            } else if (attrName.equals("match")) {
                if ("perfect".equals(attrValue)) {
                    current.setMatch((byte)1);
                } else if ("equivalent".equals(attrValue)) {
                    current.setMatch((byte)2);
                } else if ("compatible".equals(attrValue)) {
                    current.setMatch((byte)3);
                } else if ("greaterOrEqual".equals(attrValue)) {
                    current.setMatch((byte)4);
                } else {
                    this.internalError(Policy.bind("parse.validMatch", attrValue));
                }
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", "fragment", attrName));
            }
            ++i;
        }
    }

    public void parseLibraryAttributes(Attributes attributes) {
        this.objectStack.push(new Vector());
        LibraryModel current = this.factory.createLibrary();
        current.setStartLine(this.locator.getLineNumber());
        this.objectStack.push(current);
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                current.setName(attrValue);
            } else if (attrName.equals("type")) {
                if ((attrValue = attrValue.toLowerCase()).equals("code") || attrValue.equals("resource")) {
                    current.setType(attrValue.toLowerCase());
                } else {
                    this.internalError(Policy.bind("parse.unknownLibraryType", attrValue, current.getName()));
                }
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", "library", attrName));
            }
            ++i;
        }
    }

    public void parsePluginAttributes(Attributes attributes) {
        PluginDescriptorModel current = this.factory.createPluginDescriptor();
        current.setStartLine(this.locator.getLineNumber());
        this.objectStack.push(current);
        int len = attributes.getLength();
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("id")) {
                current.setId(attrValue);
            } else if (attrName.equals("name")) {
                current.setName(attrValue);
            } else if (attrName.equals("version")) {
                current.setVersion(attrValue);
            } else if (attrName.equals("vendor-name") || attrName.equals("provider-name")) {
                current.setProviderName(attrValue);
            } else if (attrName.equals("class")) {
                current.setPluginClass(attrValue);
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", "plugin", attrName));
            }
            ++i;
        }
    }

    public void parsePluginRequiresImport(Attributes attributes) {
        PluginPrerequisiteModel current = this.factory.createPluginPrerequisite();
        current.setStartLine(this.locator.getLineNumber());
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("plugin")) {
                current.setPlugin(attrValue);
            } else if (attrName.equals("version")) {
                current.setVersion(attrValue);
            } else if (attrName.equals("optional")) {
                current.setOptional("true".equalsIgnoreCase(attrValue));
            } else if (attrName.equals("match")) {
                if ("perfect".equals(attrValue)) {
                    current.setMatchByte((byte)1);
                } else if ("equivalent".equals(attrValue) || "exact".equals(attrValue)) {
                    current.setMatchByte((byte)2);
                } else if ("compatible".equals(attrValue)) {
                    current.setMatchByte((byte)3);
                } else if ("greaterOrEqual".equals(attrValue)) {
                    current.setMatchByte((byte)4);
                } else {
                    this.internalError(Policy.bind("parse.validMatch", attrValue));
                }
            } else if (attrName.equals("export")) {
                if ("true".equals(attrValue)) {
                    current.setExport(true);
                } else if ("false".equals(attrValue)) {
                    current.setExport(false);
                } else {
                    this.internalError(Policy.bind("parse.validExport", attrValue));
                }
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", "import", attrName));
            }
            ++i;
        }
        ((Vector)this.objectStack.peek()).addElement(current);
    }

    public void parseRequiresAttributes(Attributes attributes) {
    }

    static String replace(String s, String from, String to) {
        String str = s;
        int fromLen = from.length();
        int toLen = to.length();
        int ix = str.indexOf(from);
        while (ix != -1) {
            str = String.valueOf(str.substring(0, ix)) + to + str.substring(ix + fromLen);
            ix = str.indexOf(from, ix + toLen);
        }
        return str;
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
        int i = 0;
        while (i <= 1) {
            this.scratchVectors[i] = new Vector();
            ++i;
        }
    }

    public void startElement(String uri, String elementName, String qName, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(elementName, attributes);
                break;
            }
            case 11: {
                this.handlePluginState(elementName, attributes);
                break;
            }
            case 2: {
                this.handlePluginState(elementName, attributes);
                break;
            }
            case 3: {
                this.handleRuntimeState(elementName, attributes);
                break;
            }
            case 4: {
                this.handleRequiresState(elementName, attributes);
                break;
            }
            case 5: {
                this.handleExtensionPointState(elementName, attributes);
                break;
            }
            case 6: 
            case 10: {
                this.handleExtensionState(elementName, attributes);
                break;
            }
            case 7: {
                this.handleLibraryState(elementName, attributes);
                break;
            }
            case 8: {
                this.handleLibraryExportState(elementName, attributes);
                break;
            }
            case 9: {
                this.handleRequiresImportState(elementName, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
                this.internalError(Policy.bind("parse.unknownTopElement", elementName));
            }
        }
    }

    public void warning(SAXParseException ex) {
        this.logStatus(ex);
    }

    private void internalError(String message) {
        if (this.locationName != null) {
            this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, String.valueOf(this.locationName) + ": " + message, null));
        } else {
            this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, message, null));
        }
    }
}

