/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.naming;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.lang.Coerce;
import com.mchange.v2.ser.SerializableUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;

public class JavaBeanObjectFactory
implements ObjectFactory {
    static final Object NULL_TOKEN = new Object();

    public Object getObjectInstance(Object refObj, Name name, Context nameCtx, Hashtable env) throws Exception {
        if (refObj instanceof Reference) {
            Reference ref = (Reference)refObj;
            HashMap<String, RefAddr> refAddrsMap = new HashMap<String, RefAddr>();
            Enumeration<RefAddr> e = ref.getAll();
            while (e.hasMoreElements()) {
                RefAddr addr = e.nextElement();
                refAddrsMap.put(addr.getType(), addr);
            }
            Class<?> beanClass = Class.forName(ref.getClassName());
            Set refProps = null;
            BinaryRefAddr refPropsRefAddr = (BinaryRefAddr)refAddrsMap.remove("com.mchange.v2.naming.JavaBeanReferenceMaker.REF_PROPS_KEY");
            if (refPropsRefAddr != null) {
                refProps = (Set)SerializableUtils.fromByteArray((byte[])((RefAddr)refPropsRefAddr).getContent());
            }
            Map propMap = this.createPropertyMap(beanClass, refAddrsMap);
            return this.findBean(beanClass, propMap, refProps);
        }
        return null;
    }

    private Map createPropertyMap(Class beanClass, Map refAddrsMap) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        HashMap<String, Object> out = new HashMap<String, Object>();
        int len = pds.length;
        for (int i = 0; i < len; ++i) {
            Object content;
            PropertyDescriptor pd = pds[i];
            String propertyName = pd.getName();
            Class<?> propertyType = pd.getPropertyType();
            Object addr = refAddrsMap.remove(propertyName);
            if (addr == null) continue;
            if (addr instanceof StringRefAddr) {
                content = (String)((StringRefAddr)addr).getContent();
                if (Coerce.canCoerce(propertyType)) {
                    out.put(propertyName, Coerce.toObject((String)content, propertyType));
                    continue;
                }
                PropertyEditor pe = BeansUtils.findPropertyEditor(pd);
                pe.setAsText((String)content);
                out.put(propertyName, pe.getValue());
                continue;
            }
            if (addr instanceof BinaryRefAddr) {
                content = (byte[])((BinaryRefAddr)addr).getContent();
                if (((Object)content).length == 0) {
                    out.put(propertyName, NULL_TOKEN);
                    continue;
                }
                out.put(propertyName, SerializableUtils.fromByteArray((byte[])content));
                continue;
            }
            System.err.println(this.getClass().getName() + ": WARNING -- unknown RefAddr subclass: " + addr.getClass().getName());
        }
        Iterator ii = refAddrsMap.keySet().iterator();
        while (ii.hasNext()) {
            String type = (String)ii.next();
            System.err.println(this.getClass().getName() + ": WARNING -- RefAddr for unknown property: " + type);
        }
        return out;
    }

    protected Object findBean(Class beanClass, Map propertyMap, Set refProps) throws Exception {
        Object bean = beanClass.newInstance();
        BeanInfo bi = Introspector.getBeanInfo(bean.getClass());
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        int len = pds.length;
        for (int i = 0; i < len; ++i) {
            PropertyDescriptor pd = pds[i];
            String propertyName = pd.getName();
            Object value = propertyMap.get(propertyName);
            Method setter = pd.getWriteMethod();
            if (value != null) {
                if (setter != null) {
                    setter.invoke(bean, value == NULL_TOKEN ? null : value);
                    continue;
                }
                System.err.println(this.getClass().getName() + ": Could not restore read-only property '" + propertyName + "'.");
                continue;
            }
            if (setter == null || refProps != null && !refProps.contains(propertyName)) continue;
            System.err.println(this.getClass().getName() + ": WARNING -- Expected writable property '" + propertyName + "' left at default value");
        }
        return bean;
    }
}

