/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.NetscapeCertTypeExtension;
import com.sun.net.ssl.internal.ssl.X500Name;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class X509TrustManagerImpl
implements X509TrustManager {
    private static final boolean a = Debug.a("com.sun.net.ssl.allowV1CACerts", false);
    private static final String b = "2.5.29.19";
    private static final String c = "2.5.29.15";
    private static final String d = "2.5.29.37";
    private static final String e = "2.16.840.1.113730.1.1";
    private static final String f = "1.3.6.1.5.5.7.3.1";
    private static final String g = "1.3.6.1.5.5.7.3.2";
    private static final String h = "2.5.29.37.0";
    private static final String i = "ssl_client";
    private static final String j = "ssl_server";
    private static final String k = "ssl_ca";
    private static final Set l = new HashSet(1);
    private static final X509Certificate[] m = new X509Certificate[0];
    private Set n = new HashSet();
    private Map o = new HashMap();
    private Map p = new HashMap();
    private static final Debug q = Debug.getInstance("ssl");

    X509TrustManagerImpl(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                certificateArray = keyStore.getCertificate(string);
                if (!(certificateArray instanceof X509Certificate)) continue;
                if (q != null && Debug.isOn("trustmanager")) {
                    System.out.println("adding as trusted cert: " + certificateArray);
                }
                this.a((X509Certificate)certificateArray);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            if (q != null && Debug.isOn("trustmanager")) {
                System.out.println("adding private entry as trusted cert: " + certificateArray[0]);
            }
            this.a((X509Certificate)certificateArray[0]);
        }
    }

    private void a(Map map, Principal principal, X509Certificate x509Certificate) {
        ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)map.get(principal);
        if (arrayList == null) {
            arrayList = new ArrayList<X509Certificate>();
            map.put(principal, arrayList);
        }
        arrayList.add(x509Certificate);
    }

    private void a(X509Certificate x509Certificate) {
        this.n.add(x509Certificate);
        Principal principal = x509Certificate.getSubjectDN();
        this.a(this.p, principal, x509Certificate);
        principal = this.a(principal);
        if (principal != null) {
            this.a(this.o, principal, x509Certificate);
        }
    }

    private X509Certificate[] a(X509Certificate[] x509CertificateArray) {
        Object object;
        X509Certificate x509Certificate;
        ArrayList<Object> arrayList = new ArrayList<Object>(x509CertificateArray.length);
        int n = 0;
        while (n < x509CertificateArray.length) {
            x509Certificate = x509CertificateArray[n];
            object = this.c(x509Certificate);
            if (object != null) {
                if (q != null && Debug.isOn("trustmanager")) {
                    System.out.println("updated/found trusted cert: " + object);
                }
                arrayList.add(object);
                return arrayList.toArray(m);
            }
            arrayList.add(x509Certificate);
            ++n;
        }
        x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        object = x509Certificate.getSubjectDN();
        Principal principal = x509Certificate.getIssuerDN();
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        boolean bl = false;
        x500Name = this.a((Principal)object);
        if (x500Name != null && (x500Name2 = this.a(principal)) != null) {
            object = x500Name;
            principal = x500Name2;
            bl = true;
        }
        if (!object.equals(principal)) {
            List list;
            List list2 = list = bl ? (List)this.o.get(principal) : (List)this.p.get(principal);
            if (list != null) {
                X509Certificate x509Certificate2 = (X509Certificate)list.iterator().next();
                if (q != null && Debug.isOn("trustmanager")) {
                    System.out.println("Appended trusted cert: " + x509Certificate2);
                }
                arrayList.add(x509Certificate2);
                return arrayList.toArray(m);
            }
        }
        if (q != null && Debug.isOn("trustmanager")) {
            System.out.println("Could not find trusted cert in chain.");
        }
        return null;
    }

    private void a(X509Certificate x509Certificate, Set set, int n) throws CertificateException {
        set.remove(b);
        if (n == 0) {
            return;
        }
        if (x509Certificate.getExtensionValue(b) == null) {
            if (!a) {
                throw new CertificateException("CA certificate does not include basic constraints extension");
            }
            if (x509Certificate.getVersion() >= 3) {
                throw new CertificateException("Intermediate X.509v3 certificate without basic constraints extension");
            }
        } else {
            int n2 = x509Certificate.getBasicConstraints();
            if (n2 == -2) {
                n2 = Integer.MAX_VALUE;
            }
            if (n2 < 0) {
                throw new CertificateException("End user tried to act as a CA");
            }
            if (n - 1 > n2) {
                throw new CertificateException("Violated path length constraints");
            }
        }
    }

    private void a(X509Certificate x509Certificate, int n, String string) throws CertificateException, Exception {
        Set set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null) {
            set = l;
        }
        this.a(x509Certificate, set, n);
        if (n == 0) {
            this.a(x509Certificate, set, string);
        } else {
            this.a(x509Certificate, set);
        }
        if (!set.isEmpty()) {
            throw new CertificateException("Certificate contains unknown critical extensions: " + set);
        }
    }

    private void a(X509Certificate x509Certificate, Set set, String string) throws CertificateException, IOException {
        List list;
        set.remove(c);
        set.remove(e);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null) {
            if (blArray.length == 0) {
                throw new CertificateException("Invalid key usage extension.");
            }
            boolean bl = blArray[0];
            boolean bl2 = blArray.length >= 3 ? blArray[2] : false;
            String string2 = "Wrong key usage. Expected digitalSignature.";
            String string3 = "Wrong key usage. Expected keyEncipherment.";
            if (string.indexOf("Client") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("DHE_DSS") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("DHE_RSA") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("RSA_EXPORT") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else if (string.indexOf("RSA") != -1) {
                if (!bl2) {
                    throw new CertificateException(string3);
                }
            } else if (string.indexOf("UNKNOWN") != -1) {
                if (!bl) {
                    throw new CertificateException(string2);
                }
            } else {
                throw new CertificateException("Unknown authType" + string);
            }
        }
        if ((list = this.b(x509Certificate)) != null && set.contains(d)) {
            set.remove(d);
            String string4 = "Extended key usage does not permit use for TLS ";
            if (!list.contains(h)) {
                if (string.indexOf("Client") == -1) {
                    if (!list.contains(f)) {
                        throw new CertificateException(String.valueOf(string4) + "server");
                    }
                } else if (!list.contains(g)) {
                    throw new CertificateException(String.valueOf(string4) + "client");
                }
            }
        }
        if (x509Certificate.getExtensionValue(e) != null) {
            String string5 = "Invalid Netscape CertType extension for SSL ";
            if (string.indexOf("Client") != -1) {
                if (!this.a(x509Certificate, i)) {
                    throw new CertificateException(String.valueOf(string5) + "client");
                }
            } else if (!this.a(x509Certificate, j)) {
                throw new CertificateException(String.valueOf(string5) + "server");
            }
        }
    }

    private void a(X509Certificate x509Certificate, Set set) throws CertificateException, IOException {
        set.remove(c);
        set.remove(e);
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (!(blArray == null || blArray.length >= 6 && blArray[5])) {
            throw new CertificateException("Wrong key usage: expect keyCertSign");
        }
        List list = this.b(x509Certificate);
        if (list != null && set.contains(d)) {
            set.remove(d);
            if (!list.contains(h)) {
                throw new CertificateException("Extended key usage in CA certificates must include anyExtendedKeyUsage");
            }
        }
        if (x509Certificate.getExtensionValue(e) != null && !this.a(x509Certificate, k)) {
            throw new CertificateException("Invalid Netscape CertType extension for CA certificate");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.n.size()];
        this.n.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    private List b(X509Certificate x509Certificate) throws CertificateParsingException {
        try {
            byte[] byArray = x509Certificate.getExtensionValue(d);
            if (byArray == null) {
                return null;
            }
            DerValue derValue = new DerValue(byArray);
            byte[] byArray2 = derValue.getOctetString();
            derValue = new DerValue(byArray2);
            if (derValue.tag != 48) {
                throw new IOException("Invalid encoding for ExtendedKeyUsageExtension.");
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            while (derValue.data.available() != 0) {
                DerValue derValue2 = derValue.data.getDerValue();
                arrayList.add(derValue2.getOID().toString());
            }
            return arrayList;
        }
        catch (IOException iOException) {
            CertificateParsingException certificateParsingException = new CertificateParsingException(iOException.getMessage());
            throw certificateParsingException;
        }
    }

    private boolean a(X509Certificate x509Certificate, String string) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getExtensionValue(e);
        if (byArray == null) {
            return false;
        }
        DerInputStream derInputStream = new DerInputStream(byArray);
        byte[] byArray2 = derInputStream.getOctetString();
        byArray2 = new DerValue(byArray2).getUnalignedBitString().toByteArray();
        NetscapeCertTypeExtension netscapeCertTypeExtension = new NetscapeCertTypeExtension(byArray2);
        Boolean bl = (Boolean)netscapeCertTypeExtension.get(string);
        return bl;
    }

    private X509Certificate c(X509Certificate x509Certificate) {
        List list;
        Principal principal = x509Certificate.getSubjectDN();
        Principal principal2 = x509Certificate.getIssuerDN();
        X500Name x500Name = null;
        X500Name x500Name2 = null;
        boolean bl = false;
        x500Name = this.a(principal);
        if (x500Name != null && (x500Name2 = this.a(principal2)) != null) {
            principal = x500Name;
            principal2 = x500Name2;
            bl = true;
        }
        List list2 = list = bl ? (List)this.o.get(principal) : (List)this.p.get(principal);
        if (list == null) {
            return null;
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)iterator.next();
            if (x509Certificate2.equals(x509Certificate)) {
                return x509Certificate;
            }
            Principal principal3 = x509Certificate2.getIssuerDN();
            if (bl) {
                x500Name2 = this.a(principal3);
                if (x500Name2 == null) continue;
                principal3 = x500Name2;
            }
            if (!principal3.equals(principal2) || !x509Certificate2.getPublicKey().equals(publicKey)) continue;
            return x509Certificate2;
        }
        return this.d(x509Certificate);
    }

    private X500Name a(Principal principal) {
        X500Name x500Name;
        try {
            x500Name = X500Name.a(principal);
        }
        catch (IOException iOException) {
            if (q != null && Debug.isOn("trustmanager")) {
                System.out.println("X500Name threw: " + iOException);
            }
            return null;
        }
        return x500Name;
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        return this.isClientTrusted(x509CertificateArray, "UNKNOWN");
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        return this.a(x509CertificateArray, "Client." + string);
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        return this.isServerTrusted(x509CertificateArray, "UNKNOWN");
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        return this.a(x509CertificateArray, string);
    }

    private boolean a(X509Certificate[] x509CertificateArray, String string) {
        if (x509CertificateArray == null || x509CertificateArray.length == 0) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        if ((x509CertificateArray = this.a(x509CertificateArray)) == null) {
            return false;
        }
        Date date = new Date();
        int n = x509CertificateArray.length - 2;
        while (n >= 0) {
            X509Certificate x509Certificate = x509CertificateArray[n + 1];
            X509Certificate x509Certificate2 = x509CertificateArray[n];
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (CertificateException certificateException) {
                if (q != null && Debug.isOn("trustmanager")) {
                    System.out.println("out of date cert: " + x509Certificate2);
                    System.out.println("ext exception was: " + certificateException);
                }
                return false;
            }
            X500Name x500Name = null;
            X500Name x500Name2 = null;
            boolean bl = false;
            Principal principal = x509Certificate.getSubjectDN();
            Principal principal2 = x509Certificate2.getIssuerDN();
            x500Name = this.a(principal);
            if (x500Name != null && (x500Name2 = this.a(principal2)) != null) {
                principal = x500Name;
                principal2 = x500Name2;
                bl = true;
            }
            if (!principal.equals(principal2)) {
                if (q != null && Debug.isOn("trustmanager")) {
                    System.out.println("Certificate chaining error: issuer DN != subject DN (x500=" + bl + ")");
                }
                return false;
            }
            try {
                x509Certificate2.verify(x509Certificate.getPublicKey());
            }
            catch (Exception exception) {
                if (q != null && Debug.isOn("trustmanager")) {
                    System.out.println("verify failed: " + x509Certificate2);
                    System.out.println("verify exception was: " + exception);
                }
                return false;
            }
            try {
                this.a(x509Certificate2, n, string);
            }
            catch (Exception exception) {
                if (q != null && Debug.isOn("trustmanager")) {
                    System.out.println("failed extension check: " + x509Certificate2);
                    System.out.println("ext exception was: " + exception);
                }
                return false;
            }
            --n;
        }
        return true;
    }

    private X509Certificate d(X509Certificate x509Certificate) {
        if (this.n.contains(x509Certificate)) {
            return x509Certificate;
        }
        return null;
    }
}

