/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.jaf;

import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;

import org.jboss.logging.Logger;

/**
 * A pojo service which can be used to populate the JAF MailcapCommandMap with
 * mailcap content-type to DataContentHandler class. The default mailcaps are
 * text/xml, application/xml mapping to org.jboss.webservice.jaf.XMLDataContentHandler
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision$
 * @see javax.activation.DataContentHandler
 * @see javax.activation.MailcapCommandMap
 * @see org.jboss.webservice.jaf.XMLDataContentHandler
 */
public class JAFConfigService
{
   private static Logger log = Logger.getLogger(JAFConfigService.class);
   /**
    * The default mapping is for xml -> XMLDataContentHandler
    */
   private String[] mailcaps = {
      "text/xml;;x-java-content-handler=org.jboss.webservice.jaf.XMLDataContentHandler",
      "application/xml;;x-java-content-handler=org.jboss.webservice.jaf.XMLDataContentHandler"
   };

   public String[] getMailcaps()
   {
      return mailcaps;
   }

   public void setMailcaps(String[] mailcaps)
   {
      this.mailcaps = mailcaps;
   }

   /**
    * Register the mailcaps with the default MailcapCommandMap
    *
    * @throws Exception
    * @see MailcapCommandMap
    */
   public void start() throws Exception
   {
      CommandMap commandMap = CommandMap.getDefaultCommandMap();
      if (commandMap instanceof MailcapCommandMap)
      {
         MailcapCommandMap mailMap = (MailcapCommandMap)commandMap;
         for (int n = 0; n < mailcaps.length; n++)
         {
            String mailcap = mailcaps[n];
            mailMap.addMailcap(mailcap);
            log.debug("Added mailcap: " + mailcap);
         }
      }
      else
      {
         throw new Exception("Cannot handle non-MailcapCommandMap, map="
                 + commandMap);
      }
   }

   /**
    * Do nothing since MailcapCommandMap does not support removal of mailcaps
    *
    * @throws Exception
    */
   public void stop() throws Exception
   {
   }

}
