/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.handler;

// $Id$

import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.encoding.Base64;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.webservice.Constants;

import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import java.util.Iterator;

/**
 * An Axis style handler that gets username/password from SOAP header elements.
 *
 * &lt;soapenv:Header>
 *    &lt;jbws:username actor="http://webservice.jboss.com/ws4ee/login" xmlns:jbws="http://webservice.jboss.com/ws4ee">kermit&lt;/jbws:username>
 *    &lt;jbws:password actor="http://webservice.jboss.com/ws4ee/login" xmlns:jbws="http://webservice.jboss.com/ws4ee">thefrog&lt;/jbws:password>
 * &lt;/soapenv:Header>
 *
 *
 * @author Thomas.Diesler@jboss.org
 * @since 27-April-2004
 */
public class ServerLoginHandler extends BasicHandler
{
   /** @since 4.0.2 */
   static final long serialVersionUID = 8239981936517243635L;

   // provide logging
   private static final Logger log = Logger.getLogger(ServerLoginHandler.class);

   /** Extract the username/password and set principal/credential in the SecurityAssociation.
    */
   public void invoke(MessageContext msgContext) throws AxisFault
   {
      try
      {
         SOAPMessage soapMessage = msgContext.getMessage();
         SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
         Iterator it = soapHeader.extractHeaderElements(Constants.NAMESPACE + "/login");
         while (it.hasNext())
         {
            SOAPHeaderElement element = (SOAPHeaderElement)it.next();
            String localName = element.getElementName().getLocalName();
            String value = element.getValue();
            if (localName.equals("username"))
            {
               SecurityAssociation.setPrincipal(new SimplePrincipal(value));
            }
            if (localName.equals("password"))
            {
               String password = new String(Base64.decode(value));
               SecurityAssociation.setCredential(password);
            }
         }
      }
      catch (SOAPException e)
      {
         log.error("Server login failed: " + e.toString());
         throw new AxisFault("Server login failed", e);
      }
   }
}
