/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.encoding.ser;

// $Id$

import org.jboss.axis.encoding.Deserializer;
import org.jboss.axis.encoding.ser.BaseDeserializerFactory;
import org.jboss.webservice.deployment.BeanXMLMetaData;

import javax.xml.namespace.QName;

/** A factory for the MetaDataBeanDeserializer
 *
 * @author thomas.diesler@jboss.org
 * @version $Revision$
 */
public class MetaDataBeanDeserializerFactory extends BaseDeserializerFactory
{
   /** @since 4.0.2 */
   static final long serialVersionUID = -224671545135141383L;
   
   private BeanXMLMetaData metaData;

   public MetaDataBeanDeserializerFactory(Class javaType, QName xmlType)
   {
      super(MetaDataBeanDeserializer.class, xmlType, javaType);
   }

   public void setMetaData(BeanXMLMetaData metaData)
   {
      this.metaData = metaData;
   }

   protected Deserializer getSpecialized(String mechanismType)
   {
      return newMetaDataBeanDeserializer();
   }

   protected Deserializer getGeneralPurpose(String mechanismType)
   {
      return newMetaDataBeanDeserializer();
   }

   private MetaDataBeanDeserializer newMetaDataBeanDeserializer()
   {
      return new MetaDataBeanDeserializer(javaType, xmlType, metaData);
   }
}
