/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice.client;

import java.util.Iterator;

// $Id$


/**
 * JBossWS client stubs implement this interface.
 *
 * It provides access to the standard properties via convenience methods
 * and adds some propriatary properties as well.
 *
 * for an implementation of the interface see {@link org.jboss.webservice.client.PortProxy}
 *
 * @author Thomas.Diesler@jboss.org
 * @since 09-Nov-2004
 */
public interface Stub extends javax.xml.rpc.Stub
{
   /** Client timeout property: org.jboss.webservice.timeout */
   static final String PROPERTY_CLIENT_TIMEOUT = "org.jboss.webservice.client.timeout";
   /** Transport property: keyStore */
   static final String PROPERTY_KEY_STORE = "org.jboss.webservice.keyStore";
   /** Transport property: keyStorePassword */
   static final String PROPERTY_KEY_STORE_PASSWORD = "org.jboss.webservice.keyStorePassword";
   /** Transport property: keyStoreType */
   static final String PROPERTY_KEY_STORE_TYPE = "org.jboss.webservice.keyStoreType";
   /** Transport property: trustStore */
   static final String PROPERTY_TRUST_STORE = "org.jboss.webservice.trustStore";
   /** Transport property: trustStorePassword */
   static final String PROPERTY_TRUST_STORE_PASSWORD = "org.jboss.webservice.trustStorePassword";
   /** Transport property: trustStoreType */
   static final String PROPERTY_TRUST_STORE_TYPE = "org.jboss.webservice.trustStoreType";

   /** Client timeout property: org.jboss.webservice.client.timeout
    * @deprecated
    */
   static final String CLIENT_TIMEOUT_PROPERTY = PROPERTY_CLIENT_TIMEOUT;

   String getUsername();

   void setUsername(String username);

   String getPassword();

   void setPassword(String password);

   String getEndpointAddress();

   void setEndpointAddress(String endpoint);

   Boolean getSessionMaintain();

   void setSessionMaintain(Boolean maintainSession);

   Integer getTimeout();

   void setTimeout(Integer timeout);

   void addAttachment(String contentID, Object mimepart);

   void removeAttachment(String contentID);

   Iterator getAttachmentIdentifiers();

   Object getAttachment(String contentID);

   Object getTransportOption(String option);

   void setTransportOption(String option, Object value);
}