/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.webservice;

// $Id$

import org.jboss.deployment.DeploymentInfo;
import org.jboss.webservice.deployment.ServiceDescription;
import org.jboss.webservice.metadata.PortComponentMetaData;
import org.jboss.metadata.WebMetaData;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/**
 * This object registered with the AxisService.
 * <p/>
 * The key is [deploymentName]#[port-component-name]
 *
 * @author Thomas.Diesler@jboss.org
 * @since 28-May-2004
 */
public class PortComponentInfo
{
   private DeploymentInfo di;
   private PortComponentMetaData pcMetaData;
   private ServiceDescription serviceDesc;
   private String serviceID;
   private ObjectName objectName;

   public PortComponentInfo(DeploymentInfo di, PortComponentMetaData pcMetaData)
   {
      this.di = di;
      this.pcMetaData = pcMetaData;
      
      String pcName = pcMetaData.getPortComponentName();
      String wsdName = pcMetaData.getWebserviceDescription().getWebserviceDescriptionName();
      this.serviceID = di.getCanonicalName() + "#" + wsdName + "/" + pcName;

      try
      {
         this.objectName = ObjectName.getInstance("jboss.ws4ee:port-component=" + serviceID);
      }
      catch (MalformedObjectNameException e)
      {
         throw new IllegalArgumentException("Invalid serviceID: " + serviceID);
      }
   }

   public String getServiceID()
   {
      return serviceID;
   }

   public ObjectName getObjectName()
   {
      return objectName;
   }

   public DeploymentInfo getDeploymentInfo()
   {
      return di;
   }

   public PortComponentMetaData getPortComponentMetaData()
   {
      return pcMetaData;
   }

   public String getServiceEndpointURL()
   {
      return pcMetaData.getServiceEndpointURL().toExternalForm();
   }

   public void setServiceDesc(ServiceDescription serviceDesc)
   {
      this.serviceDesc = serviceDesc;
   }

   public ServiceDescription getServiceDescription()
   {
      return serviceDesc;
   }

   /** Get the port component classloader */
   public ClassLoader getPortComponentClassLoader()
   {
      if (di.metaData instanceof WebMetaData)
         return ((WebMetaData)di.metaData).getContextLoader();
      else
         return di.ucl;
   }

   /**
    * Returns a string representation of the object.
    */
   public String toString()
   {
      return "[id=" + serviceID + ",address=" + pcMetaData.getServiceEndpointURL() + "]";
   }
}

