/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.webservice.jbws413;

import java.net.URL;

import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;

import junit.framework.Test;

import org.jboss.test.webservice.WebserviceTestBase;

/**
 * JBoss ignores metadata supplied in a JAX-RPC Mapping DD
 *
 * http://jira.jboss.com/jira/browse/JBWS-413
 *
 * @author Thomas.Diesler@jboss.org
 * @since 21-Oct-2005
 */
public class JBWS413TestCase extends WebserviceTestBase
{
   /** Construct the test case with a given name
    */
   public JBWS413TestCase(String name)
   {
      super(name);
   }

   /** Deploy the test */
   public static Test suite() throws Exception
   {
      return getDeploySetup(JBWS413TestCase.class, "ws4ee-jbws413.war, ws4ee-jbws413-client.jar");
   }

   public void testClientAccess() throws Exception
   {
      InitialContext iniCtx = getClientContext();
      Service service = (Service)iniCtx.lookup("java:comp/env/service/TestService");
      TestSEI port = (TestSEI)service.getPort(TestSEI.class);

      JavaType in = new JavaType(new Double[] { new Double(1), new Double(2), new Double(3) });
      JavaType retObj = port.doStuff(in);
      assertEquals(in, retObj);
   }

   /**
    * Auto discover jaxrpc-mapping.xml and other client artifacts
    *
    * http://jira.jboss.com/jira/browse/JBWS-314
    */
   public void testDIIAccess() throws Exception
   {
      String targetEndpoint = "http://" + getServerHost() + ":8080/ws4ee-jbws413";
      String nsURI = "http://org.jboss.test.webservice/jbws413";
      QName serviceName = new QName(nsURI, "TestService");

      ServiceFactory factory = ServiceFactory.newInstance();
      
      // Note, this is a standard call to createService without mappingURL 
      Service service = factory.createService(new URL(targetEndpoint + "?wsdl"), serviceName);
      Call call = service.createCall();
      
      call.setOperationName(new QName(nsURI, "doStuff"));
      call.setTargetEndpointAddress(targetEndpoint);

      JavaType in = new JavaType(new Double[] { new Double(1), new Double(2), new Double(3) });
      Object retObj = call.invoke(new Object[] { in });
      assertEquals(in, retObj);
   }
}
