package org.jboss.test.marshaliiop.test;

import junit.framework.Test;
import org.jboss.test.JBossIIOPTestCase;
import org.jboss.test.marshaliiop.TestPayload;
import org.jboss.test.marshaliiop.interfaces.MarshalSession;
import org.jboss.test.marshaliiop.interfaces.MarshalSessionHome;

import javax.rmi.PortableRemoteObject;
import java.rmi.MarshalException;

/**
 * Test that unmarshall exception is thrown.
 *
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 * @version $Revision$
 */
public class EjbUnMarshalUnitTestCase extends JBossIIOPTestCase
{
   public EjbUnMarshalUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite()
         throws Exception
   {
      return getDeploySetup(EjbUnMarshalUnitTestCase.class, "test-ejb-iiop-unmarshal.jar");
   }

   /**
    * This is a simple test which calls on the MarshalSession bean, passing a TestPayload
    * object as the parameter.  The deployed jar with the MarshalSession should NOT contain
    * the TestPayload class, thus cause there to be a UnmarshalException to be thrown.
    *
    * @throws Exception
    */
   public void testUnMarshalException() throws Exception
   {
      Object objHome = getInitialContext().lookup("marshalliiop/MarshallSession");
      objHome = PortableRemoteObject.narrow(objHome, MarshalSessionHome.class);
      MarshalSessionHome marshalHome = (MarshalSessionHome) objHome;
      MarshalSession marshalSession = marshalHome.create();

      TestPayload payload = new TestPayload();
      try
      {
         marshalSession.testMethod(payload);
         assertTrue("Call on MarshalSession.testMethod() should have thrown UnmarshalException, but did not", false);
      }
      catch (MarshalException e)
      {
         assertTrue(true);
      }
      catch (Throwable thr)
      {
         thr.printStackTrace();
         throw new Exception(thr);
      }
   }

}
