package org.jboss.test.cluster.test;

import junit.framework.Test;

import org.apache.commons.httpclient.HttpClient;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Tests that a clustered session still functions properly on the second
 * node after the webapp is undeployed from the first node.
 * <p/>
 * This version tests a SessionBasedClusteredSession.
 * 
 * @author Brian Stansberry
 * @version $Id$
 */
public class UndeployTestCase extends BaseTest
{
   protected String setUrl_;
   protected String getUrl_;
   protected String setUrlBase_;
   protected String getUrlBase_;
   
   protected boolean deployed0_ = true;
   protected boolean deployed1_ = true;
   
   public UndeployTestCase(String name)
   {
      super(name);
      setUrlBase_ = "setSession.jsp";
      getUrlBase_ = "getAttribute.jsp";

      concatenate();
   }
   
   protected String getContextPath()
   {
      return "/http-scoped/";
   }
   
   protected String getWarName()
   {
      return "http-scoped.war";
   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(UndeployTestCase.class,
            "http-scoped.war");
      return t1;
   }

   /**
    * Main method that deals with the Http Session Replication Test
    *
    * @throws Exception
    */
   public void testNonPrimitiveGet()
         throws Exception
   {
      String attr = "";
      getLog().info("Enter testNonPrimitiveGet");

      getLog().debug(setUrl_ + ":::::::" + getUrl_);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      makeGet(client, baseURL0_ +setUrl_);

      // Create a method instance.
      // Get the Attribute set
      attr = makeGetWithState(client, baseURL0_ +getUrl_);
      
      reconfigureCluster();

      sleepThread(DEFAULT_SLEEP);

      // Make connection to server 1 and get
      setCookieDomainToThisServer(client, servers_[1]);
      String attr2 = makeGetWithState(client, baseURL1_ + getUrl_);

      assertEquals("Get attribute should be but is ", attr, attr2);
      getLog().debug("Exit testNonPrimitiveGet");
   }

   protected void concatenate()
   {
      setUrl_ = getContextPath() +setUrlBase_;
      getUrl_ = getContextPath() +getUrlBase_;
   }   
   
   protected void setUp() throws Exception
   {
      super.setUp();
      configureCluster();
   }

   protected void configureCluster() throws Exception
   {
      RMIAdaptor[] adaptors = getAdaptors();
      String warName = getWarName();
      if (!deployed0_)
      {
         deploy(adaptors[0], warName);
         getLog().debug("Deployed " + warName + " on server0");
         deployed0_ = true;
      }
      if (!deployed1_)
      {
         deploy(adaptors[1], warName);
         getLog().debug("Deployed " + warName + " on server1");
         deployed1_ = true;
      }
   
      sleep(2000);
   }
   
   protected void reconfigureCluster() throws Exception
   {
      RMIAdaptor[] adaptors = getAdaptors();
      deploy(adaptors[1], getWarName());
      deployed1_ = true;
      
      sleep(2000);
      
      undeploy(adaptors[0], getWarName());
      deployed0_ = false;
      
      sleep(2000);
   }

}
