/* 
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb.txtimer;

// $Id$

import javax.ejb.Timer;

/**
 * An implementation can retry the invocation of the ejbTimeout method on a TimedObject.
 *
 * The RetryPolicy is stateless and has no knowledge of the TimedObjectId.
 * It does the invocation through the given TimedObjectInvoker.
 *
 * @author Thomas.Diesler@jboss.org
 * @version $Revision$
 * @since 07-Apr-2004
 */
public interface RetryPolicy
{
   /**
    * Invokes the ejbTimeout method on the TimedObject with the given id.
    *
    * @param invoker the invoker for the TimedObject
    * @param timer   the Timer that is passed to ejbTimeout
    */
   void retryTimeout(TimedObjectInvoker invoker, Timer timer);
}
