/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.ejb.plugins.cmp.jdbc.keygen;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.EJBException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCIdentityColumnCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;

/**
 * Create method that uses the identity_val_local() function in DB2 to get
 * get the ID of the last inserted row, and populate it into the EJB
 * object being created.
 *
 * @author <a href="mailto:dwintschel@esports.com">Daniel Wintschel</a>
 * @version $Revision$
 */
public class JDBCDB2IdentityValLocalCreateCommand extends JDBCIdentityColumnCreateCommand {
    private static final String SQL = "values (identity_val_local())";

    protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx ) throws SQLException {
        int rows = ps.executeUpdate();
        ResultSet results = null;
        try {
            Connection conn = ps.getConnection();
            results = conn.prepareStatement( SQL ).executeQuery();
            if( !results.next() ) {
                throw new EJBException( "identity_val_local() returned an empty ResultSet" );
            }
            pkField.loadInstanceResults( results, 1, ctx );
        } catch( RuntimeException e ) {
            throw e;
        } catch( Exception e ) {
            // throw EJBException to force a rollback as the row has been inserted
            throw new EJBException( "Error extracting identity_val_local()", e );
        } finally {
            JDBCUtil.safeClose( results );
        }
        return rows;
    }
}
