/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$


/**
 * The Validator class is responsible for controlling the validation of content trees during runtime.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public interface Validator
{
   /** Return the current event handler or the default event handler if one hasn't been set.
    */
   ValidationEventHandler getEventHandler() throws JAXBException;

   /** Get the particular property in the underlying implementation of Validator.
    */
   Object getProperty(String name) throws PropertyException;

   /** Allow an application to register a validation event handler.
    */
   void setEventHandler(ValidationEventHandler handler) throws JAXBException;

   /** Set the particular property in the underlying implementation of Validator.
    */
   void setProperty(String name, Object value) throws PropertyException;

   /** Validate the Java content tree starting at subrootObj.
    */
   boolean validate(Object subrootObj) throws JAXBException;

   /** Validate the Java content tree rooted at rootObj.
    */
   boolean validateRoot(Object rootObj) throws JAXBException;
}
