/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.bind;

// $Id$


/**
 * This event indicates that a problem was encountered while validating the incoming XML data during an unmarshal operation,
 * while performing on-demand validation of the Java content tree, or while marshalling the Java content tree back to XML data.
 *
 * @author Thomas.Diesler@jboss.org
 * @since 18-Oct-2004
 */
public interface ValidationEvent
{
   /** Conditions that correspond to the definition of "error" in section 1.2 of the W3C XML 1.0 Recommendation */
   static final int ERROR = 1;
   /** Conditions that correspond to the definition of "fatal error" in section 1.2 of the W3C XML 1.0 Recommendation */
   static final int FATAL_ERROR = 2;
   /** Conditions that are not errors or fatal errors as defined by the XML 1.0 recommendation */
   static final int WARNING = 0;

   /** Retrieve the linked exception for this warning/error.
    */
   Throwable getLinkedException();

   /** Retrieve the locator for this warning/error.
    */
   ValidationEventLocator getLocator();

   /** Retrieve the text message for this warning/error.
    */
   String getMessage();

   /** Retrieve the severity code for this warning/error.
    */
   int getSeverity();
}
