/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.proxy.ejb;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

/**
 * A ForeignTransaction, a marker for when we would have to import a
 * transaction from another vendor. Which we don't do at the moment.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision$
 */
public class ForeignTransaction implements Transaction
{
   public static final ForeignTransaction instance = new ForeignTransaction();
   
   private ForeignTransaction()
   {
   }
   
   public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException,
         SecurityException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public void rollback() throws IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public void setRollbackOnly() throws IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public int getStatus() throws SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }

   public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException,
         SystemException
   {
      throw new UnsupportedOperationException("Foreign Transaction");
   }
}
