/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.test.simplecluster;

import javax.ejb.Remote;
import javax.ejb.Stateful;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.cache.tree.CacheConfig;
import org.jboss.system.server.ServerConfig;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
@Stateful(name="testStateful")
@Clustered
@CacheConfig(maxSize=1000, idleTimeoutSeconds=2)   // this will get evicted the second time eviction thread wakes up
@Remote(StatefulRemote.class)
public class StatefulBean implements java.io.Serializable, StatefulRemote
{
   private int state = 0;

   public int increment()
   {
      System.out.println("INCREMENT - counter: " + (state++));
      return state;
   }
   
   public String getHostAddress()
   {
      return System.getProperty(ServerConfig.SERVER_BIND_ADDRESS);
   }
}
