/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.test.mdb;

import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.DeliveryMode;

import javax.annotation.security.RunAs;

import org.jboss.annotation.security.SecurityDomain;
import org.jboss.logging.Logger;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
@MessageDriven(activationConfig =
        {
        @ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"),
        @ActivationConfigProperty(propertyName="destination", propertyValue="queue/nondurablemdbtest"),
        @ActivationConfigProperty(propertyName="durability", propertyValue="NON_DURABLE")
        })
@RunAs("TestRole")
@SecurityDomain("other")
public class NondurableQueueTestMDB implements MessageListener
{
   private static final Logger log = Logger.getLogger(NondurableQueueTestMDB.class);
   
   public void onMessage(Message recvMsg)
   {
      try
      {
         System.out.println("QueueTestMDB onMessage");
         if (recvMsg.getJMSDeliveryMode() != DeliveryMode.NON_PERSISTENT)
            log.error("Message is PERSISTENT - should be NON PERSISTENT");
         else
            TestStatusBean.nondurableQueueRan++;
      } 
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }
}
