/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.remoting;

import java.io.Serializable;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.serial.io.MarshalledObjectForLocalCalls;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Ejb3Registry;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
public class IsLocalInterceptor implements Interceptor, Serializable
{
   public static final String IS_LOCAL = "IS_LOCAL";
   public String getName()
   {
      return getClass().getName();
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      Object oid = invocation.getMetaData(Dispatcher.DISPATCHER, Dispatcher.OID);
      Container container = Ejb3Registry.getContainer(oid.toString());
      if (container != null)
      {
         Invocation copy = (Invocation)new MarshalledObjectForLocalCalls(invocation).get();
         copy.getMetaData().addMetaData(IS_LOCAL, IS_LOCAL, Boolean.TRUE);
         org.jboss.aop.joinpoint.InvocationResponse response = ((Advisor)container).dynamicInvoke(null, copy);
         invocation.setResponseContextInfo(response.getContextInfo());
         MarshalledObjectForLocalCalls wrapped = (MarshalledObjectForLocalCalls)response.getResponse();
         Object rtn = null;
         if (wrapped != null)
         {
            rtn = wrapped.get();
         }
         return rtn;
      }
      return invocation.invokeNext();
   }
}
