/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/ 
package org.jboss.ejb3.interceptor;

import java.lang.reflect.AccessibleObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.dd.Interceptor;
import org.jboss.ejb3.injection.EJBHandler;
import org.jboss.ejb3.injection.Injector;
import org.jboss.ejb3.injection.JndiInjectHandler;
import org.jboss.ejb3.injection.PersistenceContextHandler;
import org.jboss.ejb3.injection.PersistenceUnitHandler;
import org.jboss.ejb3.injection.PojoInjector;
import org.jboss.ejb3.injection.ResourceHandler;
import org.jboss.ejb3.injection.WebServiceHandler;

/**
 * 
 * @author <a href="kabir.khan@jboss.com">Kabir Khan</a>
 * @version $Revision$
 */
public class InterceptorInjector
{
   EJBContainer container;
   InterceptorInfo info;
   PojoInjector[] injectors;
   protected HashMap<AccessibleObject, Injector> encInjections = new HashMap<AccessibleObject, Injector>();
   
   public InterceptorInjector(Container container, InterceptorInfo info) throws Exception
   {
      this.container = (EJBContainer)container;
      this.info = info;

      List list = new ArrayList();
      list.addAll(JndiInjectHandler.loadInjectors(this));
      ResourceHandler.loadInjectors(this);
      EJBHandler.loadInjectors(this);
      WebServiceHandler.loadInjectors(this);
      //list.addAll(DependsHandler.loadInjectors(this));
      PersistenceContextHandler.loadInjectors(this);
      PersistenceUnitHandler.loadInjectors(this);
      list.addAll(encInjections.values());
      injectors = (PojoInjector[]) list.toArray(new PojoInjector[list.size()]);
   }

   public HashMap<AccessibleObject, Injector> getEncInjections()
   {
      return encInjections;
   }
   
   public Interceptor getXml()
   {
      return info.getXml();
   }
   
   public Class getClazz()
   {
      return info.getClazz();
   }
   
   public Container getContainer()
   {
      return container;
   }
   
   public void inject(BeanContext ctx, Object instance)
   {
      for (PojoInjector injector : injectors)
      {
         injector.inject(ctx, instance);
      }
   }
}
