/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.ejb3.injection;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContextType;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.logging.Logger;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision$
 */
public class ExtendedPersistenceContextInjector implements Injector, PojoInjector
{
   protected static final Logger log = Logger.getLogger(ExtendedPersistenceContextInjector.class);
   protected Container container;
   protected ManagedEntityManagerFactory factory;

   protected ExtendedPersistenceContextInjector(Container container, ManagedEntityManagerFactory factory)
   {
      this.container = container;
      this.factory = factory;
   }

   public void inject(BeanContext ctx)
   {
      inject(ctx, ctx.getInstance());
   }

   public void inject(BeanContext beanContext, Object instance)
   {
      StatefulBeanContext ctx = (StatefulBeanContext)beanContext;
      EntityManager pc = ctx.getExtendedPersistenceContext(factory.getKernelName());
      if (pc == null)
      {
         pc = factory.createEntityManager();
         ctx.addExtendedPersistenceContext(factory.getKernelName(), pc);
      }
   }
   
   public Class getInjectionClass()
   {
      return null;
   }

}
