/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import javax.persistence.PersistenceContextType;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.AbstractEntityManagerImpl;
import org.hibernate.engine.SessionImplementor;

public class EntityManagerImpl
extends AbstractEntityManagerImpl {
    private static Log log = LogFactory.getLog(EntityManagerImpl.class);
    protected Session session;
    protected SessionFactory sessionFactory;
    protected boolean open;
    protected boolean discardOnClose;

    public EntityManagerImpl(SessionFactory sessionFactory, PersistenceContextType pcType, PersistenceUnitTransactionType transactionType, boolean discardOnClose) {
        super(pcType, transactionType);
        this.sessionFactory = sessionFactory;
        this.open = true;
        this.discardOnClose = discardOnClose;
        this.postInit();
    }

    public Session getSession() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if (this.session == null) {
            this.session = this.sessionFactory.openSession();
            if (this.persistenceContextType == PersistenceContextType.TRANSACTION) {
                ((SessionImplementor)this.session).setAutoClear(true);
            }
        }
        return this.session;
    }

    public void close() {
        if (!this.open) {
            throw new IllegalStateException("EntityManager is closed");
        }
        if (!this.discardOnClose && this.isTransactionInProgress()) {
            this.getSession().getTransaction().registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int i) {
                    if (EntityManagerImpl.this.session != null) {
                        if (EntityManagerImpl.this.session.isOpen()) {
                            log.debug((Object)"Closing entity manager after transaction completion");
                            EntityManagerImpl.this.session.close();
                        } else {
                            log.warn((Object)"Entity Manager closed by someone else (hibernate.transaction.auto_close_session must not be used)");
                        }
                    }
                }
            });
        } else if (this.session != null) {
            this.session.close();
        }
        this.open = false;
    }

    public boolean isOpen() {
        try {
            if (this.open) {
                this.getSession().isOpen();
            }
            return this.open;
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
            return false;
        }
    }
}

