/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.trading.constraint.Constraint;
import org.jacorb.trading.impl.OfferListener;
import org.jacorb.trading.impl.ProxySourceAdapter;
import org.jacorb.trading.impl.Recipe;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.util.MessageQueue;
import org.jacorb.trading.util.PropUtil;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTrading.LookupPackage.HowManyProps;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;

public class OfferEvaluator
implements Runnable,
OfferListener {
    private static final int MAX_DYNAMIC_THREADS = 10;
    private static final int MAX_PROXY_THREADS = 10;
    private String m_type;
    private Constraint m_constraint;
    private String m_preference;
    private Policy[] m_policies;
    private SpecifiedProps m_desiredProps;
    private Vector m_sources;
    private int m_matchCard;
    private int m_matchCount;
    private Vector m_results;
    private int m_numProcessed;
    private int m_threadPriority;
    private int m_numDynamicThreads;
    private int m_numProxyThreads;
    private MessageQueue m_proxyQueue;
    private MessageQueue m_dynamicQueue;

    public OfferEvaluator(String type, Constraint constraint, String preference, Policy[] policies, SpecifiedProps desiredProps, Vector sources, int matchCard) {
        this.m_type = type;
        this.m_constraint = constraint;
        this.m_preference = preference;
        this.m_policies = policies;
        this.m_desiredProps = desiredProps;
        this.m_sources = sources;
        this.m_matchCard = matchCard;
        this.m_matchCount = 0;
        this.m_results = new Vector();
        this.m_numProcessed = 0;
        this.m_threadPriority = Thread.currentThread().getPriority();
        if (this.m_threadPriority < 10) {
            ++this.m_threadPriority;
        }
        this.m_numDynamicThreads = 0;
        this.m_numProxyThreads = 0;
        this.m_proxyQueue = new MessageQueue();
        this.m_dynamicQueue = new MessageQueue();
        new Thread(this).start();
    }

    public synchronized Vector getResults() {
        while (!this.getDone()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.m_results;
    }

    public synchronized boolean getDone() {
        boolean result = this.m_matchCard == this.m_matchCount || this.m_numProcessed == this.m_sources.size();
        return result;
    }

    public synchronized boolean offerNotify(SourceAdapter source) {
        this.addSource(source);
        if (this.getDone()) {
            this.notifyAll();
        }
        return !this.getDone();
    }

    public synchronized void sourceNotify(SourceAdapter source) {
        ++this.m_numProcessed;
        if (this.getDone()) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Enumeration e = this.m_sources.elements();
        while (e.hasMoreElements() && !this.getDone()) {
            SourceAdapter source = (SourceAdapter)e.nextElement();
            if (source instanceof ProxySourceAdapter) {
                this.scheduleProxy(source);
                continue;
            }
            if (PropUtil.hasDynamicProperties(source.getProperties())) {
                this.scheduleDynamic(source);
                continue;
            }
            if (this.m_constraint.evaluate(source)) {
                this.offerNotify(source);
            }
            this.sourceNotify(source);
        }
        OfferEvaluator offerEvaluator = this;
        synchronized (offerEvaluator) {
            while (!this.getDone()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.m_dynamicQueue.deactivate();
            this.m_proxyQueue.deactivate();
        }
    }

    protected synchronized void scheduleDynamic(SourceAdapter source) {
        if (this.m_numDynamicThreads < 10) {
            DynEval d = new DynEval(this.m_dynamicQueue, this.m_constraint, this.m_desiredProps, this);
            ++this.m_numDynamicThreads;
            d.setPriority(this.m_threadPriority);
            d.start();
        }
        this.m_dynamicQueue.enqueue(source);
    }

    protected synchronized void scheduleProxy(SourceAdapter source) {
        if (this.m_numProxyThreads < 10) {
            ProxyEval p = new ProxyEval(this.m_proxyQueue, this.m_type, this.m_constraint, this.m_preference, this.m_policies, this.m_desiredProps, this);
            ++this.m_numProxyThreads;
            p.setPriority(this.m_threadPriority);
            p.start();
        }
        this.m_proxyQueue.enqueue(source);
    }

    protected synchronized void addSource(SourceAdapter source) {
        if (this.m_matchCount < this.m_matchCard) {
            this.m_results.addElement(source);
            ++this.m_matchCount;
        }
    }

    protected static class ProxyEval
    extends Thread {
        private MessageQueue m_queue;
        private String m_type;
        private Constraint m_constraint;
        private String m_preference;
        private Policy[] m_policies;
        private SpecifiedProps m_desiredProps;
        private OfferListener m_listener;

        public ProxyEval(MessageQueue queue, String type, Constraint constraint, String preference, Policy[] policies, SpecifiedProps desiredProps, OfferListener listener) {
            this.m_queue = queue;
            this.m_type = type;
            this.m_constraint = constraint;
            this.m_preference = preference;
            this.m_policies = policies;
            this.m_desiredProps = desiredProps;
            this.m_listener = listener;
        }

        public void run() {
            ProxySourceAdapter source;
            while ((source = (ProxySourceAdapter)this.m_queue.dequeue()) != null) {
                String primary;
                String constraint;
                ProxyInfo info = source.getInfo();
                boolean match = false;
                match = info.if_match_all ? true : this.m_constraint.evaluate(source);
                if (match && (constraint = Recipe.rewrite(info.recipe, source, primary = this.m_constraint.getConstraint())) != null) {
                    Policy[] policies = new Policy[this.m_policies.length + info.policies_to_pass_on.length];
                    for (int count = 0; count < this.m_policies.length; ++count) {
                        policies[count] = this.m_policies[count];
                    }
                    for (int i = 0; i < info.policies_to_pass_on.length; ++i) {
                        policies[count++] = info.policies_to_pass_on[i];
                    }
                    try {
                        OfferSeqHolder offers = new OfferSeqHolder();
                        OfferIteratorHolder iter = new OfferIteratorHolder();
                        PolicyNameSeqHolder limits = new PolicyNameSeqHolder();
                        info.target.query(this.m_type, constraint, this.m_preference, policies, this.m_desiredProps, 0, offers, iter, limits);
                        if (iter.value != null) {
                            boolean more;
                            OfferSeqHolder seq = new OfferSeqHolder();
                            block6: do {
                                more = iter.value.next_n(20, seq);
                                for (int i = 0; i < seq.value.length; ++i) {
                                    Offer o = seq.value[i];
                                    SourceAdapter src = new SourceAdapter(o.reference, o.properties);
                                    if (!this.m_listener.offerNotify(src)) continue block6;
                                }
                            } while (more);
                            iter.value.destroy();
                        }
                    }
                    catch (UserException e) {
                    }
                    catch (SystemException e) {
                        // empty catch block
                    }
                }
                this.m_listener.sourceNotify(source);
            }
        }
    }

    protected static class DynEval
    extends Thread {
        private MessageQueue m_queue;
        private Constraint m_constraint;
        private SpecifiedProps m_desiredProps;
        private OfferListener m_listener;

        public DynEval(MessageQueue queue, Constraint constraint, SpecifiedProps desiredProps, OfferListener listener) {
            this.m_queue = queue;
            this.m_constraint = constraint;
            this.m_desiredProps = desiredProps;
            this.m_listener = listener;
        }

        public void run() {
            SourceAdapter source;
            while ((source = (SourceAdapter)this.m_queue.dequeue()) != null) {
                if (this.m_constraint.evaluate(source)) {
                    Property[] props = source.getProperties();
                    if (this.m_desiredProps.discriminator() == HowManyProps.all) {
                        for (int i = 0; i < props.length; ++i) {
                            source.getPropertyValue(props[i].name);
                        }
                    } else if (this.m_desiredProps.discriminator() == HowManyProps.some) {
                        String[] names = this.m_desiredProps.prop_names();
                        for (int i = 0; i < names.length; ++i) {
                            source.getPropertyValue(names[i]);
                        }
                    }
                    this.m_listener.offerNotify(source);
                }
                this.m_listener.sourceNotify(source);
            }
        }
    }
}

