/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.trading.db.simple.offers.Offer;
import org.jacorb.trading.db.simple.offers.ProxyOffer;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.RegisterPackage.OfferInfo;

public class OfferList
implements Serializable {
    private String m_serviceType;
    private Hashtable m_offers;
    private Hashtable m_proxies;
    private int m_nextId;
    private transient boolean m_dirty = true;
    private static final char ID_SEP = '/';
    static final long serialVersionUID = -921492441298318523L;

    private OfferList() {
    }

    public OfferList(String serviceType) {
        this.m_serviceType = serviceType;
        this.m_offers = new Hashtable();
        this.m_proxies = new Hashtable();
        this.m_nextId = 1;
    }

    public String getServiceType() {
        return this.m_serviceType;
    }

    public static boolean validateOfferId(String offerId) {
        boolean result = false;
        if (offerId != null) {
            int index = offerId.indexOf(47);
            result = index > 0;
        }
        return result;
    }

    public boolean exists(String offerId) {
        return this.m_offers.containsKey(offerId) || this.m_proxies.containsKey(offerId);
    }

    public boolean isProxy(String offerId) {
        return this.m_proxies.containsKey(offerId);
    }

    public String create(Object obj, Property[] props) {
        String result = null;
        result = this.m_serviceType + '/' + this.m_nextId;
        ++this.m_nextId;
        Offer offer = new Offer(result, obj, props);
        this.m_offers.put(result, offer);
        this.m_dirty = true;
        return result;
    }

    public String createProxy(Lookup target, Property[] props, boolean ifMatchAll, String recipe, Policy[] policies) {
        String result = null;
        result = this.m_serviceType + '/' + this.m_nextId;
        ++this.m_nextId;
        ProxyOffer proxy = new ProxyOffer(result, target, props, ifMatchAll, recipe, policies);
        this.m_proxies.put(result, proxy);
        this.m_dirty = true;
        return result;
    }

    public void remove(String offerId) {
        if (this.m_offers.containsKey(offerId)) {
            this.m_offers.remove(offerId);
            this.m_dirty = true;
        }
    }

    public void removeProxy(String offerId) {
        if (this.m_proxies.containsKey(offerId)) {
            this.m_proxies.remove(offerId);
            this.m_dirty = true;
        }
    }

    public OfferInfo describe(String offerId) {
        OfferInfo result = null;
        Offer offer = (Offer)this.m_offers.get(offerId);
        if (offer != null) {
            result = offer.describe();
            result.type = this.m_serviceType;
        }
        return result;
    }

    public ProxyInfo describeProxy(String offerId) {
        ProxyInfo result = null;
        ProxyOffer proxy = (ProxyOffer)this.m_proxies.get(offerId);
        if (proxy != null) {
            result = proxy.describe();
            result.type = this.m_serviceType;
        }
        return result;
    }

    public boolean modify(String offerId, Property[] props) {
        boolean result = false;
        Offer offer = (Offer)this.m_offers.get(offerId);
        if (offer != null) {
            offer.modify(props);
            result = true;
            this.m_dirty = true;
        }
        return result;
    }

    public Hashtable getOffers() {
        Hashtable<String, OfferInfo> result = new Hashtable<String, OfferInfo>();
        Enumeration e = this.m_offers.keys();
        while (e.hasMoreElements()) {
            String offerId = (String)e.nextElement();
            Offer offer = (Offer)this.m_offers.get(offerId);
            OfferInfo info = offer.describe();
            info.type = this.m_serviceType;
            result.put(offerId, info);
        }
        return result;
    }

    public String[] getOfferIds() {
        String[] result = new String[this.m_offers.size()];
        int count = 0;
        Enumeration e = this.m_offers.keys();
        while (e.hasMoreElements()) {
            result[count++] = (String)e.nextElement();
        }
        return result;
    }

    public Hashtable getProxyOffers() {
        Hashtable<String, ProxyInfo> result = new Hashtable<String, ProxyInfo>();
        Enumeration e = this.m_proxies.keys();
        while (e.hasMoreElements()) {
            String offerId = (String)e.nextElement();
            ProxyOffer proxy = (ProxyOffer)this.m_proxies.get(offerId);
            ProxyInfo info = proxy.describe();
            info.type = this.m_serviceType;
            result.put(offerId, info);
        }
        return result;
    }

    public String[] getProxyOfferIds() {
        String[] result = new String[this.m_proxies.size()];
        int count = 0;
        Enumeration e = this.m_proxies.keys();
        while (e.hasMoreElements()) {
            result[count++] = (String)e.nextElement();
        }
        return result;
    }

    public static String whichService(String offerId) {
        String result = null;
        int index = offerId.indexOf(47);
        if (index > 0) {
            result = offerId.substring(0, index);
        }
        return result;
    }

    public int hashCode() {
        return this.m_serviceType.hashCode();
    }

    public boolean equals(java.lang.Object o) {
        OfferList list = (OfferList)o;
        return this.m_serviceType.equals(list.m_serviceType);
    }

    public boolean getDirty() {
        return this.m_dirty;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.m_dirty = false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_dirty = false;
    }
}

